/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.DefaultBitOutputStream;
import htsjdk.samtools.cram.structure.CRAMCodecModelContext;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.SliceBlocks;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class SliceBlocksWriteStreams {
    private final CompressionHeader compressionHeader;
    private final ByteArrayOutputStream coreBlockByteOutputStream;
    private final BitOutputStream coreBlockBitOutputStream;
    private final Map<Integer, ByteArrayOutputStream> externalOutputStreams = new TreeMap<Integer, ByteArrayOutputStream>();

    public SliceBlocksWriteStreams(CompressionHeader compressionHeader) {
        this.compressionHeader = compressionHeader;
        this.coreBlockByteOutputStream = new ByteArrayOutputStream();
        this.coreBlockBitOutputStream = new DefaultBitOutputStream(this.coreBlockByteOutputStream);
        for (Integer contentID : compressionHeader.getEncodingMap().getExternalIDs()) {
            this.externalOutputStreams.put(contentID, new ByteArrayOutputStream());
        }
    }

    public BitOutputStream getCoreOutputStream() {
        return this.coreBlockBitOutputStream;
    }

    public ByteArrayOutputStream getExternalOutputStream(Integer contentID) {
        return this.externalOutputStreams.get(contentID);
    }

    public SliceBlocks flushStreamsToBlocks(CRAMCodecModelContext contextModel) {
        this.closeAllStreams();
        Block coreBlock = Block.createRawCoreDataBlock(this.coreBlockByteOutputStream.toByteArray());
        ArrayList<Block> externalBlocks = new ArrayList<Block>();
        this.externalOutputStreams.forEach((contentId, contentStream) -> {
            if (contentId.equals(0)) {
                throw new CRAMException("A valid content ID is required.  Given: " + contentId);
            }
            externalBlocks.add(this.compressionHeader.getEncodingMap().createCompressedBlockForStream(contextModel, (Integer)contentId, (ByteArrayOutputStream)contentStream));
        });
        return new SliceBlocks(coreBlock, externalBlocks);
    }

    private void closeAllStreams() {
        try {
            this.getCoreOutputStream().close();
            for (ByteArrayOutputStream baos : this.externalOutputStreams.values()) {
                baos.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

