/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

public final class Utils {
    private static void reverse(byte[] array, int offset, int size) {
        if (array == null) {
            return;
        }
        int i = offset;
        for (int j = offset + size - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            Utils.reverse(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        } else {
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                byteBuffer.put(i, byteBuffer.get(byteBuffer.limit() - i - 1));
                byteBuffer.put(byteBuffer.limit() - i - 1, byteBuffer.get(i));
            }
        }
    }

    public static int RANSGetCumulativeFrequency(long r, int scaleBits) {
        return (int)(r & (long)((1 << scaleBits) - 1));
    }

    public static long RANSDecodeRenormalize4x8(long r, ByteBuffer byteBuffer) {
        long ret = r;
        while (ret < 0x800000L) {
            ret = ret << 8 | (long)(0xFF & byteBuffer.get());
        }
        return ret;
    }

    public static long RANSDecodeRenormalizeNx16(long r, ByteBuffer byteBuffer) {
        long ret = r;
        if (ret < 32768L) {
            int i = 0xFF & byteBuffer.get() | (0xFF & byteBuffer.get()) << 8;
            ret = ret << 16 | (long)i;
        }
        return ret;
    }

    public static void normaliseFrequenciesOrder0(int[] F, int bits) {
        int T = 0;
        for (int freq : F) {
            T += freq;
        }
        int renormFreq = 1 << bits;
        int m = 0;
        int M = 0;
        for (int symbol = 0; symbol < 256; ++symbol) {
            if (m >= F[symbol]) continue;
            m = F[symbol];
            M = symbol;
        }
        long tr = T > 0 ? ((long)renormFreq << 31) / (long)T + (long)(0x40000000 / T) : 0L;
        int fsum = 0;
        for (int symbol = 0; symbol < 256; ++symbol) {
            if (F[symbol] == 0) continue;
            F[symbol] = (int)((long)F[symbol] * tr >> 31);
            if (F[symbol] == 0) {
                F[symbol] = 1;
            }
            fsum += F[symbol];
        }
        if (fsum < renormFreq) {
            int n = M;
            F[n] = F[n] + (renormFreq - fsum);
        } else if (fsum > renormFreq) {
            int n = M;
            F[n] = F[n] - (fsum - renormFreq);
        }
    }

    public static void normaliseFrequenciesOrder1(int[][] F, int shift) {
        for (int j = 0; j < 256; ++j) {
            if (F[256][j] == 0) continue;
            int bitSize = (int)Math.ceil(Math.log(F[256][j]) / Math.log(2.0));
            if (bitSize > shift) {
                bitSize = shift;
            }
            if (bitSize == 0) {
                bitSize = 1;
            }
            Utils.normaliseFrequenciesOrder0(F[j], bitSize);
        }
    }

    public static void normaliseFrequenciesOrder0Shift(int[] frequencies, int bits) {
        int totalFrequency = 0;
        for (int freq : frequencies) {
            totalFrequency += freq;
        }
        if (totalFrequency == 0 || totalFrequency == 1 << bits) {
            return;
        }
        int shift = 0;
        while (totalFrequency < 1 << bits) {
            totalFrequency *= 2;
            ++shift;
        }
        for (int symbol = 0; symbol < 256; ++symbol) {
            if (frequencies[symbol] == 0) continue;
            int n = symbol;
            frequencies[n] = frequencies[n] << shift;
        }
    }

    public static void normaliseFrequenciesOrder1Shift(int[][] F, int shift) {
        for (int symbol = 0; symbol < 256; ++symbol) {
            if (F[256][symbol] == 0) continue;
            Utils.normaliseFrequenciesOrder0Shift(F[symbol], shift);
        }
    }
}

