/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.ArithmeticDecoder;
import htsjdk.samtools.cram.compression.rans.RANSDecodingSymbol;
import java.nio.ByteBuffer;

public abstract class RANSDecode {
    private ArithmeticDecoder[] D;
    private RANSDecodingSymbol[][] decodingSymbols;

    protected ArithmeticDecoder[] getD() {
        return this.D;
    }

    protected RANSDecodingSymbol[][] getDecodingSymbols() {
        return this.decodingSymbols;
    }

    public abstract ByteBuffer uncompress(ByteBuffer var1);

    protected void initializeRANSDecoder() {
        int i;
        if (this.D == null) {
            this.D = new ArithmeticDecoder[256];
            for (i = 0; i < 256; ++i) {
                this.D[i] = new ArithmeticDecoder();
            }
        } else {
            for (i = 0; i < 256; ++i) {
                this.D[i].reset();
            }
        }
        if (this.decodingSymbols == null) {
            this.decodingSymbols = new RANSDecodingSymbol[256][256];
            for (i = 0; i < this.decodingSymbols.length; ++i) {
                for (int j = 0; j < this.decodingSymbols[i].length; ++j) {
                    this.decodingSymbols[i][j] = new RANSDecodingSymbol();
                }
            }
        } else {
            for (i = 0; i < this.decodingSymbols.length; ++i) {
                for (int j = 0; j < this.decodingSymbols[i].length; ++j) {
                    this.decodingSymbols[i][j].set(0, 0);
                }
            }
        }
    }
}

