/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.nametokenisation;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.range.RangeDecode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Decode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TokenStreams {
    public static final byte TOKEN_TYPE = 0;
    public static final byte TOKEN_STRING = 1;
    public static final byte TOKEN_CHAR = 2;
    public static final byte TOKEN_DIGITS0 = 3;
    public static final byte TOKEN_DZLEN = 4;
    public static final byte TOKEN_DUP = 5;
    public static final byte TOKEN_DIFF = 6;
    public static final byte TOKEN_DIGITS = 7;
    public static final byte TOKEN_DELTA = 8;
    public static final byte TOKEN_DELTA0 = 9;
    public static final byte TOKEN_MATCH = 10;
    public static final byte TOKEN_NOP = 11;
    public static final byte TOKEN_END = 12;
    public static final int TOTAL_TOKEN_TYPES = 13;
    public static final byte TYPE_TOKEN_FLAG_MASK = 63;
    public static final byte DUP_PREVIOUS_STREAM_FLAG_MASK = 64;
    public static final byte NEW_POSITION_FLAG_MASK = -128;
    private static final int DEFAULT_NUMBER_OF_TOKEN_POSITIONS = 30;
    private static int POSITION_INCREMENT = 4;
    private ByteBuffer[][] tokenStreams;

    public TokenStreams(ByteBuffer inputByteBuffer, int useArith, int numNames) {
        int numberOfPreallocatedPositions = this.initializeTokenStreams(30);
        int tokenPosition = -1;
        while (inputByteBuffer.hasRemaining()) {
            ByteBuffer uncompressedTokenStream;
            byte tokenTypeFlags = inputByteBuffer.get();
            boolean startNewPosition = (tokenTypeFlags & 0xFFFFFF80) != 0;
            boolean isDupStream = (tokenTypeFlags & 0x40) != 0;
            int tokenType = tokenTypeFlags & 0x3F;
            if (tokenType < 0 || tokenType > 12) {
                throw new CRAMException("Invalid name tokenizer token stream type: " + tokenType);
            }
            if (startNewPosition) {
                if (++tokenPosition == numberOfPreallocatedPositions) {
                    numberOfPreallocatedPositions = this.reallocateTokenStreams(numberOfPreallocatedPositions);
                }
                if (tokenType != 0) {
                    ByteBuffer typeDataByteBuffer = CompressionUtils.allocateByteBuffer(numNames);
                    typeDataByteBuffer.put(0, (byte)tokenType);
                    for (int i = 1; i < numNames; ++i) {
                        typeDataByteBuffer.put(i, (byte)10);
                    }
                    typeDataByteBuffer.rewind();
                    this.tokenStreams[tokenPosition][0] = typeDataByteBuffer;
                }
            }
            if (isDupStream) {
                int dupPosition = inputByteBuffer.get() & 0xFF;
                int dupType = inputByteBuffer.get() & 0xFF;
                ByteBuffer dupTokenStream = this.tokenStreams[dupPosition][dupType].duplicate();
                dupTokenStream.order(ByteOrder.LITTLE_ENDIAN);
                this.tokenStreams[tokenPosition][tokenType] = dupTokenStream;
                continue;
            }
            int clen = CompressionUtils.readUint7(inputByteBuffer);
            byte[] compressedTokenStream = new byte[clen];
            inputByteBuffer.get(compressedTokenStream, 0, clen);
            if (useArith != 0) {
                RangeDecode rangeDecode = new RangeDecode();
                uncompressedTokenStream = rangeDecode.uncompress(CompressionUtils.wrap(compressedTokenStream));
            } else {
                RANSNx16Decode ransDecode = new RANSNx16Decode();
                uncompressedTokenStream = ransDecode.uncompress(CompressionUtils.wrap(compressedTokenStream));
            }
            this.getStreamsForPos((int)tokenPosition)[tokenType] = uncompressedTokenStream;
        }
    }

    public ByteBuffer[] getStreamsForPos(int pos) {
        return this.tokenStreams[pos];
    }

    public ByteBuffer getStream(int tokenPosition, int tokenType) {
        return this.getStreamsForPos(tokenPosition)[tokenType];
    }

    private int initializeTokenStreams(int preallocatedPositions) {
        this.tokenStreams = new ByteBuffer[preallocatedPositions][];
        for (int i = 0; i < preallocatedPositions; ++i) {
            this.tokenStreams[i] = new ByteBuffer[13];
        }
        return preallocatedPositions;
    }

    private int reallocateTokenStreams(int preallocatedPositions) {
        int i;
        ByteBuffer[][] newTokenStreams = new ByteBuffer[preallocatedPositions + POSITION_INCREMENT][];
        for (i = 0; i < preallocatedPositions; ++i) {
            newTokenStreams[i] = this.tokenStreams[i];
        }
        for (i = 0; i < POSITION_INCREMENT; ++i) {
            newTokenStreams[i + preallocatedPositions] = new ByteBuffer[13];
        }
        this.tokenStreams = newTokenStreams;
        return preallocatedPositions + POSITION_INCREMENT;
    }
}

