/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.nametokenisation;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.nametokenisation.tokens.EncodeToken;
import htsjdk.samtools.cram.compression.range.RangeEncode;
import htsjdk.samtools.cram.compression.range.RangeParams;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Encode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Params;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameTokenisationEncode {
    private static final String READ_NAME_TOK_REGEX = "([a-zA-Z0-9]{1,9})|([^a-zA-Z0-9]+)";
    private static final Pattern READ_NAME_PATTERN = Pattern.compile("([a-zA-Z0-9]{1,9})|([^a-zA-Z0-9]+)");
    private static final String DIGITS0_REGEX = "^0+[0-9]*$";
    private static final Pattern DIGITS0_PATTERN = Pattern.compile("^0+[0-9]*$");
    private static final String DIGITS_REGEX = "^[0-9]+$";
    private static final Pattern DIGITS_PATTERN = Pattern.compile("^[0-9]+$");
    private int maxPositions;
    private int maxStringValueLength;

    public ByteBuffer compress(ByteBuffer inBuffer, boolean useArith, byte nameSeparator) {
        List<String> namesToEncode = NameTokenisationEncode.extractInputNames(inBuffer, 10000, nameSeparator);
        int numNames = namesToEncode.size();
        if (numNames == 0) {
            throw new CRAMException("Name tokenizer input format requires a separator-delimited name list. No delimited names found in input.");
        }
        int uncompressedDataSize = Integer.max(0, inBuffer.limit());
        int outputLen = inBuffer.limit() * 2 + 10000;
        ByteBuffer outBuffer = CompressionUtils.allocateByteBuffer(outputLen);
        outBuffer.putInt(uncompressedDataSize);
        outBuffer.putInt(numNames);
        outBuffer.put((byte)(useArith ? 1 : 0));
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>();
        int[] tokenFrequencies = new int[256];
        ArrayList<List<EncodeToken>> encodedTokensByName = new ArrayList<List<EncodeToken>>(numNames);
        for (int nameIndex = 0; nameIndex < numNames; ++nameIndex) {
            encodedTokensByName.add(this.tokeniseName(namesToEncode.get(nameIndex), nameIndex, encodedTokensByName, nameIndexMap, tokenFrequencies));
        }
        for (int position = 0; position < this.maxPositions; ++position) {
            List<ByteBuffer> streamsForPosition = this.distributeTokensForPosition(encodedTokensByName, position, numNames);
            this.serializeTokenStreams(streamsForPosition, outBuffer, useArith);
        }
        outBuffer.flip();
        return outBuffer;
    }

    private List<EncodeToken> tokeniseName(String name, int nameIndex, List<List<EncodeToken>> encodedTokensByName, HashMap<String, Integer> nameIndexMap, int[] tokenFrequencies) {
        if (nameIndexMap.containsKey(name)) {
            String duplicateIndex = String.valueOf(nameIndex - nameIndexMap.get(name));
            return List.of(new EncodeToken.DupOrDiffToken(5, duplicateIndex));
        }
        ArrayList<EncodeToken> encodedTokens = new ArrayList<EncodeToken>(30);
        encodedTokens.add(0, new EncodeToken.DupOrDiffToken(6, String.valueOf(nameIndex == 0 ? 0 : 1)));
        nameIndexMap.put(name, nameIndex);
        int prevNameIndex = nameIndex - 1;
        Matcher matcher = READ_NAME_PATTERN.matcher(name);
        int i = 1;
        while (matcher.find()) {
            EncodeToken prevToken;
            String fragmentValue;
            int type = 1;
            String relativeValue = fragmentValue = matcher.group();
            if (DIGITS0_PATTERN.matcher(fragmentValue).matches()) {
                type = 3;
            } else if (DIGITS_PATTERN.matcher(fragmentValue).matches()) {
                type = 7;
            } else if (fragmentValue.length() == 1) {
                type = 2;
            }
            EncodeToken encodeToken = prevToken = prevNameIndex >= 0 && encodedTokensByName.get(prevNameIndex).size() > i + 1 ? encodedTokensByName.get(prevNameIndex).get(i) : null;
            if (prevToken != null && prevToken.getTokenType() != 12) {
                if (prevToken.getActualValue().equals(fragmentValue)) {
                    type = 10;
                    relativeValue = null;
                } else if (type == 7 && (prevToken.getTokenType() == 7 || prevToken.getTokenType() == 8)) {
                    d = Integer.parseInt(relativeValue) - Integer.parseInt(prevToken.getActualValue());
                    int n = i;
                    tokenFrequencies[n] = tokenFrequencies[n] + 1;
                    if (d >= 0 && d < 256 && tokenFrequencies[i] > nameIndex / 2) {
                        type = 8;
                        relativeValue = String.valueOf(d);
                    }
                } else if (type == 3 && prevToken.getActualValue().length() == relativeValue.length() && (prevToken.getTokenType() == 3 || prevToken.getTokenType() == 9)) {
                    d = Integer.parseInt(relativeValue) - Integer.parseInt(prevToken.getActualValue());
                    int n = i;
                    tokenFrequencies[n] = tokenFrequencies[n] + 1;
                    if (d >= 0 && d < 256 && tokenFrequencies[i] > nameIndex / 2) {
                        type = 9;
                        relativeValue = String.valueOf(d);
                    }
                }
            }
            encodedTokens.add(new EncodeToken((byte)type, fragmentValue, relativeValue));
            if (type == 1) {
                this.maxStringValueLength = Math.max(this.maxStringValueLength, fragmentValue.length() + 1);
            }
            ++i;
        }
        encodedTokens.add(new EncodeToken.EndToken());
        int currMaxPositions = encodedTokens.size();
        if (this.maxPositions < currMaxPositions) {
            this.maxPositions = currMaxPositions;
        }
        return encodedTokens;
    }

    private static List<String> extractInputNames(ByteBuffer inBuffer, int preAllocationSize, byte nameSeparator) {
        ArrayList<String> names = new ArrayList<String>(preAllocationSize);
        int lastPosition = inBuffer.position();
        while (inBuffer.hasRemaining()) {
            byte currentByte = inBuffer.get();
            if (currentByte != nameSeparator) continue;
            int length = inBuffer.position() - lastPosition;
            byte[] bytes = new byte[length];
            inBuffer.position(lastPosition);
            inBuffer.get(bytes, 0, length);
            names.add(new String(bytes, 0, length - 1, StandardCharsets.UTF_8));
            lastPosition = inBuffer.position();
        }
        return names;
    }

    private List<ByteBuffer> distributeTokensForPosition(List<List<EncodeToken>> tokenAccumulator, int tokenPosition, int numNames) {
        List<ByteBuffer> tokenStreams = Arrays.asList(new ByteBuffer[13]);
        this.getByteBufferFor(tokenStreams, 0, numNames);
        block11: for (int n = 0; n < numNames; ++n) {
            List<EncodeToken> tokensForName = tokenAccumulator.get(n);
            if (tokenPosition > 0 && tokensForName.get(0).getTokenType() == 5 || tokensForName.size() <= tokenPosition) continue;
            EncodeToken encodeToken = tokensForName.get(tokenPosition);
            byte type = encodeToken.getTokenType();
            tokenStreams.get(0).put(type);
            switch (type) {
                case 6: {
                    this.getByteBufferFor(tokenStreams, 6, numNames * 4).putInt(Integer.parseInt(encodeToken.getRelativeValue()));
                    continue block11;
                }
                case 5: {
                    this.getByteBufferFor(tokenStreams, 5, numNames * 4).putInt(Integer.parseInt(encodeToken.getRelativeValue()));
                    continue block11;
                }
                case 1: {
                    NameTokenisationEncode.writeString(this.getByteBufferFor(tokenStreams, 1, numNames * this.maxStringValueLength), encodeToken.getRelativeValue());
                    continue block11;
                }
                case 2: {
                    this.getByteBufferFor(tokenStreams, 2, numNames * 1).put((byte)encodeToken.getRelativeValue().charAt(0));
                    continue block11;
                }
                case 7: {
                    this.getByteBufferFor(tokenStreams, 7, numNames * 4).putInt(Integer.parseInt(encodeToken.getRelativeValue()));
                    continue block11;
                }
                case 3: {
                    this.getByteBufferFor(tokenStreams, 3, numNames * 4).putInt(Integer.parseInt(encodeToken.getRelativeValue()));
                    this.getByteBufferFor(tokenStreams, 4, numNames).put((byte)encodeToken.getRelativeValue().length());
                    continue block11;
                }
                case 8: {
                    this.getByteBufferFor(tokenStreams, 8, numNames * 1).put((byte)Integer.parseInt(encodeToken.getRelativeValue()));
                    continue block11;
                }
                case 9: {
                    this.getByteBufferFor(tokenStreams, 9, numNames * 1).put((byte)Integer.parseInt(encodeToken.getRelativeValue()));
                    continue block11;
                }
                case 10: 
                case 11: 
                case 12: {
                    continue block11;
                }
                default: {
                    throw new CRAMException("Invalid token type: " + type);
                }
            }
        }
        for (int i = 0; i < 13; ++i) {
            if (tokenStreams.get(i) == null) continue;
            tokenStreams.get(i).limit(tokenStreams.get(i).position());
        }
        return tokenStreams;
    }

    private ByteBuffer getByteBufferFor(List<ByteBuffer> tokenStreams, int tokenType, int requiredSize) {
        if (tokenStreams.get(tokenType) == null) {
            tokenStreams.set(tokenType, CompressionUtils.allocateByteBuffer(requiredSize));
        }
        return tokenStreams.get(tokenType);
    }

    private static void writeString(ByteBuffer tokenStreamBuffer, String val) {
        tokenStreamBuffer.put(val.getBytes());
        tokenStreamBuffer.put((byte)0);
    }

    private static ByteBuffer tryCompress(ByteBuffer nameTokenStream, boolean useArith) {
        int bestCompressedLength = 0x40000000;
        ByteBuffer compressedByteBuffer = null;
        if (useArith) {
            int[] rangeEncoderFlagsSets;
            for (int rangeEncoderFlagSet : rangeEncoderFlagsSets = new int[]{0, 1, 64, 65, 128, 129, 193}) {
                if ((rangeEncoderFlagSet & 1) != 0 && nameTokenStream.remaining() < 100 || (rangeEncoderFlagSet & 8) != 0 && nameTokenStream.remaining() % 4 != 0) continue;
                RangeEncode rangeEncode = new RangeEncode();
                nameTokenStream.rewind();
                ByteBuffer tmpByteBuffer = rangeEncode.compress(nameTokenStream, new RangeParams(rangeEncoderFlagSet));
                if (bestCompressedLength <= tmpByteBuffer.limit()) continue;
                bestCompressedLength = tmpByteBuffer.limit();
                compressedByteBuffer = tmpByteBuffer;
            }
        } else {
            int[] ransNx16FlagsSets;
            for (int ransNx16FlagSet : ransNx16FlagsSets = new int[]{0, 1, 64, 65, 128, 129, 193}) {
                if ((ransNx16FlagSet & 1) != 0 && nameTokenStream.remaining() < 100 || (ransNx16FlagSet & 8) != 0 && nameTokenStream.remaining() % 4 != 0) continue;
                RANSNx16Encode ransEncode = new RANSNx16Encode();
                nameTokenStream.rewind();
                ByteBuffer tmpByteBuffer = ransEncode.compress(nameTokenStream, new RANSNx16Params(ransNx16FlagSet));
                if (bestCompressedLength <= tmpByteBuffer.limit()) continue;
                bestCompressedLength = tmpByteBuffer.limit();
                compressedByteBuffer = tmpByteBuffer;
            }
        }
        return compressedByteBuffer;
    }

    private void serializeTokenStreams(List<ByteBuffer> tokenStreams, ByteBuffer outBuffer, boolean useArith) {
        for (int tokenStreamType = 0; tokenStreamType <= 12; ++tokenStreamType) {
            ByteBuffer tokenBytes = tokenStreams.get(tokenStreamType);
            if (tokenBytes == null || tokenBytes.position() <= 0) continue;
            outBuffer.put((byte)(tokenStreamType | (tokenStreamType == 0 ? -128 : 0)));
            ByteBuffer tempOutByteBuffer = NameTokenisationEncode.tryCompress(tokenBytes, useArith);
            CompressionUtils.writeUint7(tempOutByteBuffer.limit(), outBuffer);
            outBuffer.put(tempOutByteBuffer);
        }
    }
}

