/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.fqzcomp;

import htsjdk.samtools.cram.compression.fqzcomp.FQZGlobalFlags;
import htsjdk.samtools.cram.compression.fqzcomp.FQZParam;
import htsjdk.samtools.cram.compression.fqzcomp.FQZUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class FQZParams {
    private static final int NUMBER_OF_SYMBOLS = 256;
    final FQZGlobalFlags fqzFlags;
    final List<FQZParam> fqzParamList;
    final int maxSelector;
    final int maxSymbol;
    final int[] selectorTable = new int[256];

    public FQZParams(ByteBuffer inBuffer) {
        int maxSelector;
        this.fqzFlags = new FQZGlobalFlags(inBuffer);
        int numParamBlock = this.fqzFlags.isMultiParam() ? inBuffer.get() : 1;
        int n = maxSelector = numParamBlock > 1 ? numParamBlock : 0;
        if (this.fqzFlags.hasSelectorTable()) {
            maxSelector = inBuffer.get() & 0xFF;
            FQZUtils.readArray(inBuffer, this.selectorTable, 256);
        } else {
            int i;
            for (i = 0; i < numParamBlock; ++i) {
                this.selectorTable[i] = i;
            }
            for (i = numParamBlock; i < 256; ++i) {
                this.selectorTable[i] = numParamBlock - 1;
            }
        }
        int maxSymbol = 0;
        this.fqzParamList = new ArrayList<FQZParam>(numParamBlock);
        for (int p = 0; p < numParamBlock; ++p) {
            FQZParam fqzparam = new FQZParam(inBuffer, 256);
            this.fqzParamList.add(p, fqzparam);
            if (maxSymbol >= fqzparam.getMaxSymbols()) continue;
            maxSymbol = fqzparam.getMaxSymbols();
        }
        this.maxSelector = maxSelector;
        this.maxSymbol = maxSymbol;
    }

    public FQZGlobalFlags getFQZFlags() {
        return this.fqzFlags;
    }

    public List<FQZParam> getFQZParamList() {
        return this.fqzParamList;
    }

    public int getMaxSelector() {
        return this.maxSelector;
    }

    public int getMaxSymbol() {
        return this.maxSymbol;
    }

    public int[] getSelectorTable() {
        return this.selectorTable;
    }
}

