/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.BZIP2ExternalCompressor;
import htsjdk.samtools.cram.compression.GZIPExternalCompressor;
import htsjdk.samtools.cram.compression.LZMAExternalCompressor;
import htsjdk.samtools.cram.compression.RANS4x8ExternalCompressor;
import htsjdk.samtools.cram.compression.RANSNx16ExternalCompressor;
import htsjdk.samtools.cram.compression.RAWExternalCompressor;
import htsjdk.samtools.cram.compression.fqzcomp.FQZCompDecode;
import htsjdk.samtools.cram.compression.fqzcomp.FQZCompEncode;
import htsjdk.samtools.cram.compression.fqzcomp.FQZCompExternalCompressor;
import htsjdk.samtools.cram.compression.nametokenisation.NameTokenisationDecode;
import htsjdk.samtools.cram.compression.nametokenisation.NameTokenisationEncode;
import htsjdk.samtools.cram.compression.nametokenisation.NameTokeniserExternalCompressor;
import htsjdk.samtools.cram.compression.range.RangeDecode;
import htsjdk.samtools.cram.compression.range.RangeEncode;
import htsjdk.samtools.cram.compression.range.RangeExternalCompressor;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Decode;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Encode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Decode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Encode;
import htsjdk.samtools.cram.structure.CRAMCodecModelContext;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import htsjdk.utils.ValidationUtils;

public abstract class ExternalCompressor {
    public static final int NO_COMPRESSION_ARG = -1;
    private static final String argErrorMessage = "Invalid compression arg (%d) requested for CRAM %s compressor";
    private BlockCompressionMethod method;

    protected ExternalCompressor(BlockCompressionMethod method) {
        this.method = method;
    }

    public abstract byte[] compress(byte[] var1, CRAMCodecModelContext var2);

    public abstract byte[] uncompress(byte[] var1);

    public BlockCompressionMethod getMethod() {
        return this.method;
    }

    public String toString() {
        return this.getMethod().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalCompressor that = (ExternalCompressor)o;
        return this.getMethod() == that.getMethod();
    }

    public int hashCode() {
        return this.getMethod().hashCode();
    }

    public static ExternalCompressor getCompressorForMethod(BlockCompressionMethod compressionMethod, int compressorSpecificArg) {
        switch (compressionMethod) {
            case RAW: {
                ValidationUtils.validateArg(compressorSpecificArg == -1, String.format(argErrorMessage, new Object[]{compressorSpecificArg, compressionMethod}));
                return new RAWExternalCompressor();
            }
            case GZIP: {
                return compressorSpecificArg == -1 ? new GZIPExternalCompressor() : new GZIPExternalCompressor(compressorSpecificArg);
            }
            case LZMA: {
                ValidationUtils.validateArg(compressorSpecificArg == -1, String.format(argErrorMessage, new Object[]{compressorSpecificArg, compressionMethod}));
                return new LZMAExternalCompressor();
            }
            case RANS: {
                return compressorSpecificArg == -1 ? new RANS4x8ExternalCompressor(new RANS4x8Encode(), new RANS4x8Decode()) : new RANS4x8ExternalCompressor(compressorSpecificArg, new RANS4x8Encode(), new RANS4x8Decode());
            }
            case RANSNx16: {
                return compressorSpecificArg == -1 ? new RANSNx16ExternalCompressor(new RANSNx16Encode(), new RANSNx16Decode()) : new RANSNx16ExternalCompressor(compressorSpecificArg, new RANSNx16Encode(), new RANSNx16Decode());
            }
            case ADAPTIVE_ARITHMETIC: {
                return compressorSpecificArg == -1 ? new RangeExternalCompressor(new RangeEncode(), new RangeDecode()) : new RangeExternalCompressor(compressorSpecificArg, new RangeEncode(), new RangeDecode());
            }
            case NAME_TOKENISER: {
                return new NameTokeniserExternalCompressor(new NameTokenisationEncode(), new NameTokenisationDecode());
            }
            case FQZCOMP: {
                return new FQZCompExternalCompressor(new FQZCompEncode(), new FQZCompDecode());
            }
            case BZIP2: {
                ValidationUtils.validateArg(compressorSpecificArg == -1, String.format(argErrorMessage, new Object[]{compressorSpecificArg, compressionMethod}));
                return new BZIP2ExternalCompressor();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown compression method %s", new Object[]{compressionMethod}));
    }
}

