/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.CRAMException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CompressionUtils {
    public static void writeUint7(int i, ByteBuffer cp) {
        int s = 0;
        int X = i;
        do {
            s += 7;
        } while ((X >>= 7) > 0);
        do {
            int s_ = (s -= 7) > 0 ? 1 : 0;
            cp.put((byte)((i >> s & 0x7F) + (s_ << 7)));
        } while (s > 0);
    }

    public static int readUint7(ByteBuffer cp) {
        byte c;
        int i = 0;
        do {
            c = cp.get();
            i = i << 7 | c & 0x7F;
        } while ((c & 0x80) != 0);
        return i;
    }

    public static ByteBuffer encodePack(ByteBuffer inBuffer, ByteBuffer outBuffer, int[] frequencyTable, int[] packMappingTable, int numSymbols) {
        ByteBuffer encodedBuffer;
        int inSize = inBuffer.remaining();
        if (numSymbols <= 1) {
            encodedBuffer = CompressionUtils.allocateByteBuffer(0);
        } else if (numSymbols <= 2) {
            encodedBufferSize = (int)Math.ceil((double)inSize / 8.0);
            encodedBuffer = CompressionUtils.allocateByteBuffer(encodedBufferSize);
            j = -1;
            for (i = 0; i < inSize; ++i) {
                if (i % 8 == 0) {
                    encodedBuffer.put(++j, (byte)0);
                }
                encodedBuffer.put(j, (byte)(encodedBuffer.get(j) + (packMappingTable[inBuffer.get(i) & 0xFF] << i % 8)));
            }
        } else if (numSymbols <= 4) {
            encodedBufferSize = (int)Math.ceil((double)inSize / 4.0);
            encodedBuffer = CompressionUtils.allocateByteBuffer(encodedBufferSize);
            j = -1;
            for (i = 0; i < inSize; ++i) {
                if (i % 4 == 0) {
                    encodedBuffer.put(++j, (byte)0);
                }
                encodedBuffer.put(j, (byte)(encodedBuffer.get(j) + (packMappingTable[inBuffer.get(i) & 0xFF] << i % 4 * 2)));
            }
        } else {
            encodedBufferSize = (int)Math.ceil((double)inSize / 2.0);
            encodedBuffer = CompressionUtils.allocateByteBuffer(encodedBufferSize);
            j = -1;
            for (i = 0; i < inSize; ++i) {
                if (i % 2 == 0) {
                    encodedBuffer.put(++j, (byte)0);
                }
                encodedBuffer.put(j, (byte)(encodedBuffer.get(j) + (packMappingTable[inBuffer.get(i) & 0xFF] << i % 2 * 4)));
            }
        }
        outBuffer.put((byte)numSymbols);
        for (int i = 0; i < 256; ++i) {
            if (frequencyTable[i] <= 0) continue;
            outBuffer.put((byte)i);
        }
        CompressionUtils.writeUint7(encodedBuffer.limit(), outBuffer);
        return encodedBuffer;
    }

    public static ByteBuffer decodePack(ByteBuffer inBuffer, byte[] packMappingTable, int numSymbols, int uncompressedPackOutputLength) {
        ByteBuffer outBufferPack;
        block8: {
            int j;
            block10: {
                block9: {
                    block7: {
                        outBufferPack = CompressionUtils.allocateByteBuffer(uncompressedPackOutputLength);
                        j = 0;
                        if (numSymbols > 1) break block7;
                        for (int i = 0; i < uncompressedPackOutputLength; ++i) {
                            outBufferPack.put(i, packMappingTable[0]);
                        }
                        break block8;
                    }
                    if (numSymbols > 2) break block9;
                    int v = 0;
                    for (int i = 0; i < uncompressedPackOutputLength; ++i) {
                        if (i % 8 == 0) {
                            v = inBuffer.get(j++);
                        }
                        outBufferPack.put(i, packMappingTable[v & 1]);
                        v >>= 1;
                    }
                    break block8;
                }
                if (numSymbols > 4) break block10;
                int v = 0;
                for (int i = 0; i < uncompressedPackOutputLength; ++i) {
                    if (i % 4 == 0) {
                        v = inBuffer.get(j++);
                    }
                    outBufferPack.put(i, packMappingTable[v & 3]);
                    v >>= 2;
                }
                break block8;
            }
            if (numSymbols > 16) break block8;
            int v = 0;
            for (int i = 0; i < uncompressedPackOutputLength; ++i) {
                if (i % 2 == 0) {
                    v = inBuffer.get(j++);
                }
                outBufferPack.put(i, packMappingTable[v & 0xF]);
                v >>= 4;
            }
        }
        return outBufferPack;
    }

    public static ByteBuffer allocateOutputBuffer(int inSize) {
        int compressedSize = inSize + 198147 + 9;
        ByteBuffer outputBuffer = CompressionUtils.allocateByteBuffer(compressedSize);
        if (outputBuffer.remaining() < compressedSize) {
            throw new CRAMException("Failed to allocate sufficient buffer size for RANS coder.");
        }
        return outputBuffer;
    }

    public static ByteBuffer allocateByteBuffer(int bufferSize) {
        return ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer wrap(byte[] inputBytes) {
        return ByteBuffer.wrap(inputBytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer slice(ByteBuffer inputBuffer) {
        return inputBuffer.slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.limit() - buffer.arrayOffset()];
        buffer.get(bytes);
        return bytes;
    }
}

