/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

import htsjdk.samtools.cram.common.CRAMVersion;
import java.util.HashSet;
import java.util.Set;

public final class CramVersions {
    public static final CRAMVersion CRAM_v2_1 = new CRAMVersion(2, 1);
    public static final CRAMVersion CRAM_v3 = new CRAMVersion(3, 0);
    public static final CRAMVersion CRAM_v3_1 = new CRAMVersion(3, 1);
    static final Set<CRAMVersion> supportedCRAMVersions = new HashSet<CRAMVersion>(){
        {
            this.add(CRAM_v2_1);
            this.add(CRAM_v3);
            this.add(CRAM_v3_1);
        }
    };
    public static final CRAMVersion DEFAULT_CRAM_VERSION = CRAM_v3;

    public static boolean isSupportedVersion(CRAMVersion candidateVersion) {
        return supportedCRAMVersions.contains(candidateVersion);
    }
}

