/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class CramIO {
    @Deprecated
    public static final String CRAM_FILE_EXTENSION = ".cram";
    public static final byte[] ZERO_B_EOF_MARKER = new byte[]{11, 0, 0, 0, -1, -1, -1, -1, -1, -32, 69, 79, 70, 0, 0, 0, 0, 1, 0, 0, 1, 0, 6, 6, 1, 0, 1, 0, 1, 0};
    public static final byte[] ZERO_F_EOF_MARKER = new byte[]{15, 0, 0, 0, -1, -1, -1, -1, 15, -32, 69, 79, 70, 0, 0, 0, 0, 1, 0, 5, -67, -39, 79, 0, 1, 0, 6, 6, 1, 0, 1, 0, 1, 0, -18, 99, 1, 75};
    public static final int EOF_ALIGNMENT_START = 4542278;
    public static final int EOF_BLOCK_SIZE_V3 = 15;
    public static final int EOF_BLOCK_SIZE_V2 = 11;
    public static final int EOF_ALIGNMENT_SPAN = 0;

    public static long writeCramEOF(CRAMVersion cramVersion, OutputStream outputStream) {
        try {
            if (cramVersion.compatibleWith(CramVersions.CRAM_v3)) {
                outputStream.write(ZERO_F_EOF_MARKER);
                return ZERO_F_EOF_MARKER.length;
            }
            if (cramVersion.compatibleWith(CramVersions.CRAM_v2_1)) {
                outputStream.write(ZERO_B_EOF_MARKER);
                return ZERO_B_EOF_MARKER.length;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        throw new IllegalArgumentException(String.format("Unrecognized CRAM version %s", cramVersion));
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) {
        try {
            outputStream.write(CramHeader.MAGIC);
            outputStream.write(cramHeader.getCRAMVersion().getMajor());
            outputStream.write(cramHeader.getCRAMVersion().getMinor());
            outputStream.write(cramHeader.getId());
            for (int i = cramHeader.getId().length; i < 20; ++i) {
                outputStream.write(0);
            }
            return CramHeader.CRAM_HEADER_LENGTH;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static CramHeader readCramHeader(InputStream inputStream) {
        try {
            for (byte magicByte : CramHeader.MAGIC) {
                if (magicByte == inputStream.read()) continue;
                throw new RuntimeException("Input does not have a valid CRAM header.");
            }
            CRAMVersion cramVersion = new CRAMVersion(inputStream.read(), inputStream.read());
            if (!CramVersions.isSupportedVersion(cramVersion)) {
                throw new RuntimeException(String.format("CRAM version %s is not supported", cramVersion));
            }
            CramHeader header = new CramHeader(cramVersion, null);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(header.getId());
            return header;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] samHeaderToByteArray(SAMFileHeader samFileHeader) {
        try (ByteArrayOutputStream headerBodyOS = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(headerBodyOS);){
                new SAMTextHeaderCodec().encode(outStreamWriter, samFileHeader);
            }
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(headerBodyOS.size());
            buf.flip();
            byte[] bytes = new byte[buf.limit()];
            buf.get(bytes);
            try (ByteArrayOutputStream headerOS = new ByteArrayOutputStream();){
                headerOS.write(bytes);
                headerOS.write(headerBodyOS.toByteArray(), 0, headerBodyOS.size());
                byArray = headerOS.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

