/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import gov.nih.nlm.ncbi.ngs.NGS;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SRAIndex;
import htsjdk.samtools.SRAIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.sra.ReferenceCache;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Log;
import java.util.List;
import ngs.ErrorMsg;
import ngs.ReadCollection;
import ngs.ReadGroupIterator;
import ngs.ReferenceIterator;

public class SRAFileReader
extends SamReader.ReaderImplementation
implements SamReader.Indexing {
    private static final Log log = Log.getInstance(SRAFileReader.class);
    private SRAAccession acc;
    private SAMFileHeader virtualHeader;
    private ReadCollection run;
    private ValidationStringency validationStringency;
    private SRAIterator.RecordRangeInfo recordRangeInfo;
    private SRAIndex index;
    private ReferenceCache cachedReferences;

    public SRAFileReader(SRAAccession acc) {
        this.acc = acc;
        if (!acc.isValid()) {
            throw new IllegalArgumentException("SRAFileReader: cannot resolve SRA accession '" + String.valueOf(acc) + "'\nPossible causes are an invalid SRA accession or a connection problem.");
        }
        try {
            this.run = NGS.openReadCollection((String)acc.toString());
            this.virtualHeader = this.loadSamHeader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.cachedReferences = new ReferenceCache(this.run, this.virtualHeader);
        this.recordRangeInfo = SRAIterator.getRecordsRangeInfo(this.run);
        this.index = new SRAIndex(this.virtualHeader, this.recordRangeInfo);
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.SRA_TYPE;
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    @Override
    public BAMIndex getIndex() {
        return this.index;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.virtualHeader;
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator() {
        return this.getIterator(this.getFilePointerSpanningReads());
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan chunks) {
        if (this.run == null) {
            throw new RuntimeException("Cannot create iterator - SRA run is uninitialized");
        }
        if (this.virtualHeader == null) {
            throw new RuntimeException("Cannot create iterator - SAM file header is uninitialized");
        }
        List<Chunk> chunkList = ((BAMFileSpan)chunks).getChunks();
        SRAIterator newIterator = new SRAIterator(this.acc, this.run, this.virtualHeader, this.cachedReferences, this.recordRangeInfo, chunkList);
        if (this.validationStringency != null) {
            newIterator.setValidationStringency(this.validationStringency);
        }
        return newIterator;
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        return new BAMFileSpan(new Chunk(0L, this.recordRangeInfo.getTotalRecordRangeLength()));
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        BAMFileSpan span = new BAMFileSpan();
        BrowseableBAMIndex index = this.getBrowseableIndex();
        for (QueryInterval interval : intervals) {
            BAMFileSpan intervalSpan = !contained ? index.getSpanOverlapping(interval.referenceIndex, interval.start, interval.end) : this.getSpanContained(interval.referenceIndex, interval.start, interval.end);
            span.add(intervalSpan);
        }
        return this.getIterator(span);
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        int sequenceIndex = this.virtualHeader.getSequenceIndex(sequence);
        if (sequenceIndex == -1) {
            throw new IllegalArgumentException("Unknown sequence '" + sequence + "' was passed to SRAFileReader");
        }
        return this.getIterator(this.getSpanContained(sequenceIndex, start, -1L));
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        BAMFileSpan span = new BAMFileSpan(new Chunk(this.recordRangeInfo.getTotalReferencesLength(), this.recordRangeInfo.getTotalRecordRangeLength()));
        return this.getIterator(span);
    }

    @Override
    public void close() {
        this.run = null;
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public boolean hasBrowseableIndex() {
        return true;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        return this.index;
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan chunks) {
        CloseableIterator<SAMRecord> it = this.getIterator(chunks);
        if (it == null) {
            return null;
        }
        return (SAMRecordIterator)it;
    }

    @Override
    void enableFileSource(SamReader reader, boolean enabled) {
        log.info("enableFileSource is not supported");
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        log.info("enableIndexCaching is not supported");
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        log.info("enableIndexMemoryMapping is not supported");
    }

    @Override
    void enableCrcChecking(boolean enabled) {
        log.info("enableCrcChecking is not supported");
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
        log.info("setSAMRecordFactory is not supported");
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    protected SRAIterator.RecordRangeInfo getRecordsRangeInfo() {
        return this.recordRangeInfo;
    }

    private SAMFileHeader loadSamHeader() throws ErrorMsg {
        if (this.run == null) {
            throw new RuntimeException("Cannot load SAMFileHeader - SRA run is uninitialized");
        }
        String runName = this.run.getName();
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ReadGroupIterator itRg = this.run.getReadGroups();
        while (itRg.nextReadGroup()) {
            String rgName = itRg.getName();
            if (rgName.isEmpty()) {
                rgName = runName;
            }
            SAMReadGroupRecord rg = new SAMReadGroupRecord(rgName);
            rg.setSample(runName);
            header.addReadGroup(rg);
        }
        ReferenceIterator itRef = this.run.getReferences();
        while (itRef.nextReference()) {
            header.addSequence(new SAMSequenceRecord(itRef.getCanonicalName(), (int)itRef.getLength()));
        }
        return header;
    }

    private BAMFileSpan getSpanContained(int sequenceIndex, long start, long end) {
        if (this.recordRangeInfo.getTotalRecordRangeLength() <= 0L) {
            throw new RuntimeException("Cannot create file span - SRA file is empty");
        }
        long sequenceOffset = this.recordRangeInfo.getReferenceOffsets().get(sequenceIndex);
        long sequenceLength = this.recordRangeInfo.getReferenceLengthsAligned().get(sequenceIndex);
        if (end == -1L) {
            end = sequenceLength;
        }
        if (start > sequenceLength) {
            throw new IllegalArgumentException("Sequence start position is larger than its length");
        }
        if (end > sequenceLength) {
            throw new IllegalArgumentException("Sequence end position is larger than its length");
        }
        return new BAMFileSpan(new Chunk(sequenceOffset + start, sequenceOffset + end));
    }
}

