/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.interval;

import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsQueryInterval;
import htsjdk.beta.plugin.interval.HtsQueryRule;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.utils.ValidationUtils;
import java.util.Collections;
import java.util.List;

public interface HtsQuery<RECORD>
extends Iterable<RECORD> {
    @Override
    public CloseableIterator<RECORD> iterator();

    public boolean isQueryable();

    public boolean hasIndex();

    default public CloseableIterator<RECORD> query(String queryString) {
        ValidationUtils.validateArg(this.isQueryable(), "Decoder is not queryable");
        throw new HtsjdkUnsupportedOperationException("query(string) not implemented for this decoder");
    }

    default public CloseableIterator<RECORD> query(String queryName, long start, long end, HtsQueryRule queryRule) {
        return this.query(new HtsQueryInterval(queryName, start, end), queryRule);
    }

    default public CloseableIterator<RECORD> queryOverlapping(String queryName, long start, long end) {
        return this.queryOverlapping(new HtsQueryInterval(queryName, start, end));
    }

    default public CloseableIterator<RECORD> queryContained(String queryName, long start, long end) {
        return this.queryContained(new HtsQueryInterval(queryName, start, end));
    }

    default public CloseableIterator<RECORD> query(HtsInterval interval, HtsQueryRule queryRule) {
        return this.query(Collections.singletonList(interval), queryRule);
    }

    default public CloseableIterator<RECORD> queryOverlapping(HtsInterval interval) {
        return this.query(interval, HtsQueryRule.OVERLAPPING);
    }

    default public CloseableIterator<RECORD> queryContained(HtsInterval interval) {
        return this.queryContained(Collections.singletonList(interval));
    }

    default public CloseableIterator<RECORD> query(List<HtsInterval> intervals, HtsQueryRule queryRule) {
        ValidationUtils.validateArg(this.isQueryable(), "Decoder is not queryable");
        throw new HtsjdkUnsupportedOperationException("query(intervals, queryRule) not implemented for this decoder");
    }

    default public CloseableIterator<RECORD> queryOverlapping(List<HtsInterval> intervals) {
        return this.query(intervals, HtsQueryRule.OVERLAPPING);
    }

    default public CloseableIterator<RECORD> queryContained(List<HtsInterval> intervals) {
        return this.query(intervals, HtsQueryRule.CONTAINED);
    }

    default public CloseableIterator<RECORD> queryStart(String queryName, long start) {
        ValidationUtils.validateArg(this.isQueryable(), "Decoder is not queryable");
        throw new HtsjdkUnsupportedOperationException("queryStart not implemented for this decoder");
    }
}

