/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.variants.vcf;

import htsjdk.beta.exception.HtsjdkPluginException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.variants.VariantsEncoder;
import htsjdk.beta.plugin.variants.VariantsEncoderOptions;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.util.Optional;

public abstract class VCFEncoder
implements VariantsEncoder {
    private final Bundle outputBundle;
    private final VariantsEncoderOptions variantsEncoderOptions;
    private final String displayName;
    private VariantContextWriter vcfWriter;

    public VCFEncoder(Bundle outputBundle, VariantsEncoderOptions variantsEncoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(variantsEncoderOptions, "variantsEncoderOptions");
        this.outputBundle = outputBundle;
        this.variantsEncoderOptions = variantsEncoderOptions;
        this.displayName = outputBundle.getOrThrow("VARIANT_CONTEXTS").getDisplayName();
    }

    @Override
    public final String getFileFormat() {
        return "VCF";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setHeader(VCFHeader vcfHeader) {
        ValidationUtils.nonNull(vcfHeader, "vcfHeader");
        this.vcfWriter = VCFEncoder.getVCFWriter(this.getOutputBundle(), this.getVariantsEncoderOptions());
        this.vcfWriter.writeHeader(vcfHeader);
    }

    @Override
    public void write(VariantContext variantContext) {
        ValidationUtils.nonNull(variantContext, "variantContext");
        if (this.vcfWriter == null) {
            throw new IllegalStateException("The VCF encoder must have a valid header before records can be written");
        }
        this.vcfWriter.add(variantContext);
    }

    @Override
    public void close() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    public Bundle getOutputBundle() {
        return this.outputBundle;
    }

    public VariantsEncoderOptions getVariantsEncoderOptions() {
        return this.variantsEncoderOptions;
    }

    private static VariantContextWriter getVCFWriter(Bundle outputBundle, VariantsEncoderOptions variantsEncoderOptions) {
        VariantContextWriterBuilder writerBuilder = VCFEncoder.variantsEncoderOptionsToVariantContextWriterBuilder(variantsEncoderOptions, outputBundle.get("VARIANTS_INDEX").isPresent());
        VCFEncoder.setWriterBuilderOutputs(writerBuilder, outputBundle);
        return writerBuilder.build();
    }

    private static VariantContextWriterBuilder variantsEncoderOptionsToVariantContextWriterBuilder(VariantsEncoderOptions variantsEncoderOptions, boolean createIndex) {
        VariantContextWriterBuilder vcWriterBuilder = new VariantContextWriterBuilder();
        vcWriterBuilder.clearOptions();
        vcWriterBuilder.setBuffer(variantsEncoderOptions.getBufferSize());
        if (createIndex) {
            vcWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            vcWriterBuilder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        if (variantsEncoderOptions.isAllowFieldsMissingFromHeader()) {
            vcWriterBuilder.setOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        } else {
            vcWriterBuilder.unsetOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        }
        if (variantsEncoderOptions.isWriteSitesOnly()) {
            vcWriterBuilder.setOption(Options.DO_NOT_WRITE_GENOTYPES);
        } else {
            vcWriterBuilder.unsetOption(Options.DO_NOT_WRITE_GENOTYPES);
        }
        if (variantsEncoderOptions.isWriteFullFormatField()) {
            vcWriterBuilder.setOption(Options.WRITE_FULL_FORMAT_FIELD);
        } else {
            vcWriterBuilder.unsetOption(Options.WRITE_FULL_FORMAT_FIELD);
        }
        return vcWriterBuilder;
    }

    private static void setWriterBuilderOutputs(VariantContextWriterBuilder writerBuilder, Bundle outputBundle) {
        BundleResource variantsResource = outputBundle.getOrThrow("VARIANT_CONTEXTS");
        if (!variantsResource.hasOutputType()) {
            throw new IllegalArgumentException(String.format("The provided %s resource (%s) must be a writeable/output resource", "VARIANT_CONTEXTS", variantsResource));
        }
        Optional<IOPath> optIndexIOPath = VCFEncoder.getIndexIOPath(outputBundle);
        if (variantsResource.getIOPath().isPresent()) {
            IOPath variantsIOPath = variantsResource.getIOPath().get();
            if (optIndexIOPath.isPresent()) {
                // empty if block
            }
            writerBuilder.setOutputPath(variantsIOPath.toPath());
            VCFEncoder.validateImputedOutputType(variantsIOPath);
        } else if (variantsResource.getOutputStream().isPresent()) {
            if (optIndexIOPath.isPresent()) {
                throw new HtsjdkUnsupportedOperationException(String.format("Can't write a VCF index to file %s when output is written to a stream %s", optIndexIOPath.get(), variantsResource));
            }
            writerBuilder.setOutputVCFStream(variantsResource.getOutputStream().get());
        }
    }

    private static void validateImputedOutputType(IOPath variantsIOPath) {
        VariantContextWriterBuilder.OutputType imputedOutputType = VariantContextWriterBuilder.determineOutputTypeFromFile(variantsIOPath.toPath());
        if (imputedOutputType != VariantContextWriterBuilder.OutputType.VCF && imputedOutputType != VariantContextWriterBuilder.OutputType.BLOCK_COMPRESSED_VCF) {
            throw new HtsjdkPluginException(String.format("An unsupported output type %s was derived for the resource %s ", new Object[]{imputedOutputType, variantsIOPath.getRawInputString()}));
        }
    }

    private static Optional<IOPath> getIndexIOPath(Bundle outputBundle) {
        Optional<BundleResource> optIndexResource = outputBundle.get("VARIANTS_INDEX");
        if (!optIndexResource.isPresent()) {
            return Optional.empty();
        }
        BundleResource indexResource = optIndexResource.get();
        if (!indexResource.hasOutputType()) {
            throw new IllegalArgumentException(String.format("The provided %s index resource (%s) must be a writeable/output resource", "VARIANTS_INDEX", indexResource));
        }
        if (!indexResource.getIOPath().isPresent()) {
            throw new HtsjdkUnsupportedOperationException("Writing a VCF index to a stream not implemented");
        }
        return indexResource.getIOPath();
    }
}

