/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.sam.samV1_0;

import htsjdk.beta.codecs.reads.sam.SAMEncoder;
import htsjdk.beta.codecs.reads.sam.samV1_0.SAMCodecV1_0;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import java.util.Optional;

public class SAMEncoderV1_0
extends SAMEncoder {
    private SAMFileWriter samFileWriter;

    public SAMEncoderV1_0(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        super(outputBundle, readsEncoderOptions);
    }

    @Override
    public HtsVersion getVersion() {
        return SAMCodecV1_0.VERSION_1;
    }

    @Override
    public void setHeader(SAMFileHeader samFileHeader) {
        this.samFileWriter = this.getSAMFileWriter(this.getReadsEncoderOptions(), samFileHeader);
    }

    @Override
    public void write(SAMRecord record) {
        if (this.samFileWriter == null) {
            throw new IllegalStateException(String.format("A SAMFileHeader must be established before a SAM writer can be established %s", this.getDisplayName()));
        }
        this.samFileWriter.addAlignment(record);
    }

    @Override
    public void close() {
        if (this.samFileWriter != null) {
            this.samFileWriter.close();
        }
    }

    private SAMFileWriter getSAMFileWriter(ReadsEncoderOptions readsEncoderOptions, SAMFileHeader samFileHeader) {
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        boolean preSorted = readsEncoderOptions.isPreSorted();
        BundleResource readsResource = this.getOutputBundle().getOrThrow("ALIGNED_READS");
        Optional<BundleResource> optIndexResource = this.getOutputBundle().get("READS_INDEX");
        Optional<BundleResource> optMD5Resource = this.getOutputBundle().get("MD5");
        if (optIndexResource.isPresent()) {
            BundleResource indexResource = optIndexResource.get();
            if (indexResource.getIOPath().isPresent()) {
                samFileWriterFactory.setCreateIndex(true);
            } else {
                throw new HtsjdkUnsupportedOperationException("Writing a BAM index to a stream is not yet supported");
            }
        }
        if (optMD5Resource.isPresent()) {
            throw new HtsjdkUnsupportedOperationException(String.format("Specifying an an MD5 resource name not yet implemented on %s", this.getDisplayName()));
        }
        if (readsResource.getIOPath().isPresent()) {
            return samFileWriterFactory.makeSAMWriter(samFileHeader, preSorted, readsResource.getIOPath().get().toPath());
        }
        return samFileWriterFactory.makeSAMWriter(samFileHeader, preSorted, readsResource.getOutputStream().get());
    }
}

