/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;

public class IGVReferenceSource
implements CRAMReferenceSource {
    private static Logger log = LogManager.getLogger(IGVReferenceSource.class);

    public byte[] getReferenceBases(SAMSequenceRecord record, boolean tryNameVariants) {
        return this.getReferenceBasesByRegion(record, 0, record.getSequenceLength());
    }

    public byte[] getReferenceBasesByRegion(SAMSequenceRecord sequenceRecord, int zeroBasedStart, int requestedRegionLength) {
        String chrName;
        String name = sequenceRecord.getSequenceName();
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        byte[] bases = currentGenome.getSequence(chrName = currentGenome.getCanonicalChrName(name), zeroBasedStart, zeroBasedStart + requestedRegionLength, true);
        if (bases != null) {
            for (int i = 0; i < bases.length; ++i) {
                if (bases[i] < 97) continue;
                int n = i;
                bases[n] = (byte)(bases[n] - 32);
            }
        }
        return bases;
    }
}

