/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam.bamV1_0;

import htsjdk.beta.codecs.reads.bam.BAMEncoder;
import htsjdk.beta.codecs.reads.bam.BAMEncoderOptions;
import htsjdk.beta.codecs.reads.bam.bamV1_0.BAMCodecV1_0;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.utils.ValidationUtils;
import java.util.Optional;

public class BAMEncoderV1_0
extends BAMEncoder {
    private SAMFileWriter samFileWriter;

    public BAMEncoderV1_0(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        super(outputBundle, readsEncoderOptions);
    }

    @Override
    public HtsVersion getVersion() {
        return BAMCodecV1_0.VERSION_1;
    }

    @Override
    public void setHeader(SAMFileHeader samFileHeader) {
        ValidationUtils.nonNull(samFileHeader, "samFileHeader");
        this.samFileWriter = this.getBAMFileWriter(this.getReadsEncoderOptions(), samFileHeader);
    }

    @Override
    public void write(SAMRecord record) {
        ValidationUtils.nonNull(record, "record");
        if (this.samFileWriter == null) {
            throw new IllegalStateException(String.format("A SAMFileHeader must be established before records can be written for %s", this.getDisplayName()));
        }
        this.samFileWriter.addAlignment(record);
    }

    @Override
    public void close() {
        if (this.samFileWriter != null) {
            this.samFileWriter.close();
        }
    }

    private static void bamEncoderOptionsToSamWriterFactory(BAMEncoderOptions bamEncoderOptions, SAMFileWriterFactory samFileWriterFactory) {
        samFileWriterFactory.setDeflaterFactory(bamEncoderOptions.getDeflaterFactory());
        samFileWriterFactory.setCompressionLevel(bamEncoderOptions.getCompressionLevel());
        samFileWriterFactory.setTempDirectory(bamEncoderOptions.getTemporaryDirectory().toPath().toFile());
        samFileWriterFactory.setBufferSize(bamEncoderOptions.getOutputBufferSize());
        samFileWriterFactory.setUseAsyncIo(bamEncoderOptions.isAsyncIO());
        samFileWriterFactory.setAsyncOutputBufferSize(bamEncoderOptions.getAsyncOutputBufferSize());
        samFileWriterFactory.setMaxRecordsInRam(bamEncoderOptions.getMaxRecordsInRAM());
    }

    private SAMFileWriter getBAMFileWriter(ReadsEncoderOptions readsEncoderOptions, SAMFileHeader samFileHeader) {
        BAMEncoderOptions bamEncoderOptions = readsEncoderOptions.getBAMEncoderOptions();
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        BAMEncoderV1_0.bamEncoderOptionsToSamWriterFactory(bamEncoderOptions, samFileWriterFactory);
        boolean preSorted = readsEncoderOptions.isPreSorted();
        BundleResource readsResource = this.getOutputBundle().getOrThrow("ALIGNED_READS");
        Optional<BundleResource> optIndexResource = this.getOutputBundle().get("READS_INDEX");
        Optional<BundleResource> optMD5Resource = this.getOutputBundle().get("MD5");
        if (optIndexResource.isPresent()) {
            BundleResource indexResource = optIndexResource.get();
            if (indexResource.getIOPath().isPresent()) {
                samFileWriterFactory.setCreateIndex(true);
            } else {
                throw new HtsjdkUnsupportedOperationException("Writing a BAM index to a stream is not yet supported");
            }
        }
        if (optMD5Resource.isPresent()) {
            throw new HtsjdkUnsupportedOperationException(String.format("Specifying an an MD5 resource name not yet implemented on %s", this.getDisplayName()));
        }
        if (readsResource.getIOPath().isPresent()) {
            return samFileWriterFactory.makeBAMWriter(samFileHeader, preSorted, readsResource.getIOPath().get().toPath());
        }
        return samFileWriterFactory.makeBAMWriter(samFileHeader, preSorted, readsResource.getOutputStream().get());
    }
}

