/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.session.SessionReader;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class LoadFilesMenuAction
extends MenuAction {
    private static final Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    private final IGV igv;

    public LoadFilesMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.loadFiles(this.chooseTrackFiles());
    }

    private File[] chooseTrackFiles() {
        File lastFile;
        File lastDirectoryFile = PreferencesManager.getPreferences().getLastTrackDirectory();
        IGVPreferences prefs = PreferencesManager.getPreferences();
        File[] trackFiles = FileDialogUtils.chooseMultiple("Select Files", lastDirectoryFile, null);
        if (trackFiles != null && trackFiles.length > 0 && (lastFile = trackFiles[0]) != null) {
            PreferencesManager.getPreferences().setLastTrackDirectory(lastFile);
        }
        this.igv.resetStatusMessage();
        return trackFiles;
    }

    private void loadFiles(File[] files) {
        if (files != null && files.length > 0) {
            ArrayList<File> validFiles = new ArrayList<File>();
            ArrayList<File> missingFiles = new ArrayList<File>();
            for (File file : files) {
                if (!file.exists()) {
                    missingFiles.add(file);
                    continue;
                }
                String path = file.getAbsolutePath();
                if (SessionReader.isSessionFile(path)) {
                    String msg = "File " + path + " appears to be an IGV Session file - please use the Open Session menu item to load it.";
                    log.error(msg);
                    MessageUtils.showMessage(msg);
                    continue;
                }
                validFiles.add(file);
            }
            if (!missingFiles.isEmpty()) {
                String msg = missingFiles.stream().map(File::getAbsolutePath).collect(Collectors.joining("\n\t", "File(s) not found: \n\t", ""));
                log.error(msg);
                MessageUtils.showMessage(msg);
            }
            if (!validFiles.isEmpty()) {
                List<ResourceLocator> locators = ResourceLocator.getLocators(validFiles);
                this.igv.addToRecentUrls(locators);
                this.igv.loadTracks(locators);
            }
        }
    }
}

