/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLUtils;

public class ResourceLocator {
    private static final Logger log = LogManager.getLogger(ResourceLocator.class);
    String name;
    String path;
    String dbURL;
    String indexPath;
    String coverage;
    String mappingPath;
    String trackInforURL;
    String featureInfoURL;
    String labelField;
    String description;
    public String format;
    String trackLine;
    TrackProperties trackProperties;
    Color color;
    String sampleId;
    private Map<String, String> metadata;
    private boolean indexed;
    private boolean dataURL;
    private boolean htsget;
    private Integer visibilityWindow;
    private String trixURL;
    private String panelName;
    static Set<String> knownFormats = new HashSet<String>(Arrays.asList("gff", "bed", "gtf", "gff3", "seg", "bb", "bigbed", "bigwig", "bam", "cram", "vcf", "bedmethyl"));

    public static List<ResourceLocator> getLocators(Collection<File> files) {
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        HashSet<String> indexExtensions = new HashSet<String>(Arrays.asList("bai", "crai", "sai", "tbi", "tbx"));
        HashSet<File> indexes = new HashSet<File>();
        HashMap<Object, File> indexMap = new HashMap<Object, File>();
        for (File f : files) {
            String ext;
            String fn = f.getName();
            int idx = fn.lastIndexOf(46);
            if (idx <= 0 || !indexExtensions.contains(ext = fn.substring(idx + 1))) continue;
            Object base = fn.substring(0, idx);
            if (ext.equals(".bai") && !((String)base).endsWith(".bam")) {
                base = (String)base + ".bam";
            } else if (ext.equals(".crai") && !((String)base).endsWith(".cram")) {
                base = (String)base + ".cram";
            }
            indexes.add(f);
            indexMap.put(base, f);
        }
        for (File f : files) {
            if (indexes.contains(f)) continue;
            ResourceLocator locator = new ResourceLocator(f.getAbsolutePath());
            File indexFile = (File)indexMap.get(f.getName());
            if (indexFile != null) {
                locator.setIndexPath(indexFile.getAbsolutePath());
            }
            locators.add(locator);
        }
        return locators;
    }

    public ResourceLocator(String path) {
        this.setPath(path);
        if (path != null && path.startsWith("https://") && GoogleUtils.isGoogleDrive(path)) {
            this.resolveGoogleDrive(path);
        } else if (path != null && path.startsWith("htsget://")) {
            this.htsget = true;
        }
    }

    private void resolveGoogleDrive(String path) {
        JsonObject fileInfo = GoogleUtils.getDriveFileInfo(path);
        this.name = fileInfo.get("name").getAsString();
        this.format = ResourceLocator.deriveFormat(this.name);
    }

    public ResourceLocator(String dbURL, String path) {
        this.dbURL = dbURL;
        this.setPath(path);
    }

    public boolean isDataURL() {
        return this.dataURL;
    }

    public boolean exists() {
        return ParsingUtils.fileExists(this.path);
    }

    public void setFormat(String formatOrExt) {
        this.format = formatOrExt == null ? null : (formatOrExt.startsWith(".") ? formatOrExt.substring(1) : formatOrExt);
    }

    public String getFormat() {
        if (this.format == null) {
            this.format = ResourceLocator.deriveFormat(this.path);
        }
        return this.format;
    }

    public Integer getVisibilityWindow() {
        return this.visibilityWindow;
    }

    public void setVisibilityWindow(Integer visibilityWindow) {
        this.visibilityWindow = visibilityWindow;
    }

    public static String deriveFormat(String pathOrName) {
        String filename;
        block25: {
            if (FileUtils.isRemote(pathOrName)) {
                try {
                    URL url = HttpUtils.createURL(pathOrName);
                    filename = url.getPath().toLowerCase();
                    String query = url.getQuery();
                    if (query == null) break block25;
                    Map<String, String> queryMap = URLUtils.parseQueryString(query);
                    if (queryMap.containsKey("dataformat")) {
                        return queryMap.get("dataformat");
                    }
                    if (queryMap.containsKey("file")) {
                        filename = queryMap.get("file");
                    }
                }
                catch (MalformedURLException e) {
                    log.error("Error interpreting url: " + pathOrName, e);
                    filename = pathOrName;
                }
            } else {
                filename = pathOrName.toLowerCase();
            }
        }
        if (filename.endsWith(".txt") || filename.endsWith(".xls") || filename.endsWith(".gz") || filename.endsWith(".bgz")) {
            filename = filename.substring(0, filename.lastIndexOf(".")).trim();
        }
        if (filename.endsWith("fpkm_tracking")) {
            return "fpkm_tracking";
        }
        if (filename.endsWith("gene_exp.diff")) {
            return "gene_exp.diff";
        }
        if (filename.endsWith("cds_exp.diff")) {
            return "cds_exp.diff";
        }
        if (filename.endsWith("genepredext")) {
            return "genepredext";
        }
        if (filename.endsWith(".maf.annotated")) {
            return "mut";
        }
        if (filename.endsWith("junctions.bed")) {
            return "junctions";
        }
        if (filename.endsWith("bam.list")) {
            return "bam.list";
        }
        if (filename.endsWith("sam.list")) {
            return "sam.list";
        }
        if (filename.endsWith("vcf.list")) {
            return "vcf.list";
        }
        if (filename.endsWith("seg.zip")) {
            return "seg.zip";
        }
        if (filename.endsWith(".ewig.tdf") || filename.endsWith(".ewig.ibf")) {
            return "ewig.tdf";
        }
        if (filename.endsWith(".maf.dict")) {
            return "maf.dict";
        }
        if (filename.endsWith("_clusters")) {
            return "bedpe";
        }
        String format = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
        if (!knownFormats.contains(format)) {
            if (filename.contains("refflat")) {
                return "reflat";
            }
            if (filename.contains("genepred") || filename.contains("ensgene") || filename.contains("refgene") || filename.contains("ncbirefseq")) {
                return "refgene";
            }
            if (filename.contains("ucscgene")) {
                return "ucscgene";
            }
            if (filename.matches(CodecFactory.ucscSNP)) {
                return "snp";
            }
        }
        return format;
    }

    public String getURLPath() {
        return this.getPath().split("\\?", 2)[0];
    }

    public String getURLQueryString() {
        String[] tmp = this.getPath().split("\\?", 2);
        if (tmp.length == 1) {
            return "";
        }
        return tmp[1];
    }

    public String toString() {
        return this.path + (String)(this.dbURL == null ? "" : " " + this.dbURL);
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        if (this.path.startsWith("http://") || this.path.startsWith("https://") || this.path.startsWith("gs://")) {
            int idxQuestion = this.path.indexOf(63);
            String actualPath = idxQuestion < 0 ? this.path : this.path.substring(0, idxQuestion);
            int idxSlash = actualPath.lastIndexOf(47);
            return idxSlash < 0 ? actualPath : actualPath.substring(idxSlash + 1);
        }
        return new File(this.path).getName();
    }

    public String getDBUrl() {
        return this.dbURL;
    }

    public boolean isLocal() {
        return this.dbURL == null && !this.dataURL && !FileUtils.isRemote(this.path);
    }

    public void setTrackInfoURL(String trackInforURL) {
        this.trackInforURL = trackInforURL;
    }

    public String getTrackInfoURL() {
        return this.trackInforURL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTrackName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getFileName();
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public void setTrackProperties(TrackProperties trackProperties) {
        this.trackProperties = trackProperties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getFeatureInfoURL() {
        return this.featureInfoURL;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public void setLabelField(String labelField) {
        this.labelField = labelField;
    }

    public void setFeatureInfoURL(String featureInfoURL) {
        this.featureInfoURL = featureInfoURL;
    }

    public void setPath(String path) {
        if (path != null && path.startsWith("file://")) {
            this.path = path.substring("file://".length());
        } else if (path != null && path.startsWith("s3://")) {
            this.path = path;
            String s3UrlIndexPath = this.detectIndexPath(path);
            this.setIndexPath(s3UrlIndexPath);
        } else {
            this.dataURL = ParsingUtils.isDataURL(path);
            this.path = path;
        }
    }

    public String getTrackLine() {
        return this.trackLine;
    }

    public void setTrackLine(String trackLine) {
        this.trackLine = trackLine;
    }

    public String getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public String detectIndexPath(String inputPath) {
        log.debug("detectIndexPath() input S3 path is: " + inputPath);
        Object indexPath = "";
        if (inputPath.contains(".bam")) {
            indexPath = inputPath + ".bai";
        } else if (inputPath.endsWith(".gz")) {
            indexPath = inputPath + ".tbi";
        } else {
            log.debug("S3 index object filetype could not be determined from S3 url");
        }
        return indexPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLocator that = (ResourceLocator)o;
        if (this.dbURL != null ? !this.dbURL.equals(that.dbURL) : that.dbURL != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.dbURL != null ? this.dbURL.hashCode() : 0);
        return result;
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(String mappingPath) {
        this.mappingPath = mappingPath;
    }

    public static String appendToPath(ResourceLocator locator, String extension) {
        String extendedPath = locator.getURLPath() + extension;
        String qs = locator.getURLQueryString();
        if (qs != null && qs.length() > 0) {
            extendedPath = extendedPath + "?" + qs;
        }
        return extendedPath;
    }

    public static String indexFile(ResourceLocator locator) {
        if (locator.getIndexPath() != null) {
            return locator.getIndexPath();
        }
        if (ResourceLocator.isCloudOrDropbox(locator.getPath())) {
            return null;
        }
        String indexExtension = locator.getURLPath().toLowerCase().endsWith(".gz") || locator.getPath().toLowerCase().endsWith(".bgz") ? ".tbi" : ".idx";
        return ResourceLocator.appendToPath(locator, indexExtension);
    }

    public void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public boolean isHtsget() {
        return this.htsget;
    }

    public void setHtsget(boolean htsget) {
        this.htsget = htsget;
    }

    private static boolean isCloudOrDropbox(String path) {
        try {
            String host;
            if (GoogleUtils.isGoogleDrive(path)) {
                return true;
            }
            return !(!path.startsWith("http://") && !path.startsWith("https://") || !(host = new URL(path).getHost()).equals("www.dropbox.com") && !host.equals("dl.dropboxusercontent.com"));
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setTrixURL(String trixURL) {
        this.trixURL = trixURL;
    }

    public String getTrixURL() {
        return this.trixURL;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static ResourceLocator fromTrackConfig(TrackConfig trackConfig) {
        Integer vizwindow;
        String displayMode;
        String altColor;
        String trackPath = trackConfig.getUrl();
        ResourceLocator res = new ResourceLocator(trackPath);
        res.setName(trackConfig.getName());
        res.setIndexPath(trackConfig.getIndexURL());
        res.setFormat(trackConfig.getFormat());
        Integer vw = trackConfig.getVisibilityWindow();
        if (vw != null) {
            res.setVisibilityWindow(vw);
        }
        if (trackConfig.getPanelName() != null) {
            res.setPanelName(trackConfig.getPanelName());
        }
        if (trackConfig.getTrixURL() != null) {
            res.setTrixURL(trackConfig.getTrixURL());
        }
        res.setFeatureInfoURL(trackConfig.getInfoURL());
        Boolean indexed = trackConfig.getIndexed();
        if (indexed != null) {
            res.setIndexed(indexed);
        }
        TrackProperties properties = new TrackProperties();
        String color = trackConfig.getColor();
        if (color != null) {
            try {
                properties.setColor(ColorUtilities.stringToColor(color.toString()));
            }
            catch (Exception e) {
                log.error("Error parsing color string: " + color, e);
            }
        }
        if ((altColor = trackConfig.getAltColor()) != null) {
            try {
                properties.setAltColor(ColorUtilities.stringToColor(altColor.toString()));
            }
            catch (Exception e) {
                log.error("Error parsing color string: " + altColor, e);
            }
        }
        if ((displayMode = trackConfig.getDisplayMode()) != null) {
            try {
                Track.DisplayMode dp = Track.DisplayMode.valueOf(StringUtils.stripQuotes(displayMode.toString()));
                properties.setDisplayMode(dp);
            }
            catch (Exception e) {
                log.error("Error parsing displayMode " + displayMode, e);
            }
        }
        if ((vizwindow = trackConfig.getVisibilityWindow()) != null) {
            properties.setFeatureVisibilityWindow(vizwindow);
        } else {
            properties.setFeatureVisibilityWindow(-1);
        }
        if (trackConfig.getMin() != null) {
            properties.setMinValue(trackConfig.getMin().floatValue());
        }
        if (trackConfig.getMax() != null) {
            properties.setMaxValue(trackConfig.getMax().floatValue());
        }
        res.setTrackProperties(properties);
        return res;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public static enum AttributeType {
        DB_URL("serverURL"),
        PATH("path"),
        DESCRIPTION("description"),
        HYPERLINK("hyperlink"),
        INFOLINK("infolink"),
        ID("id"),
        SAMPLE_ID("sampleId"),
        NAME("name"),
        URL("url"),
        LABEL_FIELD("labelField"),
        RESOURCE_TYPE("resourceType"),
        TRACK_LINE("trackLine"),
        COVERAGE("coverage"),
        MAPPING("mapping"),
        COLOR("color"),
        INDEX("index"),
        HTSGET("htsget");

        private final String name;

        private AttributeType(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }
    }
}

