/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ucsc.Hub;
import org.broad.igv.ucsc.HubTrackSelectionDialog;
import org.broad.igv.ucsc.TrackConfigGroup;
import org.broad.igv.ui.IGV;

public class HubGenomeLoader
extends GenomeLoader {
    String hubURL;

    public HubGenomeLoader(String hubURL) {
        this.hubURL = hubURL;
    }

    public static boolean isHubURL(String obj) {
        return obj.endsWith("/hub.txt");
    }

    public static String convertToHubURL(String accension) {
        if (accension.startsWith("GCF") || accension.startsWith("GCA") && accension.length() >= 13) {
            String prefix = accension.substring(0, 3);
            String n1 = accension.substring(4, 7);
            String n2 = accension.substring(7, 10);
            String n3 = accension.substring(10, 13);
            return "https://hgdownload.soe.ucsc.edu/hubs/" + prefix + "/" + n1 + "/" + n2 + "/" + n3 + "/" + accension + "/hub.txt";
        }
        return null;
    }

    @Override
    public Genome loadGenome() throws IOException {
        Hub hub = Hub.loadHub(this.hubURL);
        GenomeConfig config = hub.getGenomeConfig(false);
        String key = "hub:" + this.hubURL;
        if (PreferencesManager.getPreferences().hasExplicitValue(key)) {
            ArrayList<TrackConfig> selectedTracks = new ArrayList<TrackConfig>();
            HashSet<String> selectedTrackNames = new HashSet<String>(Arrays.asList(PreferencesManager.getPreferences().get(key).split(",")));
            List<TrackConfigGroup> trackConfigGroups = hub.getGroupedTrackConfigurations();
            for (TrackConfigGroup group : trackConfigGroups) {
                for (TrackConfig trackConfig2 : group.tracks) {
                    if (!selectedTrackNames.contains(trackConfig2.getName())) continue;
                    selectedTracks.add(trackConfig2);
                }
            }
            selectedTracks.sort((o1, o2) -> o1.getOrder() - o2.getOrder());
            config.setTracks(selectedTracks);
        } else if (IGV.hasInstance() && !Globals.isBatch() && !Globals.isHeadless() && !Globals.isTesting()) {
            HubTrackSelectionDialog dlg = new HubTrackSelectionDialog(hub.getGroupedTrackConfigurations(), IGV.getInstance().getMainFrame());
            dlg.setVisible(true);
            List<TrackConfig> selectedTracks = dlg.getSelectedConfigs();
            config.setTracks(selectedTracks);
            List<String> names = selectedTracks.stream().map(trackConfig -> trackConfig.getName()).toList();
            PreferencesManager.getPreferences().put(key, String.join((CharSequence)",", names));
        }
        Genome genome = new Genome(config);
        genome.setHub(hub);
        return genome;
    }
}

