/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.AquaJideUtils;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.vsnet.VsnetJideTabbedPaneUI;
import com.jidesoft.swing.TabColorProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AquaJideTabbedPaneUI
extends VsnetJideTabbedPaneUI {
    private static final Color COLOR1 = new Color(130, 130, 130);
    private static final Color COLOR2 = new Color(86, 86, 86);
    private static final Color COLOR3 = new Color(252, 252, 252);

    public static ComponentUI createUI(JComponent c) {
        return new AquaJideTabbedPaneUI();
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color[] color;
        Component component;
        super.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        if (this._tabPane.getTabColorProvider() != null && this._tabPane.getTabColorProvider().getBackgroundAt(tabIndex) != null) {
            return;
        }
        if (tabIndex >= 0 && tabIndex < this._tabPane.getTabCount() && (component = this._tabPane.getComponentAt(tabIndex)) instanceof TabColorProvider && ((TabColorProvider)((Object)component)).getTabBackground() != null) {
            return;
        }
        if (!isSelected) {
            return;
        }
        Color[] colorArray = color = AquaJideUtils.isGraphite() ? AquaJideUtils.AQUA_GRAPHITE : AquaJideUtils.AQUA_BLUE;
        if (this.tabRegion != null) {
            Graphics2D g2d = (Graphics2D)g;
            switch (tabPlacement) {
                case 2: {
                    AquaJideUtils.fillAquaGradientVertical(g2d, this.tabRegion, color);
                    break;
                }
                case 4: {
                    AquaJideUtils.fillAquaGradientVertical(g2d, this.tabRegion, color);
                    break;
                }
                case 3: {
                    AquaJideUtils.fillAquaGradientHorizontal(g2d, this.tabRegion, color);
                    break;
                }
                default: {
                    AquaJideUtils.fillAquaGradientHorizontal(g2d, this.tabRegion, color);
                }
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected boolean isRoundedCorner() {
        return true;
    }

    protected boolean isShading() {
        return true;
    }

    @Override
    protected Color getBorderEdgeColor() {
        return this._shadow;
    }

    @Override
    protected BasicJideTabbedPaneUI.TabCloseButton createNoFocusButton(int type) {
        return new AquaTabCloseButton(type);
    }

    @Override
    protected void prepareEditor(BasicJideTabbedPaneUI.TabEditor e, int tabIndex) {
        e.setOpaque(true);
        super.prepareEditor(e, tabIndex);
    }

    public class AquaTabCloseButton
    extends BasicJideTabbedPaneUI.TabCloseButton {
        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
        }

        public AquaTabCloseButton() {
            this(0);
        }

        public AquaTabCloseButton(int type) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setContentAreaFilled(false);
            this.setType(type);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            AquaJideUtils.antialiasShape(g, true);
            Color color = g.getColor();
            if (this.isMouseOver() && this.isMousePressed()) {
                g.setColor(COLOR1);
                g.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g.setColor(COLOR2);
            } else if (this.isMouseOver()) {
                g.setColor(COLOR1);
                g.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g.setColor(COLOR3);
            } else {
                g.setColor(COLOR1);
            }
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    if (this.isEnabled()) {
                        g.drawLine(centerX - 2, centerY - 2, centerX + 2, centerY + 2);
                        g.drawLine(centerX - 3, centerY - 2, centerX + 1, centerY + 2);
                        g.drawLine(centerX + 2, centerY - 2, centerX - 2, centerY + 2);
                        g.drawLine(centerX + 1, centerY - 2, centerX - 3, centerY + 2);
                        break;
                    }
                    g.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                    g.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                    break;
                }
                case 1: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX + 2;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g.drawLine(x - 3, y - 3, x - 3, y + 3);
                            g.drawLine(x - 2, y - 2, x - 2, y + 2);
                            g.drawLine(x - 1, y - 1, x - 1, y + 1);
                            g.drawLine(x, y, x, y);
                            break;
                        }
                        g.drawLine(x - 3, y - 3, x, y);
                        g.drawLine(x - 3, y - 3, x - 3, y + 3);
                        g.drawLine(x - 3, y + 3, x, y);
                        break;
                    }
                    int x = centerX;
                    int y = centerY + 2;
                    if (this.isEnabled()) {
                        g.drawLine(x - 3, y - 3, x + 3, y - 3);
                        g.drawLine(x - 2, y - 2, x + 2, y - 2);
                        g.drawLine(x - 1, y - 1, x + 1, y - 1);
                        g.drawLine(x, y, x, y);
                        break;
                    }
                    g.drawLine(x - 3, y - 3, x, y);
                    g.drawLine(x - 3, y - 3, x + 3, y - 3);
                    g.drawLine(x + 3, y - 3, x, y);
                    break;
                }
                case 2: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x = centerX - 3;
                        int y = centerY;
                        if (this.isEnabled()) {
                            g.drawLine(x, y, x, y);
                            g.drawLine(x + 1, y - 1, x + 1, y + 1);
                            g.drawLine(x + 2, y - 2, x + 2, y + 2);
                            g.drawLine(x + 3, y - 3, x + 3, y + 3);
                            break;
                        }
                        g.drawLine(x, y, x + 3, y - 3);
                        g.drawLine(x, y, x + 3, y + 3);
                        g.drawLine(x + 3, y - 3, x + 3, y + 3);
                        break;
                    }
                    int x = centerX;
                    int y = centerY - 2;
                    if (this.isEnabled()) {
                        g.drawLine(x, y, x, y);
                        g.drawLine(x - 1, y + 1, x + 1, y + 1);
                        g.drawLine(x - 2, y + 2, x + 2, y + 2);
                        g.drawLine(x - 3, y + 3, x + 3, y + 3);
                        break;
                    }
                    g.drawLine(x, y, x - 3, y + 3);
                    g.drawLine(x, y, x + 3, y + 3);
                    g.drawLine(x - 3, y + 3, x + 3, y + 3);
                    break;
                }
                case 5: {
                    int x = centerX;
                    int y = centerY + 2;
                    g.drawLine(x - 3, y - 3, x + 3, y - 3);
                    g.drawLine(x - 2, y - 2, x + 2, y - 2);
                    g.drawLine(x - 1, y - 1, x + 1, y - 1);
                    g.drawLine(x, y, x, y);
                    break;
                }
            }
            g.setColor(color);
            AquaJideUtils.antialiasShape(g, false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }
}

