/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.BAMIndexMerger;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TabixIndexMerger
extends IndexMerger<TabixIndex> {
    private TabixFormat formatSpec;
    private final List<String> sequenceNames = new ArrayList<String>();
    private List<TabixIndex> indexes = new ArrayList<TabixIndex>();

    public TabixIndexMerger(OutputStream out, long headerLength) {
        super(out, headerLength);
    }

    @Override
    public void processIndex(TabixIndex index, long partLength) {
        this.partLengths.add(partLength);
        if (this.indexes.isEmpty()) {
            this.formatSpec = index.getFormatSpec();
            if (index.getSequenceNames() != null) {
                this.sequenceNames.addAll(index.getSequenceNames());
            }
        }
        if (!index.getFormatSpec().equals(this.formatSpec)) {
            throw new IllegalArgumentException(String.format("Cannot merge tabix files with different formats, %s and %s.", index.getFormatSpec(), this.formatSpec));
        }
        if (!this.sequenceNames.equals(index.getSequenceNames())) {
            throw new IllegalArgumentException(String.format("Cannot merge tabix files with different sequence names, %s and %s.", index.getSequenceNames(), this.sequenceNames));
        }
        this.indexes.add(index);
    }

    @Override
    public void finish(long dataFileLength) throws IOException {
        if (this.indexes.isEmpty()) {
            throw new IllegalArgumentException("Cannot merge zero tabix files");
        }
        long[] offsets = this.partLengths.stream().mapToLong(i -> i).toArray();
        Arrays.parallelPrefix(offsets, (a, b) -> a + b);
        ArrayList<BinningIndexContent> mergedBinningIndexContentList = new ArrayList<BinningIndexContent>();
        for (int ref = 0; ref < this.sequenceNames.size(); ++ref) {
            int r = ref;
            List<BinningIndexContent> binningIndexContentList = this.indexes.stream().map(index -> index.getIndices()[r]).collect(Collectors.toList());
            BinningIndexContent binningIndexContent = TabixIndexMerger.mergeBinningIndexContent(ref, binningIndexContentList, offsets);
            mergedBinningIndexContentList.add(binningIndexContent);
        }
        TabixIndex tabixIndex = new TabixIndex(this.formatSpec, this.sequenceNames, mergedBinningIndexContentList.toArray(new BinningIndexContent[0]));
        try (LittleEndianOutputStream los = new LittleEndianOutputStream(new BlockCompressedOutputStream(this.out, (File)null));){
            tabixIndex.write(los);
        }
    }

    private static BinningIndexContent mergeBinningIndexContent(int referenceSequence, List<BinningIndexContent> binningIndexContentList, long[] offsets) {
        ArrayList<BinningIndexContent.BinList> binLists = new ArrayList<BinningIndexContent.BinList>();
        ArrayList<LinearIndex> linearIndexes = new ArrayList<LinearIndex>();
        for (BinningIndexContent binningIndexContent : binningIndexContentList) {
            binLists.add(binningIndexContent == null ? null : binningIndexContent.getBins());
            linearIndexes.add(binningIndexContent == null ? null : binningIndexContent.getLinearIndex());
        }
        return new BinningIndexContent(referenceSequence, BAMIndexMerger.mergeBins(binLists, offsets), BAMIndexMerger.mergeLinearIndexes(referenceSequence, linearIndexes, offsets));
    }
}

