/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.BinaryFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.LineIteratorImpl;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.readers.SynchronousLineReader;
import htsjdk.variant.bcf2.BCF2Decoder;
import htsjdk.variant.bcf2.BCF2GenotypeFieldDecoders;
import htsjdk.variant.bcf2.BCF2LazyGenotypesDecoder;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.bcf2.BCFVersion;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BCF2Codec
extends BinaryFeatureCodec<VariantContext> {
    protected static final int ALLOWED_MAJOR_VERSION = 2;
    protected static final int ALLOWED_MINOR_VERSION = 1;
    public static final BCFVersion ALLOWED_BCF_VERSION = new BCFVersion(2, 1);
    public static final int SIZEOF_BCF_HEADER = BCFVersion.MAGIC_HEADER_START.length + 2;
    private BCFVersion bcfVersion = null;
    private VCFHeader header = null;
    private final ArrayList<String> contigNames = new ArrayList();
    private ArrayList<String> dictionary;
    private final BCF2Decoder decoder = new BCF2Decoder();
    private static final int MAX_HEADER_SIZE = 0x8000000;
    private BCF2GenotypeFieldDecoders gtFieldDecoders = null;
    private GenotypeBuilder[] builders = null;
    private int recordNo = 0;
    private int pos = 0;

    @Override
    public Feature decodeLoc(PositionalBufferedStream inputStream) {
        return this.decode(inputStream);
    }

    @Override
    public VariantContext decode(PositionalBufferedStream inputStream) {
        try {
            ++this.recordNo;
            VariantContextBuilder builder = new VariantContextBuilder();
            int sitesBlockSize = this.decoder.readBlockSize(inputStream);
            int genotypeBlockSize = this.decoder.readBlockSize(inputStream);
            this.decoder.readNextBlock(sitesBlockSize, inputStream);
            this.decodeSiteLoc(builder);
            SitesInfoForDecoding info = this.decodeSitesExtendedInfo(builder);
            this.decoder.readNextBlock(genotypeBlockSize, inputStream);
            this.createLazyGenotypesDecoder(info, builder);
            return builder.fullyDecoded(true).make();
        }
        catch (IOException e) {
            throw new TribbleException("Failed to read BCF file", e);
        }
    }

    @Override
    public Class<VariantContext> getFeatureType() {
        return VariantContext.class;
    }

    protected void validateVersionCompatibility(BCFVersion supportedVersion, BCFVersion actualVersion) {
        if (actualVersion.getMajorVersion() != 2) {
            this.error("BCF2Codec can only process BCF2 files, this file has major version " + this.bcfVersion.getMajorVersion());
        }
        if (actualVersion.getMinorVersion() != 1) {
            this.error("BCF2Codec can only process BCF2 files with minor version = 1 but this file has minor version " + this.bcfVersion.getMinorVersion());
        }
    }

    @Override
    public FeatureCodecHeader readHeader(PositionalBufferedStream inputStream) {
        try {
            byte[] headerBytes;
            this.bcfVersion = BCFVersion.readBCFVersion(inputStream);
            if (this.bcfVersion == null) {
                this.error("Input stream does not contain a BCF encoded file; BCF magic header info not found");
            }
            this.validateVersionCompatibility(ALLOWED_BCF_VERSION, this.bcfVersion);
            int headerSizeInBytes = BCF2Type.INT32.read(inputStream);
            if (headerSizeInBytes <= 0 || headerSizeInBytes > 0x8000000) {
                this.error("BCF2 header has invalid length: " + headerSizeInBytes + " must be >= 0 and < 134217728");
            }
            if (inputStream.read(headerBytes = new byte[headerSizeInBytes]) != headerSizeInBytes) {
                this.error("Couldn't read all of the bytes specified in the header length = " + headerSizeInBytes);
            }
            PositionalBufferedStream bps = new PositionalBufferedStream(new ByteArrayInputStream(headerBytes));
            LineIteratorImpl lineIterator = new LineIteratorImpl(new SynchronousLineReader(bps));
            VCFCodec headerParser = new VCFCodec();
            this.header = (VCFHeader)headerParser.readActualHeader(lineIterator);
            bps.close();
        }
        catch (IOException e) {
            throw new TribbleException("I/O error while reading BCF2 header");
        }
        if (!this.header.getContigLines().isEmpty()) {
            this.contigNames.clear();
            for (VCFContigHeaderLine contig : this.header.getContigLines()) {
                if (contig.getID() == null || contig.getID().equals("")) {
                    this.error("found a contig with an invalid ID " + String.valueOf(contig));
                }
                this.contigNames.add(contig.getID());
            }
        } else {
            this.error("Didn't find any contig lines in BCF2 file header");
        }
        this.dictionary = this.parseDictionary(this.header);
        this.gtFieldDecoders = new BCF2GenotypeFieldDecoders(this.header);
        int nSamples = this.header.getNGenotypeSamples();
        this.builders = new GenotypeBuilder[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            this.builders[i] = new GenotypeBuilder(this.header.getGenotypeSamples().get(i));
        }
        return new FeatureCodecHeader(this.header, inputStream.getPosition());
    }

    @Override
    public boolean canDecode(String path) {
        boolean bl;
        block8: {
            InputStream fis = Files.newInputStream(IOUtil.getPath(path), new OpenOption[0]);
            try {
                BCFVersion version = BCFVersion.readBCFVersion(fis);
                boolean bl2 = bl = version != null && version.getMajorVersion() == 2;
                if (fis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            fis.close();
        }
        return bl;
    }

    private final void decodeSiteLoc(VariantContextBuilder builder) throws IOException {
        int contigOffset = this.decoder.decodeInt(BCF2Type.INT32);
        String contig = this.lookupContigName(contigOffset);
        builder.chr(contig);
        this.pos = this.decoder.decodeInt(BCF2Type.INT32) + 1;
        int refLength = this.decoder.decodeInt(BCF2Type.INT32);
        builder.start(this.pos);
        builder.stop(this.pos + refLength - 1);
    }

    private final SitesInfoForDecoding decodeSitesExtendedInfo(VariantContextBuilder builder) throws IOException {
        Object qual = this.decoder.decodeSingleValue(BCF2Type.FLOAT);
        if (qual != null) {
            builder.log10PError((Double)qual / -10.0);
        }
        int nAlleleInfo = this.decoder.decodeInt(BCF2Type.INT32);
        int nFormatSamples = this.decoder.decodeInt(BCF2Type.INT32);
        int nAlleles = nAlleleInfo >> 16;
        int nInfo = nAlleleInfo & 0xFFFF;
        int nFormatFields = nFormatSamples >> 24;
        int nSamples = nFormatSamples & 0xFFFFF;
        if (this.header.getNGenotypeSamples() != nSamples) {
            this.error("Reading BCF2 files with different numbers of samples per record is not currently supported.  Saw " + this.header.getNGenotypeSamples() + " samples in header but have a record with " + nSamples + " samples");
        }
        this.decodeID(builder);
        List<Allele> alleles = this.decodeAlleles(builder, this.pos, nAlleles);
        this.decodeFilter(builder);
        this.decodeInfo(builder, nInfo);
        SitesInfoForDecoding info = new SitesInfoForDecoding(nFormatFields, nSamples, alleles);
        if (!info.isValid()) {
            this.error("Sites info is malformed: " + String.valueOf(info));
        }
        return info;
    }

    private void decodeID(VariantContextBuilder builder) throws IOException {
        String id = (String)this.decoder.decodeTypedValue();
        if (id == null) {
            builder.noID();
        } else {
            builder.id(id);
        }
    }

    private List<Allele> decodeAlleles(VariantContextBuilder builder, int pos, int nAlleles) throws IOException {
        ArrayList<Allele> alleles = new ArrayList<Allele>(nAlleles);
        String ref = null;
        for (int i = 0; i < nAlleles; ++i) {
            String alleleBases = (String)this.decoder.decodeTypedValue();
            boolean isRef = i == 0;
            Allele allele = Allele.create(alleleBases, isRef);
            if (isRef) {
                ref = alleleBases;
            }
            alleles.add(allele);
        }
        assert (ref != null);
        builder.alleles((Collection<Allele>)alleles);
        assert (!ref.isEmpty());
        return alleles;
    }

    private void decodeFilter(VariantContextBuilder builder) throws IOException {
        Object value = this.decoder.decodeTypedValue();
        if (value == null) {
            builder.unfiltered();
        } else if (value instanceof Integer) {
            String filterString = this.getDictionaryString((Integer)value);
            if ("PASS".equals(filterString)) {
                builder.passFilters();
            } else {
                builder.filter(filterString);
            }
        } else {
            Iterator iterator = ((List)value).iterator();
            while (iterator.hasNext()) {
                int offset = (Integer)iterator.next();
                builder.filter(this.getDictionaryString(offset));
            }
        }
    }

    private void decodeInfo(VariantContextBuilder builder, int numInfoFields) throws IOException {
        if (numInfoFields == 0) {
            return;
        }
        HashMap<String, Object> infoFieldEntries = new HashMap<String, Object>(numInfoFields);
        for (int i = 0; i < numInfoFields; ++i) {
            String key = this.getDictionaryString();
            Object value = this.decoder.decodeTypedValue();
            VCFCompoundHeaderLine metaData = VariantContextUtils.getMetaDataForField(this.header, key);
            if (metaData.getType() == VCFHeaderLineType.Flag) {
                value = true;
            }
            infoFieldEntries.put(key, value);
        }
        builder.attributes(infoFieldEntries);
    }

    private void createLazyGenotypesDecoder(SitesInfoForDecoding siteInfo, VariantContextBuilder builder) {
        if (siteInfo.nSamples > 0) {
            BCF2LazyGenotypesDecoder lazyParser = new BCF2LazyGenotypesDecoder(this, siteInfo.alleles, siteInfo.nSamples, siteInfo.nFormatFields, this.builders);
            LazyData lazyData = new LazyData(this.header, siteInfo.nFormatFields, this.decoder.getRecordBytes());
            LazyGenotypesContext lazy = new LazyGenotypesContext(lazyParser, lazyData, this.header.getNGenotypeSamples());
            if (!this.header.samplesWereAlreadySorted()) {
                lazy.decode();
            }
            builder.genotypesNoValidation(lazy);
        }
    }

    private final String getDictionaryString() throws IOException {
        return this.getDictionaryString((Integer)this.decoder.decodeTypedValue());
    }

    protected final String getDictionaryString(int offset) {
        return this.dictionary.get(offset);
    }

    private final String lookupContigName(int contigOffset) {
        return this.contigNames.get(contigOffset);
    }

    private final ArrayList<String> parseDictionary(VCFHeader header) {
        ArrayList<String> dict = BCF2Utils.makeDictionary(header);
        if (dict.isEmpty()) {
            this.error("Dictionary header element was absent or empty");
        }
        return dict;
    }

    protected VCFHeader getHeader() {
        return this.header;
    }

    protected BCF2GenotypeFieldDecoders.Decoder getGenotypeFieldDecoder(String field) {
        return this.gtFieldDecoders.getDecoder(field);
    }

    protected void error(String message) throws RuntimeException {
        throw new TribbleException(String.format("%s, at record %d with position %d:", message, this.recordNo, this.pos));
    }

    public static BCFVersion tryReadBCFVersion(BufferedInputStream uncompressedBufferedInput) throws IOException {
        uncompressedBufferedInput.mark(SIZEOF_BCF_HEADER);
        BCFVersion bcfVersion = BCFVersion.readBCFVersion(uncompressedBufferedInput);
        uncompressedBufferedInput.reset();
        return bcfVersion;
    }

    protected static final class SitesInfoForDecoding {
        final int nFormatFields;
        final int nSamples;
        final List<Allele> alleles;

        private SitesInfoForDecoding(int nFormatFields, int nSamples, List<Allele> alleles) {
            this.nFormatFields = nFormatFields;
            this.nSamples = nSamples;
            this.alleles = alleles;
        }

        public boolean isValid() {
            return this.nFormatFields >= 0 && this.nSamples >= 0 && this.alleles != null && !this.alleles.isEmpty() && this.alleles.get(0).isReference();
        }

        public String toString() {
            return String.format("nFormatFields = %d, nSamples = %d, alleles = %s", this.nFormatFields, this.nSamples, this.alleles);
        }
    }

    public static class LazyData {
        public final VCFHeader header;
        public final int nGenotypeFields;
        public final byte[] bytes;

        public LazyData(VCFHeader header, int nGenotypeFields, byte[] bytes) {
            this.header = header;
            this.nGenotypeFields = nGenotypeFields;
            this.bytes = bytes;
        }
    }
}

