/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.example;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.bed.BEDCodec;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.linear.LinearIndex;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CountRecords {
    public static void main(String[] args) {
        File featureFile;
        if (args.length > 2) {
            CountRecords.printUsage();
        }
        if (!(featureFile = new File(args[0])).exists()) {
            System.err.println("File " + featureFile.getAbsolutePath() + " doesnt' exist");
            CountRecords.printUsage();
        }
        int optimizeIndex = args.length == 2 ? Integer.parseInt(args[1]) : -1;
        FeatureCodec codec = CountRecords.getFeatureCodec(featureFile);
        CountRecords.runWithIndex(featureFile, codec, optimizeIndex);
    }

    public static long runWithIndex(File featureInput, FeatureCodec codec, int optimizeThreshold) {
        Index index = CountRecords.loadIndex(featureInput, codec);
        if (optimizeThreshold != -1) {
            ((LinearIndex)index).optimize(optimizeThreshold);
        }
        AbstractFeatureReader reader = null;
        try {
            reader = AbstractFeatureReader.getFeatureReader(featureInput.getAbsolutePath(), codec, index);
            long recordCount = 0L;
            CloseableTribbleIterator iter = reader.iterator();
            while (iter.hasNext()) {
                Feature feat = (Feature)iter.next();
                ++recordCount;
            }
            System.err.println("We saw " + recordCount + " record in file " + String.valueOf(featureInput));
            return recordCount;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Something went wrong while reading feature file " + String.valueOf(featureInput), e);
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar CountRecords.jar <inputFile>");
        System.err.println("    Where input can be of type: VCF (ends in .vcf or .VCF");
        System.err.println("                                Bed (ends in .bed or .bed");
        System.exit(1);
    }

    public static Index loadIndex(File featureFile, FeatureCodec codec) {
        File indexFile = Tribble.indexFile(featureFile);
        Index index = null;
        if (indexFile.canRead()) {
            System.err.println("Loading index from disk for index file -> " + String.valueOf(indexFile));
            index = IndexFactory.loadIndex(indexFile.getAbsolutePath());
        } else {
            System.err.println("Creating the index and memory, then writing to disk for index file -> " + String.valueOf(indexFile));
            index = CountRecords.createAndWriteNewIndex(featureFile, indexFile, codec);
        }
        return index;
    }

    public static Index createAndWriteNewIndex(File featureFile, File indexFile, FeatureCodec codec) {
        try {
            LinearIndex index = IndexFactory.createLinearIndex(featureFile, codec);
            LittleEndianOutputStream stream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            index.write(stream);
            stream.close();
            return index;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to create index from file " + String.valueOf(featureFile), e);
        }
    }

    public static FeatureCodec getFeatureCodec(File featureFile) {
        if (featureFile.getName().endsWith(".bed") || featureFile.getName().endsWith(".BED")) {
            return new BEDCodec();
        }
        throw new IllegalArgumentException("Unable to determine correct file type based on the file name, for file -> " + String.valueOf(featureFile));
    }
}

