/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.ChromAliasSource;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ucsc.bb.BBFile;

public class ChromAliasBB
extends ChromAliasSource {
    BBFile reader;

    public ChromAliasBB(String path, Genome genome) throws IOException {
        this.reader = new BBFile(path, genome);
    }

    @Override
    public String getChromosomeName(String alias) {
        if (this.aliasCache.containsKey(alias)) {
            return ((ChromAlias)this.aliasCache.get(alias)).getChr();
        }
        try {
            ChromAlias aliasRecord = this.search(alias);
            if (aliasRecord != null) {
                return aliasRecord.getChr();
            }
            aliasRecord.put(alias, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getChromosomeAlias(String chr, String nameSet) {
        ChromAlias aliasRecord = (ChromAlias)this.aliasCache.get(chr);
        return aliasRecord != null && aliasRecord.containsKey(nameSet) ? aliasRecord.get(nameSet) : chr;
    }

    @Override
    public ChromAlias search(String alias) throws IOException {
        BasicFeature f;
        if (!this.aliasCache.containsKey(alias) && (f = this.reader.search(alias)) != null) {
            String chr = f.getChr();
            ChromAlias aliasRecord = new ChromAlias(chr);
            this.aliasCache.put(chr, aliasRecord);
            for (String key : f.getAttributeKeys()) {
                String a = f.getAttribute(key);
                aliasRecord.put(key, a);
                this.aliasCache.put(a, aliasRecord);
            }
        }
        return (ChromAlias)this.aliasCache.get(alias);
    }

    public String[] getChromosomeNames() {
        return this.reader.getChromosomeNames();
    }
}

