/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ultima.render;

import java.awt.Color;
import java.util.Arrays;

public class ColorMap {
    public int size;
    public byte[] r;
    public byte[] g;
    public byte[] b;
    public Color[] table;

    public static ColorMap getJet() {
        return ColorMap.getJet(64);
    }

    public static ColorMap getJet(int n) {
        int x;
        byte[] r = new byte[n];
        byte[] g = new byte[n];
        byte[] b = new byte[n];
        int maxval = 255;
        Arrays.fill(g, 0, n / 8, (byte)0);
        for (x = 0; x < n / 4; ++x) {
            g[x + n / 8] = (byte)(maxval * x * 4 / n);
        }
        Arrays.fill(g, n * 3 / 8, n * 5 / 8, (byte)maxval);
        for (x = 0; x < n / 4; ++x) {
            g[x + n * 5 / 8] = (byte)(maxval - maxval * x * 4 / n);
        }
        Arrays.fill(g, n * 7 / 8, n, (byte)0);
        for (x = 0; x < g.length; ++x) {
            b[x] = g[(x + n / 4) % g.length];
        }
        Arrays.fill(b, n * 7 / 8, n, (byte)0);
        Arrays.fill(g, 0, n / 8, (byte)0);
        for (x = n / 8; x < g.length; ++x) {
            r[x] = g[(x + n * 6 / 8) % g.length];
        }
        ColorMap cm = new ColorMap();
        cm.size = n;
        cm.r = r;
        cm.g = g;
        cm.b = b;
        cm.table = new Color[n];
        for (int x2 = 0; x2 < n; ++x2) {
            cm.table[x2] = new Color(cm.getColor(x2));
        }
        return cm;
    }

    public int getColor(int idx) {
        idx = Math.max(0, Math.min(idx, this.r.length - 1));
        int pixel = this.r[idx] << 16 & 0xFF0000 | this.g[idx] << 8 & 0xFF00 | this.b[idx] & 0xFF;
        return pixel;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(500);
        for (int x = 0; x < this.size; ++x) {
            s.append(x + ": {" + this.r[x] + ",\t" + this.g[x] + ",\t" + this.b[x] + "}\t");
            if (x % 3 != 2) continue;
            s.append("\n");
        }
        return s.toString();
    }

    public static void main(String[] args) {
        ColorMap jet = ColorMap.getJet();
        ColorMap jet128 = ColorMap.getJet(128);
        System.out.println("Jet:\n" + jet + "\n\nJet128:\n" + jet128);
    }
}

