/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.ChromAliasSource;
import org.broad.igv.util.ParsingUtils;

public class ChromAliasFile
extends ChromAliasSource {
    private String[] nameSets;

    public ChromAliasFile(String path, List<String> chromosomeNames) throws IOException {
        try (BufferedReader br = ParsingUtils.openBufferedReader(path);){
            String line;
            this.aliasCache = new HashMap();
            Set<String> chromosomeNameSet = chromosomeNames != null ? new HashSet<String>(chromosomeNames) : Collections.EMPTY_SET;
            boolean firstLine = true;
            while ((line = br.readLine()) != null) {
                if (firstLine && line.startsWith("#")) {
                    tokens = line.substring(1).split("\t");
                    this.nameSets = new String[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        this.nameSets[i] = tokens[i].trim();
                    }
                } else {
                    tokens = line.split("\t");
                    if (tokens.length > 1) {
                        String chr = null;
                        for (String c : tokens) {
                            if (!chromosomeNameSet.contains(c)) continue;
                            chr = c;
                            break;
                        }
                        if (chr == null) {
                            chr = tokens[0];
                        }
                        ChromAlias aliasRecord = new ChromAlias(chr);
                        this.aliasCache.put(chr, aliasRecord);
                        for (int i = 0; i < tokens.length; ++i) {
                            String key = this.nameSets != null ? this.nameSets[i] : String.valueOf(i);
                            aliasRecord.put(key, tokens[i]);
                            this.aliasCache.put(tokens[i], aliasRecord);
                        }
                    }
                }
                firstLine = false;
            }
        }
    }

    public ChromAliasFile(List<List<String>> chromAliases, List<String> chromosomeNames) throws IOException {
        Set<String> chromosomeNameSet = chromosomeNames != null ? new HashSet<String>(chromosomeNames) : Collections.EMPTY_SET;
        for (List<String> aliases : chromAliases) {
            if (aliases.size() <= 1) continue;
            String chr = null;
            for (String c : aliases) {
                if (!chromosomeNameSet.contains(c)) continue;
                chr = c;
                break;
            }
            if (chr == null) {
                chr = aliases.get(0);
            }
            ChromAlias aliasRecord = new ChromAlias(chr);
            this.aliasCache.put(chr, aliasRecord);
            int idx = 0;
            for (String a : aliases) {
                String key = String.valueOf(idx++);
                aliasRecord.put(key, a);
                this.aliasCache.put(a, aliasRecord);
            }
        }
    }

    @Override
    public String getChromosomeName(String alias) {
        return this.aliasCache.containsKey(alias) ? ((ChromAlias)this.aliasCache.get(alias)).getChr() : alias;
    }

    @Override
    public String getChromosomeAlias(String chr, String nameSet) {
        ChromAlias aliasRecord = (ChromAlias)this.aliasCache.get(chr);
        return aliasRecord != null && aliasRecord.containsKey(nameSet) ? aliasRecord.get(nameSet) : chr;
    }

    @Override
    public ChromAlias search(String alias) {
        return (ChromAlias)this.aliasCache.get(alias);
    }
}

