/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.aa;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.aa.AminoAcid;
import org.broad.igv.feature.aa.AminoAcidSequence;
import org.broad.igv.feature.aa.CodonAA;
import org.broad.igv.feature.aa.CodonTable;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.SequenceTrack;

public class AminoAcidManager {
    private static final Logger log = LogManager.getLogger(AminoAcidManager.class);
    private static final String AANameFilePath = "resources/AANamesTable.txt";
    static final Map<String, AminoAcid> AANameMap = new HashMap<String, AminoAcid>(20);
    private static AminoAcidManager instance;

    private AminoAcidManager() {
        AminoAcidManager.initAANameMap();
    }

    public static AminoAcidManager getInstance() {
        if (instance == null) {
            AminoAcidManager newInstance;
            instance = newInstance = new AminoAcidManager();
        }
        return instance;
    }

    List<CodonAA> getAminoAcids(Strand direction, String sequence, CodonTable codonTable) {
        int readLength = sequence.length() / 3;
        ArrayList<CodonAA> acids = new ArrayList<CodonAA>(readLength);
        if (direction == Strand.NEGATIVE) {
            sequence = SequenceTrack.getReverseComplement(sequence);
        }
        for (int i = 0; i <= sequence.length() - 3; i += 3) {
            String codon = sequence.substring(i, i + 3).toUpperCase();
            AminoAcid aa = codonTable.getAminoAcid(codon);
            CodonAA cAA = new CodonAA(codon, aa);
            acids.add(cAA);
        }
        if (direction == Strand.NEGATIVE) {
            Collections.reverse(acids);
        }
        return acids;
    }

    public AminoAcidSequence getAminoAcidSequence(Strand strand, int start, String nucSequence, CodonTable codonTable) {
        if (nucSequence == null) {
            return null;
        }
        int l = nucSequence.length();
        int rem = l % 3;
        int aaStart = strand == Strand.POSITIVE ? 0 : 0 + rem;
        List<CodonAA> acids = this.getAminoAcids(strand, nucSequence, codonTable);
        return new AminoAcidSequence(strand, start + aaStart, acids, codonTable.getId());
    }

    public static AminoAcid getAminoAcidByName(String name) {
        AminoAcidManager.initAANameMap();
        AminoAcid aa = AANameMap.get(name);
        if (aa == null) {
            aa = AminoAcid.NULL_AMINO_ACID;
        }
        return aa;
    }

    public Set<String> getMappingSNPs(String codon, AminoAcid mutAA, CodonTable codonTable) {
        HashSet<String> mapSNPs = new HashSet<String>();
        Set<String> SNPs = AminoAcidManager.getAllSNPs(codon);
        for (String modCodon : SNPs) {
            if (!codonTable.getAminoAcid(modCodon).equalsByName(mutAA.getShortName())) continue;
            mapSNPs.add(modCodon);
        }
        return mapSNPs;
    }

    public static Set<String> getAllSNPs(String sequence) {
        HashSet<String> SNPs = new HashSet<String>();
        char[] bps = "ATGC".toCharArray();
        char[] orig = sequence.toCharArray();
        for (int loc = 0; loc < orig.length; ++loc) {
            char[] mod = (char[])orig.clone();
            for (char bp : bps) {
                if (bp == orig[loc]) continue;
                mod[loc] = bp;
                SNPs.add(new String(mod));
            }
        }
        return SNPs;
    }

    public static synchronized void initAANameMap() {
        if (!AANameMap.isEmpty()) {
            return;
        }
        try {
            String nextLine;
            InputStream is = AminoAcidManager.class.getResourceAsStream(AANameFilePath);
            if (is == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#") || (tokens = nextLine.split("\t")).length != 3) continue;
                String fullName = tokens[0].trim();
                String shortName = tokens[1].trim();
                String symbol = tokens[2].trim();
                assert (symbol.length() == 1);
                AminoAcid aa = new AminoAcid(fullName, shortName, symbol.charAt(0));
                for (String sym : new String[]{fullName, shortName, symbol}) {
                    if (AANameMap.containsKey(sym)) continue;
                    AANameMap.put(sym, aa);
                }
            }
        }
        catch (IOException ex) {
            log.error(ex);
            throw new RuntimeException(ex);
        }
    }
}

