/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.IGVNamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class JsonGenomeLoader
extends GenomeLoader {
    private static Logger log = LogManager.getLogger(JsonGenomeLoader.class);
    private String genomePath;

    public JsonGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Genome loadGenome() throws IOException {
        try (BufferedReader reader = null;){
            Genome genome;
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            String jsonString = ParsingUtils.readContentsAsString(this.genomePath);
            if (jsonString.contains("chromosomeOrder")) {
                jsonString = this.fixChromosomeOrder(jsonString);
            }
            GenomeConfig genomeConfig = GenomeConfig.fromJson(jsonString);
            this.fixPaths(genomeConfig);
            Genome genome2 = genome = new Genome(genomeConfig);
            return genome2;
        }
    }

    private String fixChromosomeOrder(String jsonString) {
        Map obj = (Map)new Gson().fromJson(jsonString, Map.class);
        Object chromosomeOrder = obj.get("chromosomeOrder");
        if (chromosomeOrder != null && chromosomeOrder instanceof String) {
            obj.put("chromosomeOrder", Arrays.stream(((String)chromosomeOrder).split(",")).map(c -> c.trim()).toArray());
        }
        return new Gson().toJson((Object)obj);
    }

    private GenomeConfig fixPaths(GenomeConfig config) {
        List<TrackConfig> trackConfigs;
        if (config.chromAliasBbURL != null) {
            config.chromAliasBbURL = FileUtils.getAbsolutePath(config.chromAliasBbURL, this.genomePath);
        }
        if (config.twoBitURL != null) {
            config.twoBitURL = FileUtils.getAbsolutePath(config.twoBitURL, this.genomePath);
        }
        if (config.cytobandBbURL != null) {
            config.cytobandBbURL = FileUtils.getAbsolutePath(config.cytobandBbURL, this.genomePath);
        }
        if (config.chromSizesURL != null) {
            config.chromSizesURL = FileUtils.getAbsolutePath(config.chromSizesURL, this.genomePath);
        }
        if (config.fastaURL != null) {
            config.fastaURL = FileUtils.getAbsolutePath(config.fastaURL, this.genomePath);
        }
        if (config.indexURL != null) {
            config.indexURL = FileUtils.getAbsolutePath(config.indexURL, this.genomePath);
        }
        if (config.gziIndexURL != null) {
            config.gziIndexURL = FileUtils.getAbsolutePath(config.gziIndexURL, this.genomePath);
        }
        if (config.compressedIndexURL != null) {
            config.compressedIndexURL = FileUtils.getAbsolutePath(config.compressedIndexURL, this.genomePath);
        }
        if (config.cytobandURL != null) {
            config.cytobandURL = FileUtils.getAbsolutePath(config.cytobandURL, this.genomePath);
        }
        if (config.aliasURL != null) {
            config.aliasURL = FileUtils.getAbsolutePath(config.aliasURL, this.genomePath);
        }
        if (config.chromAliasBbURL != null) {
            config.chromAliasBbURL = FileUtils.getAbsolutePath(config.chromAliasBbURL, this.genomePath);
        }
        if ((trackConfigs = config.tracks) == null) {
            trackConfigs = config.annotations;
        }
        if (trackConfigs != null) {
            trackConfigs.forEach(trackConfig -> {
                if (trackConfig.url != null) {
                    trackConfig.url = FileUtils.getAbsolutePath(trackConfig.url, this.genomePath);
                }
                if (trackConfig.indexURL != null) {
                    trackConfig.indexURL = FileUtils.getAbsolutePath(trackConfig.indexURL, this.genomePath);
                }
            });
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeDescriptor loadDescriptor() throws IOException {
        try (BufferedReader reader = null;){
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
            String id = json.get("id").getAsString();
            String name = json.get("name").getAsString();
            String fastaPath = json.get("fastaURL").getAsString();
            GenomeDescriptor genomeDescriptor = new GenomeDescriptor(id, name, fastaPath);
            return genomeDescriptor;
        }
    }

    private void addToFeatureDB(List<ResourceLocator> locators, Genome genome) {
        for (ResourceLocator locator : locators) {
            try {
                AbstractFeatureReader featureReader = TribbleFeatureSource.getBasicReader(locator, genome);
                for (Feature f : featureReader) {
                    if (!(f instanceof IGVNamedFeature)) continue;
                    FeatureDB.addFeature((IGVNamedFeature)f, genome);
                }
            }
            catch (IOException e) {
                log.error("Error loading " + locator.getPath());
            }
        }
    }

    private String stripQuotes(String str) {
        if (str.startsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static class GenomeDescriptor {
        String id;
        String name;
        String fastaURL;

        public GenomeDescriptor(String id, String name, String fastaURL) {
            this.id = id;
            this.name = name;
            this.fastaURL = fastaURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getFastaURL() {
            return this.fastaURL;
        }
    }
}

