/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import java.util.HashMap;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;

public class ChromTree {
    private Header header;
    private HashMap<String, Integer> nameToId;
    private String[] idToName;
    public long sumLengths = 0L;

    public static ChromTree parseTree(UnsignedByteBuffer buffer, int startOffset, Genome genome) {
        return new ChromTree().parse(buffer, startOffset, genome);
    }

    private ChromTree() {
    }

    public Integer getIdForName(String chr) {
        return this.nameToId.get(chr);
    }

    public String getNameForId(int id) {
        if (id < 0 || id >= this.idToName.length) {
            return null;
        }
        return this.idToName[id];
    }

    public String[] names() {
        return this.idToName;
    }

    public ChromTree parse(UnsignedByteBuffer buffer, int startOffset, Genome genome) {
        Header header = new Header();
        header.magic = buffer.getInt();
        header.blockSize = buffer.getInt();
        header.keySize = buffer.getInt();
        header.valSize = buffer.getInt();
        header.itemCount = buffer.getLong();
        header.reserved = buffer.getLong();
        this.header = header;
        if (header.valSize != 8) {
            throw new RuntimeException("Unexpected valSize: " + header.valSize);
        }
        this.nameToId = new HashMap();
        this.idToName = new String[(int)header.itemCount];
        this.readTreeNode(-1L, startOffset, buffer, genome);
        return this;
    }

    void readTreeNode(long offset, int startOffset, UnsignedByteBuffer buffer, Genome genome) {
        if (offset >= 0L) {
            buffer.position((int)offset);
        }
        byte type = buffer.get();
        byte reserved = buffer.get();
        int count = buffer.getUShort();
        if (type == 1) {
            for (int i = 0; i < count; ++i) {
                String key = buffer.getFixedLengthString(this.header.keySize);
                int value = buffer.getInt();
                int chromSize = buffer.getInt();
                this.nameToId.put(key, value);
                this.idToName[value] = key;
                this.sumLengths += (long)chromSize;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                String key = buffer.getFixedLengthString(this.header.keySize);
                long childOffset = buffer.getLong();
                long bufferOffset = childOffset - (long)startOffset;
                long currOffset = buffer.position();
                this.readTreeNode(bufferOffset, startOffset, buffer, genome);
                buffer.position((int)currOffset);
            }
        }
    }

    static class Header {
        int magic;
        int blockSize;
        int keySize;
        int valSize;
        long itemCount;
        long reserved;

        Header() {
        }
    }
}

