/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.ChromAliasSource;
import org.broad.igv.util.StringUtils;

public class ChromAliasDefaults
extends ChromAliasSource {
    public ChromAliasDefaults(String id, List<String> chromosomeNames) {
        this.init(id, chromosomeNames);
    }

    private void init(String id, List<String> chromosomeNames) {
        HashSet<String> allNames = new HashSet<String>(chromosomeNames);
        ArrayList<ChromAlias> aliasRecords = new ArrayList<ChromAlias>();
        for (String name : chromosomeNames) {
            int idx;
            String alias;
            boolean skipRest = false;
            ChromAlias record = new ChromAlias(name);
            aliasRecords.add(record);
            int version = ChromAliasDefaults.getVersion(name);
            if (version >= 0 && !allNames.contains(alias = name.substring(0, idx = name.indexOf(".")))) {
                record.put("ncbi-noversion", alias);
            }
            if (name.startsWith("gi|")) {
                String alias2 = ChromAliasDefaults.getNCBIName(name);
                record.put("ncbi-gi-versioned", alias2);
                int dotIndex = alias2.lastIndexOf(46);
                if (dotIndex <= 0 || allNames.contains(name.substring(0, name.lastIndexOf(46)))) continue;
                alias2 = alias2.substring(0, dotIndex);
                record.put("ncbi-gi", alias2);
                continue;
            }
            if (id.startsWith("hg") || id.equals("1kg_ref") || id.equals("b37")) {
                switch (name) {
                    case "chrX": {
                        record.put("ncbi", "23");
                        record.put("?", "X");
                        skipRest = true;
                        break;
                    }
                    case "chrY": {
                        record.put("ncbi", "24");
                        record.put("?", "Y");
                        skipRest = true;
                    }
                }
            } else if (id.startsWith("GRCh")) {
                switch (name) {
                    case "23": {
                        record.put("ucsc", "chrX");
                        skipRest = true;
                        break;
                    }
                    case "24": {
                        record.put("ucsc", "chrY");
                        skipRest = true;
                    }
                }
            } else if (id.startsWith("mm") || id.startsWith("rheMac")) {
                switch (name) {
                    case "chrX": {
                        record.put("ncbi", "21");
                        skipRest = true;
                        break;
                    }
                    case "chrY": {
                        record.put("ncbi", "22");
                        skipRest = true;
                    }
                }
            } else if (id.startsWith("GRCm")) {
                switch (name) {
                    case "21": {
                        record.put("ucsc", "chrX");
                        skipRest = true;
                        break;
                    }
                    case "22": {
                        record.put("ucsc", "chrY");
                        skipRest = true;
                    }
                }
            }
            if (skipRest) continue;
            if (name.equals("chrM")) {
                record.put("ncbi", "MT");
                continue;
            }
            if (name.equals("MT")) {
                record.put("ucsc", "chrM");
                continue;
            }
            if (name.toLowerCase().startsWith("chr")) {
                record.put("ncbi", name.substring(3));
                continue;
            }
            if (!StringUtils.isSmallPositiveInteger(name)) continue;
            record.put("ucsc", "chr" + name);
        }
        for (ChromAlias rec : aliasRecords) {
            for (String a : rec.values()) {
                this.aliasCache.put(a, rec);
            }
        }
    }

    @Override
    public String getChromosomeName(String alias) {
        return this.aliasCache.containsKey(alias) ? ((ChromAlias)this.aliasCache.get(alias)).get("chr") : alias;
    }

    @Override
    public String getChromosomeAlias(String chr, String nameSet) {
        ChromAlias aliasRecord = (ChromAlias)this.aliasCache.get(chr);
        return aliasRecord != null && aliasRecord.containsKey(nameSet) ? aliasRecord.get(nameSet) : chr;
    }

    @Override
    public ChromAlias search(String alias) {
        return (ChromAlias)this.aliasCache.get(alias);
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    private static Integer getVersion(String name) {
        String possibleVersion;
        int idx = name.lastIndexOf(".");
        if (idx > 1 && StringUtils.isSmallPositiveInteger(possibleVersion = name.substring(idx + 1))) {
            return Integer.parseInt(possibleVersion);
        }
        return -1;
    }
}

