/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.exception.HtsjdkException;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.exception.HtsjdkPluginException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.HtsCodec;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HtsCodecResolver<C extends HtsCodec<?, ?>> {
    private static final Log LOG = Log.getInstance(HtsCodecResolver.class);
    static final String NO_SUPPORTING_CODEC_ERROR = "No registered codec accepts the provided resource";
    static final String MULTIPLE_SUPPORTING_CODECS_ERROR = "Multiple codecs accept the provided resource";
    private final String requiredContentType;
    private final Map<String, Map<HtsVersion, C>> codecs = new HashMap<String, Map<HtsVersion, C>>();

    public HtsCodecResolver(String requiredContentType) {
        this.requiredContentType = requiredContentType;
    }

    public C registerCodec(C codec) {
        String fileFormat = codec.getFileFormat();
        Map<HtsVersion, C> versionMap = this.codecs.get(fileFormat);
        if (versionMap == null) {
            HashMap<HtsVersion, C> newMap = new HashMap<HtsVersion, C>();
            newMap.put(codec.getVersion(), codec);
            this.codecs.put(fileFormat, newMap);
            return null;
        }
        HtsCodec oldCodec = (HtsCodec)versionMap.put(codec.getVersion(), codec);
        if (oldCodec != null) {
            LOG.warn(String.format("A previously registered HTS codec (%s) was replaced with the (%s) codec ", oldCodec.getDisplayName(), codec.getDisplayName()));
        }
        return (C)oldCodec;
    }

    public C resolveForDecoding(Bundle bundle) {
        ValidationUtils.nonNull(bundle, "bundle");
        BundleResource bundleResource = this.getPrimaryResource(bundle, true);
        Optional<String> optFormatString = bundleResource.getFileFormat();
        List<C> candidateCodecs = this.resolveForFormat(optFormatString);
        List<C> resolvedCodecs = bundleResource.getIOPath().isPresent() ? this.resolveForDecodingIOPath(bundleResource, candidateCodecs) : this.resolveForDecodingStream(bundleResource, candidateCodecs);
        return HtsCodecResolver.getOneOrThrow(resolvedCodecs, () -> String.format("%s/%s", optFormatString.isPresent() ? optFormatString.get() : "(NONE)", bundleResource));
    }

    public C resolveForEncoding(Bundle bundle) {
        return this.resolveForEncoding(bundle, HtsVersion.NEWEST_VERSION);
    }

    public C resolveForEncoding(Bundle bundle, HtsVersion htsVersion) {
        ValidationUtils.nonNull(bundle, "bundle");
        ValidationUtils.nonNull(htsVersion, "htsVersion");
        BundleResource bundleResource = this.getPrimaryResource(bundle, false);
        Optional<String> optFormatString = bundleResource.getFileFormat();
        List<C> candidateCodecs = this.resolveForFormat(optFormatString);
        Optional<IOPath> ioPath = bundleResource.getIOPath();
        List<C> filteredCodecs = bundleResource.getIOPath().isPresent() ? this.resolveForEncodingIOPath(ioPath.get(), candidateCodecs) : candidateCodecs;
        List<C> resolvedCodecs = this.filterByVersion(filteredCodecs, htsVersion);
        return HtsCodecResolver.getOneOrThrow(resolvedCodecs, () -> String.format("%s/%s", optFormatString.isPresent() ? optFormatString.get() : "(NONE)", bundleResource));
    }

    public List<C> resolveForFormat(String format) {
        Map<HtsVersion, C> allCodecsForFormat = this.codecs.get(format);
        if (allCodecsForFormat != null) {
            return allCodecsForFormat.values().stream().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public C resolveFormatAndVersion(String format, HtsVersion formatVersion) {
        List matchingCodecs = this.resolveForFormat(format).stream().filter(codec -> codec.getFileFormat().equals(format) && codec.getVersion().equals(formatVersion)).collect(Collectors.toList());
        return (C)HtsCodecResolver.getOneOrThrow(matchingCodecs, () -> String.format("%s/%s", format, formatVersion));
    }

    public List<C> getCodecs() {
        List codecList = this.codecs.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
        return codecList;
    }

    private List<C> resolveForDecodingIOPath(BundleResource bundleResource, List<C> candidateCodecs) {
        ValidationUtils.validateArg(bundleResource.getIOPath().isPresent(), "an IOPath resource is required");
        IOPath ioPath = bundleResource.getIOPath().get();
        if (candidateCodecs.size() > 0) {
            List<C> uriOwners = this.getURIOwners(candidateCodecs, ioPath);
            if (!uriOwners.isEmpty()) {
                return uriOwners;
            }
            byte[] signatureBuffer = this.getSignatureProbeBuffer(bundleResource, candidateCodecs);
            return candidateCodecs.stream().filter(codec -> codec.canDecodeURI(ioPath)).filter(codec -> codec.canDecodeSignature(new SignatureStream(signatureBuffer.length, signatureBuffer), bundleResource.getDisplayName())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<C> resolveForDecodingStream(BundleResource bundleResource, List<C> candidateCodecs) {
        byte[] signatureBuffer = this.getSignatureProbeBuffer(bundleResource, candidateCodecs);
        return candidateCodecs.stream().filter(codec -> codec.canDecodeSignature(new SignatureStream(signatureBuffer.length, signatureBuffer), bundleResource.getDisplayName())).collect(Collectors.toList());
    }

    private final byte[] getSignatureProbeBuffer(BundleResource bundleResource, List<C> candidateCodecs) {
        byte[] byArray;
        block9: {
            int maxSignatureProbeLength = this.getMaxSignatureProbeLength(candidateCodecs);
            SignatureStream probingStream = bundleResource.getIOPath().isPresent() ? this.getIOPathSignatureProbingStream(bundleResource, maxSignatureProbeLength) : bundleResource.getSignatureStream(maxSignatureProbeLength);
            try {
                byte[] signatureBytes = new byte[probingStream.getSignaturePrefixLength()];
                int readSize = probingStream.read(signatureBytes);
                if (readSize != maxSignatureProbeLength) {
                    throw new HtsjdkPluginException(String.format("Failure to read %d bytes from signature stream for %s (only read %d)", maxSignatureProbeLength, bundleResource, readSize));
                }
                byArray = signatureBytes;
                if (probingStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (probingStream != null) {
                        try {
                            probingStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new HtsjdkIOException(String.format("error closing signature stream for %s", bundleResource.getDisplayName()), e);
                }
            }
            probingStream.close();
        }
        return byArray;
    }

    private List<C> resolveForEncodingIOPath(IOPath ioPath, List<C> candidateCodecs) {
        List uriHandlers = candidateCodecs.stream().filter(codec -> codec.ownsURI(ioPath)).collect(Collectors.toList());
        List<Object> filteredCodecs = uriHandlers.isEmpty() ? candidateCodecs : uriHandlers;
        return filteredCodecs.stream().filter(c -> c.canDecodeURI(ioPath)).collect(Collectors.toList());
    }

    private int getMaxSignatureProbeLength(List<C> candidateCodecs) {
        return candidateCodecs.stream().map(codec -> codec.getSignatureProbeLength()).max(Integer::compare).orElse(0);
    }

    private SignatureStream getIOPathSignatureProbingStream(BundleResource bundleResource, int streamPrefixSize) {
        ValidationUtils.validateArg(bundleResource.getIOPath().isPresent(), "an IOPath resource is required");
        IOPath inputPath = bundleResource.getIOPath().get();
        if (!inputPath.hasFileSystemProvider()) {
            throw new IllegalArgumentException(String.format("The resource (%s) specifies a custom protocol (%s) which no registered codec claims, and for which no NIO file system provider is available", bundleResource, inputPath.getURI().getScheme()));
        }
        return bundleResource.getSignatureStream(streamPrefixSize);
    }

    private List<C> filterByVersion(List<C> candidateCodecs, HtsVersion htsVersion) {
        ValidationUtils.nonNull(htsVersion, "htsVersion");
        if (candidateCodecs.isEmpty()) {
            return candidateCodecs;
        }
        if (htsVersion.equals(HtsVersion.NEWEST_VERSION)) {
            HtsVersion newestVersion = candidateCodecs.stream().map(c -> c.getVersion()).reduce(((HtsCodec)candidateCodecs.get(0)).getVersion(), (a, b) -> a.compareTo((HtsVersion)b) > 0 ? a : b);
            return candidateCodecs.stream().filter(c -> c.getVersion().equals(newestVersion)).collect(Collectors.toList());
        }
        return candidateCodecs.stream().filter(c -> c.getVersion().equals(htsVersion)).collect(Collectors.toList());
    }

    private List<C> resolveForFormat(Optional<String> optFormatString) {
        List<C> candidateCodecs;
        List<C> list = candidateCodecs = optFormatString.isPresent() ? this.resolveForFormat(optFormatString.get()) : this.getCodecs();
        if (optFormatString.isPresent() && candidateCodecs.isEmpty()) {
            LOG.warn(String.format("The specified format string (%s) does not correspond to any registered codec for content type (%s)", optFormatString.get(), this.requiredContentType));
        }
        return candidateCodecs;
    }

    private List<C> getURIOwners(List<C> candidateCodecs, IOPath ioPath) {
        boolean isCustomURI;
        List uriHandlers = candidateCodecs.stream().filter(codec -> codec.ownsURI(ioPath)).collect(Collectors.toList());
        boolean bl = isCustomURI = !uriHandlers.isEmpty();
        if (isCustomURI) {
            uriHandlers.stream().forEach(codec -> {
                if (!codec.canDecodeURI(ioPath)) {
                    throw new HtsjdkPluginException(String.format("The %s codec returned true for ownsURI but false for canDecodeURI for path: %s", codec, ioPath.getURI()));
                }
            });
        }
        return uriHandlers;
    }

    private final BundleResource getPrimaryResource(Bundle bundle, boolean forEncoding) {
        BundleResource bundleResource = bundle.getPrimaryResource();
        String bundlePrimaryContentType = bundle.getPrimaryContentType();
        if (!this.requiredContentType.equals(bundlePrimaryContentType)) {
            throw new IllegalArgumentException(String.format("The primary content type (%s) for the resource does not match the requested content type (%s).", bundlePrimaryContentType, this.requiredContentType));
        }
        if (forEncoding && !bundleResource.hasInputType()) {
            throw new IllegalArgumentException(String.format("The %s resource found (%s) cannot be used as an input resource", this.requiredContentType, bundleResource));
        }
        if (!forEncoding && !bundleResource.hasOutputType()) {
            throw new IllegalArgumentException(String.format("The %s resource found (%s) cannot be used as an output resource", this.requiredContentType, bundleResource));
        }
        return bundleResource;
    }

    static <C extends HtsCodec<?, ?>> C getOneOrThrow(List<C> resolvedCodecs, Supplier<String> contextMessage) {
        if (resolvedCodecs.size() == 0) {
            throw new HtsjdkException(String.format("%s %s", NO_SUPPORTING_CODEC_ERROR, contextMessage.get()));
        }
        if (resolvedCodecs.size() > 1) {
            String multipleCodecsMessage = String.format("%s (%s)\n%s\nThis indicates an internal error in one or more of the codecs:", MULTIPLE_SUPPORTING_CODECS_ERROR, contextMessage.get(), resolvedCodecs.stream().map(c -> c.getDisplayName()).collect(Collectors.joining("\n")));
            throw new HtsjdkPluginException(multipleCodecsMessage);
        }
        return (C)((HtsCodec)resolvedCodecs.get(0));
    }
}

