/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.EmblFeatureTableParser;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GFFParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.load.ChromAliasParser;
import org.broad.igv.feature.genome.load.GenbankParser;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeDescriptor;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.gff.GFFFeatureSource;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;

public class DotGenomeLoader
extends GenomeLoader {
    private static Logger log = LogManager.getLogger(DotGenomeLoader.class);
    File archiveFile;

    public DotGenomeLoader(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    private static FeatureTrack createGeneTrack(Genome genome, BufferedReader reader, String geneFileName, String geneTrackName, String annotationURL) {
        FeatureDB.clearFeatures();
        FeatureTrack geneFeatureTrack = null;
        if (reader != null) {
            FeatureParser parser = geneFileName.endsWith(".embl") ? new EmblFeatureTableParser() : (GFFFeatureSource.isGFF(geneFileName) ? new GFFParser() : AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFileName), genome));
            if (parser == null) {
                MessageUtils.showMessage("ERROR: Unrecognized annotation file format: " + geneFileName + "<br>Annotations for genome: " + genome.getId() + " will not be loaded.");
            } else {
                List<Feature> genes = parser.loadFeatures(reader, genome);
                String name = geneTrackName;
                if (name == null) {
                    name = "Genes";
                }
                String id = genome.getId() + "_genes";
                geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(genes, genome));
                geneFeatureTrack.setMinimumHeight(5);
                geneFeatureTrack.setHeight(35);
                geneFeatureTrack.setTrackType(TrackType.GENE);
                geneFeatureTrack.setColor(Color.BLUE.darker());
                TrackProperties props = parser.getTrackProperties();
                if (props != null) {
                    geneFeatureTrack.setProperties(parser.getTrackProperties());
                }
                geneFeatureTrack.setFeatureInfoURL(annotationURL);
            }
        }
        return geneFeatureTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Genome loadGenome() throws IOException {
        BufferedReader reader;
        String sequencePath;
        GenomeConfig config = new GenomeConfig();
        GenomeDescriptor genomeDescriptor = GenomeDescriptor.parseGenomeArchiveFile(this.archiveFile);
        String id = genomeDescriptor.getId();
        String displayName = genomeDescriptor.getName();
        String string = sequencePath = localSequenceMap.containsKey(genomeDescriptor.getId()) ? DotGenomeLoader.loadSequenceMap().get(genomeDescriptor.getId()).getAbsolutePath() : genomeDescriptor.getSequencePath();
        if (sequencePath != null) {
            config.fastaURL = sequencePath;
            config.indexURL = sequencePath + ".fai";
            if (sequencePath.endsWith(".gz")) {
                config.gziIndexURL = sequencePath + "gzi";
            }
        }
        config.id = id;
        config.name = displayName;
        if (genomeDescriptor.hasCytobands()) {
            InputStream cytobandStream = null;
            try {
                cytobandStream = genomeDescriptor.getCytoBandStream();
                reader = new BufferedReader(new InputStreamReader(cytobandStream));
                config.cytobands = CytoBandFileParser.loadData(reader);
            }
            catch (IOException ex) {
                log.error("Error loading cytoband file", ex);
                throw new RuntimeException("Error loading cytoband file" + genomeDescriptor.cytoBandFileName);
            }
            finally {
                DotGenomeLoader.closeSilently(cytobandStream);
            }
        }
        InputStream aliasStream = null;
        try {
            aliasStream = genomeDescriptor.getChrAliasStream();
            if (aliasStream != null) {
                reader = new BufferedReader(new InputStreamReader(aliasStream));
                config.chromAliases = ChromAliasParser.loadChrAliases(reader);
            }
        }
        catch (IOException e) {
            log.error("Error loading chromosome alias table");
        }
        finally {
            DotGenomeLoader.closeSilently(aliasStream);
        }
        Genome newGenome = new Genome(config);
        String geneFileName = genomeDescriptor.getGeneFileName();
        InputStream geneStream = null;
        if (geneFileName != null) {
            try {
                geneStream = genomeDescriptor.getGeneStream();
                if (geneFileName.endsWith(".gbk")) {
                    GenbankParser genbankParser = new GenbankParser();
                    genbankParser.readFeatures(geneStream, false);
                    FeatureTrack geneFeatureTrack = DotGenomeLoader.createGeneTrack(newGenome, genbankParser.getFeatures());
                    newGenome.setGeneTrack(geneFeatureTrack);
                } else {
                    BufferedReader reader2 = new BufferedReader(new InputStreamReader(geneStream));
                    FeatureTrack geneFeatureTrack = DotGenomeLoader.createGeneTrack(newGenome, reader2, geneFileName, genomeDescriptor.getGeneTrackName(), genomeDescriptor.getUrl());
                    newGenome.setGeneTrack(geneFeatureTrack);
                }
            }
            finally {
                DotGenomeLoader.closeSilently(geneStream);
            }
        }
        genomeDescriptor.close();
        return newGenome;
    }
}

