/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.DataRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BisulfiteCounts;
import org.broad.igv.sam.SparseAlignmentCounts;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.sam.mods.BaseModficationFilter;
import org.broad.igv.sam.mods.BaseModificationCoverageRenderer;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.Range;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.ScalableTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoverageTrack
extends AbstractTrack
implements ScalableTrack {
    private static Logger log = LogManager.getLogger(CoverageTrack.class);
    public static final int TEN_MB = 10000000;
    static DecimalFormat locationFormatter = new DecimalFormat();
    char[] nucleotides = new char[]{'a', 'c', 'g', 't', 'n'};
    public static final boolean DEFAULT_AUTOSCALE = true;
    private Color _color = null;
    private float snpThreshold;
    private AlignmentTrack alignmentTrack;
    private AlignmentDataManager dataManager;
    private CoverageDataSource dataSource;
    private DataRenderer dataSourceRenderer;
    private IntervalRenderer intervalRenderer;
    private IGVPreferences prefs;
    private Genome genome;
    private boolean removed = false;
    IGV igv;
    ColorScale baseModificationColorScale;
    private boolean globalAutoScale = true;

    public CoverageTrack() {
    }

    public CoverageTrack(CoverageTrack track) {
        this(track.getResourceLocator(), track.getName(), track.alignmentTrack, track.genome);
        if (track.dataManager != null) {
            this.setDataManager(track.dataManager);
        }
        if (track.dataSource != null) {
            this.setDataSource(track.dataSource);
        }
        this.snpThreshold = track.snpThreshold;
        this.prefs = track.prefs;
        this.igv = IGV.hasInstance() ? IGV.getInstance() : null;
    }

    public CoverageTrack(ResourceLocator locator, String name, AlignmentTrack alignmentTrack, Genome genome) {
        super(locator, locator.getPath() + "_coverage", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.alignmentTrack = alignmentTrack;
        this.genome = genome;
        this.intervalRenderer = new IntervalRenderer();
        this.prefs = PreferencesManager.getPreferences();
        this.snpThreshold = this.prefs.getAsFloat("SAM.ALLELE_THRESHOLD");
        this.autoScale = true;
        this.igv = IGV.hasInstance() ? IGV.getInstance() : null;
    }

    @Override
    public Color getColor() {
        return this._color == null ? ColorUtilities.slightlyDarker(this.alignmentTrack.getColor()) : this._color;
    }

    @Override
    public void setColor(Color color) {
        this._color = color;
    }

    @Override
    public String getSample() {
        if (this.sampleId != null) {
            return this.sampleId;
        }
        return this.alignmentTrack == null ? null : this.alignmentTrack.getSample();
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public void setDataManager(AlignmentDataManager dataManager) {
        this.dataManager = dataManager;
        this.dataManager.subscribe(this);
    }

    public void setDataSource(CoverageDataSource dataSource) {
        this.dataSource = dataSource;
        this.dataSourceRenderer = new BarChartRenderer();
        this.setDataRange(new DataRange(0.0f, 0.0f, 1.5f * (float)dataSource.getDataMax()));
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        double extent = frame.getEnd() - frame.getOrigin();
        if (frame.getChrName().equals("All") || extent > this.dataManager.getVisibilityWindow()) {
            return true;
        }
        return this.dataManager.isLoaded(frame);
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        this.dataManager.load(referenceFrame, this.alignmentTrack.getRenderOptions(), this.alignmentTrack.getDisplayMode(), true);
    }

    public void setSnpThreshold(float snpThreshold) {
        this.snpThreshold = snpThreshold;
    }

    public float getSnpThreshold() {
        return this.snpThreshold;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.removed;
    }

    @Override
    public void unload() {
        super.unload();
        this.removed = true;
        if (this.dataManager != null) {
            this.dataManager.unsubscribe(this);
        }
        this.setVisible(false);
    }

    @Override
    public int getVisibilityWindow() {
        return (int)this.dataManager.getVisibilityWindow();
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        int viewWindowSize = context.getReferenceFrame().getCurrentRange().getLength();
        if (viewWindowSize > this.getVisibilityWindow() && this.dataSource == null) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            GraphicUtils.drawCenteredText("Zoom in to see coverage.", visibleRect, g);
            return;
        }
        this.drawData(context, rect);
        this.drawBorder(context, rect);
        if (this.dataSourceRenderer != null) {
            this.dataSourceRenderer.renderBorder(this, context, rect);
            this.dataSourceRenderer.renderAxis(this, context, rect);
        } else {
            DataRenderer.drawScale(this.getDataRange(), context, rect);
        }
    }

    public void drawData(RenderContext context, Rectangle rect) {
        List<LocusScore> scores;
        int viewWindowSize = context.getReferenceFrame().getCurrentRange().getLength();
        if ((double)viewWindowSize <= this.dataManager.getVisibilityWindow() && !context.getChr().equals("All")) {
            AlignmentInterval interval = null;
            if (this.dataManager != null) {
                interval = this.dataManager.getLoadedInterval(context.getReferenceFrame(), true);
            }
            if (interval != null) {
                this.intervalRenderer.paint(context, rect, interval.getCounts());
                return;
            }
        }
        if ((scores = this.getInViewScores(context.getReferenceFrame())) != null) {
            this.dataSourceRenderer.renderScores(this, scores, context, rect);
        }
    }

    private List<LocusScore> getInViewScores(ReferenceFrame frame) {
        List<LocusScore> inViewScores = null;
        if (this.dataSource != null) {
            int tmp;
            String chr = frame.getChrName();
            int start = (int)frame.getOrigin();
            int end = (int)frame.getEnd();
            int zoom = frame.getZoom();
            inViewScores = this.dataSource.getSummaryScoresForRange(chr, start, end, zoom);
            int startIdx = Math.max(0, FeatureUtils.getIndexBefore(start, inViewScores));
            int endIdx = inViewScores.size() - 1;
            for (int i = tmp = Math.max(0, FeatureUtils.getIndexBefore(end, inViewScores)); i < inViewScores.size(); ++i) {
                if (inViewScores.get(i).getStart() <= end) continue;
                endIdx = i - 1;
                break;
            }
            endIdx = Math.max(startIdx + 1, endIdx);
            if (inViewScores.size() > 1) {
                return startIdx == 0 && endIdx == inViewScores.size() - 1 ? inViewScores : inViewScores.subList(startIdx, endIdx);
            }
            return inViewScores;
        }
        return inViewScores;
    }

    @Override
    public Range getInViewRange(ReferenceFrame frame) {
        int viewWindowSize = frame.getCurrentRange().getLength();
        if (this.dataManager == null || (double)viewWindowSize > this.dataManager.getVisibilityWindow()) {
            List<LocusScore> scores = this.getInViewScores(frame);
            if (scores != null && scores.size() > 0) {
                float min;
                float max = min = scores.get(0).getScore();
                for (int i = 1; i < scores.size(); ++i) {
                    LocusScore score = scores.get(i);
                    float value = score.getScore();
                    min = Math.min(value, min);
                    max = Math.max(value, max);
                }
                return new Range(min, max);
            }
            return null;
        }
        AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
        if (interval == null) {
            return null;
        }
        int origin = (int)frame.getOrigin();
        int end = (int)frame.getEnd() + 1;
        int intervalMax = interval.getMaxCount(origin, end);
        return new Range(0.0f, Math.max(10, intervalMax));
    }

    private void drawBorder(RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
    }

    public void drawScale(RenderContext context, Rectangle rect) {
        DataRenderer.drawScale(this.getDataRange(), context, rect);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        float maxRange = PreferencesManager.getPreferences().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        StringBuffer buf = new StringBuffer();
        if (!chr.equals("All")) {
            String posString = chr + ":" + locationFormatter.format(Math.floor(position + 1.0));
            buf.append(posString + "<br>");
            buf.append("<hr>");
        }
        if (frame.getScale() < (double)minVisibleScale) {
            AlignmentCounts counts;
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            if (interval != null && interval.contains(chr, (int)position, (int)position) && (counts = interval.getCounts()) != null) {
                buf.append(counts.getValueStringAt((int)position));
                AlignmentTrack.ColorOption colorOption = this.alignmentTrack.getRenderOptions().getColorOption();
                if (colorOption.isBaseMod() && counts.getModifiedBaseCounts() != null) {
                    buf.append("<br>");
                    buf.append(counts.getModifiedBaseCounts().getValueString((int)position, colorOption));
                }
            }
        } else {
            buf.append(this.getPrecomputedValueString(chr, position, frame));
        }
        return buf.toString();
    }

    private String getPrecomputedValueString(String chr, double position, ReferenceFrame frame) {
        if (this.dataSource == null) {
            return "";
        }
        int zoom = Math.max(0, frame.getZoom());
        List<LocusScore> scores = this.dataSource.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        if (scores == null) {
            return "";
        }
        LocusScore score = FeatureUtils.getFeatureAt(position, 0, scores);
        return score == null ? "" : "Mean count: " + score.getScore();
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    public void rescale(ReferenceFrame iframe) {
        ArrayList<ReferenceFrame> frameList = new ArrayList<ReferenceFrame>();
        if (iframe != null) {
            frameList.add(iframe);
        }
        if (this.globalAutoScale) {
            frameList.addAll(FrameManager.getFrames());
        }
        if (this.autoScale && this.dataManager != null) {
            int max = 10;
            for (ReferenceFrame frame : frameList) {
                int end;
                AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
                if (interval == null) continue;
                int origin = (int)frame.getOrigin();
                int intervalMax = interval.getMaxCount(origin, end = (int)frame.getEnd() + 1);
                max = intervalMax > max ? intervalMax : max;
            }
            DataRange newRange = new DataRange(0.0f, (float)max);
            newRange.setType(this.getDataRange().getType());
            super.setDataRange(newRange);
        }
    }

    void drawAllelFreqBar(RenderContext context, int pX, int pBottom, int dX, int barHeight, int pos, double totalCount, AlignmentCounts alignmentCounts) {
        for (char nucleotide : this.nucleotides) {
            int count = alignmentCounts.getCount(pos, (byte)nucleotide);
            if (count <= 0) continue;
            double f = (double)count / totalCount;
            int alleleHeight = (int)(f * (double)barHeight);
            int baseY = pBottom - alleleHeight;
            Color c = SequenceRenderer.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            tGraphics.fillRect(pX, baseY, dX, alleleHeight);
            pBottom = baseY;
        }
    }

    void drawBarBisulfite(RenderContext context, int pX0, int pBottom, int dX, int barHeight, double totalCount, BisulfiteCounts.Count count) {
        int pX = pX0;
        if (dX < 3) {
            int expansion = dX;
            pX -= expansion;
            dX += 2 * expansion;
        }
        double nMethylated = count.methylatedCount;
        double unMethylated = count.unmethylatedCount;
        Color c = Color.red;
        Graphics2D tGraphics = context.getGraphic2DForColor(c);
        double f = nMethylated / totalCount;
        int height = (int)(f * (double)barHeight);
        int baseY = pBottom - height;
        if (height > 0) {
            tGraphics.fillRect(pX, baseY, dX, height);
        }
        pBottom = baseY;
        c = Color.blue;
        tGraphics = context.getGraphic2DForColor(c);
        f = unMethylated / totalCount;
        height = (int)(f * (double)barHeight);
        if (height > 0) {
            baseY = pBottom - height;
            tGraphics.fillRect(pX, baseY, dX, height);
        }
    }

    void drawStrandBar(RenderContext context, int pos, Rectangle rect, double maxCount, int pY, int pX, int dX, boolean isPositive, AlignmentCounts interval) {
        for (char nucleotide : this.nucleotides) {
            int baseY;
            Color c = SequenceRenderer.nucleotideColors.get(Character.valueOf(nucleotide));
            Graphics2D tGraphics = context.getGraphic2DForColor(c);
            int count = isPositive ? interval.getPosCount(pos, (byte)nucleotide) : interval.getNegCount(pos, (byte)nucleotide);
            int height = (int)Math.round((double)count * rect.getHeight() / maxCount);
            height = isPositive ? Math.min(pY - rect.y, height) : Math.min(rect.y + rect.height - pY, height);
            int n = baseY = isPositive ? pY - height : pY;
            if (height > 0) {
                tGraphics.fillRect(pX, baseY, dX, height);
            }
            pY = isPositive ? baseY : baseY + height;
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        IGVPopupMenu popupMenu = TrackMenuUtils.getPopupMenu(tmp, this.getName(), te);
        popupMenu.addSeparator();
        this.addSnpTresholdItem(popupMenu);
        popupMenu.addSeparator();
        this.addLoadCoverageDataItem(popupMenu);
        popupMenu.addSeparator();
        this.addCopyDetailsItem(popupMenu, te);
        if (this.alignmentTrack != null) {
            popupMenu.addSeparator();
            this.addShowItems(popupMenu);
        }
        return popupMenu;
    }

    private void addCopyDetailsItem(IGVPopupMenu popupMenu, TrackClickEvent te) {
        JMenuItem copyDetails = new JMenuItem("Copy Details to Clipboard");
        copyDetails.setEnabled(false);
        if (te.getFrame() != null) {
            final String details = this.getValueStringAt(te.getFrame().getChrName(), te.getChromosomePosition(), te.getMouseEvent().getX(), te.getMouseEvent().getY(), te.getFrame());
            copyDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (details != null) {
                        String deets = details.replace("<br>", System.getProperty("line.separator"));
                        StringUtils.copyTextToClipboard(deets);
                    }
                }
            });
            copyDetails.setEnabled(details != null);
        }
        popupMenu.add(copyDetails);
    }

    public static JMenuItem addDataRangeItem(final Frame parentFrame, JPopupMenu menu, final Collection<? extends Track> selectedTracks) {
        JMenuItem maxValItem = new JMenuItem("Set Data Range");
        maxValItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (selectedTracks.size() > 0) {
                    DataRange prevAxisDefinition = ((Track)selectedTracks.iterator().next()).getDataRange();
                    DataRangeDialog dlg = new DataRangeDialog(parentFrame, prevAxisDefinition);
                    dlg.setHideMid(true);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        float min = Math.min(dlg.getMin(), dlg.getMax());
                        float max = Math.max(dlg.getMin(), dlg.getMax());
                        float mid = dlg.getBase();
                        if (mid < min) {
                            mid = min;
                        } else if (mid > max) {
                            mid = max;
                        }
                        DataRange dataRange = new DataRange(min, mid, max);
                        dataRange.setType(dlg.getDataRangeType());
                        for (Track track : selectedTracks) {
                            track.setDataRange(dataRange);
                            track.setAutoScale(false);
                        }
                        parentFrame.repaint();
                    }
                }
            }
        });
        if (menu != null) {
            menu.add(maxValItem);
        }
        return maxValItem;
    }

    public JMenuItem addSnpTresholdItem(JPopupMenu menu) {
        JMenuItem maxValItem = new JMenuItem("Set allele frequency threshold...");
        maxValItem.addActionListener(e -> {
            String value = JOptionPane.showInputDialog("Allele frequency threshold: ", (Object)Float.valueOf(this.snpThreshold));
            if (value == null) {
                return;
            }
            try {
                float tmp;
                this.snpThreshold = tmp = Float.parseFloat(value);
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        menu.add(maxValItem);
        return maxValItem;
    }

    public void addShowItems(JPopupMenu menu) {
        SpliceJunctionTrack spliceJunctionTrack = this.alignmentTrack.getSpliceJunctionTrack();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Coverage Track");
        item.setSelected(true);
        item.addActionListener(e -> {
            this.setVisible(item.isSelected());
            IGV.getInstance().repaint(Arrays.asList(this));
        });
        if (!(this.alignmentTrack.isVisible() || spliceJunctionTrack != null && spliceJunctionTrack.isVisible())) {
            item.setEnabled(false);
        }
        menu.add(item);
        if (spliceJunctionTrack != null) {
            JCheckBoxMenuItem junctionItem = new JCheckBoxMenuItem("Show Splice Junction Track");
            junctionItem.setSelected(spliceJunctionTrack.isVisible());
            junctionItem.setEnabled(!spliceJunctionTrack.isRemoved());
            junctionItem.addActionListener(e -> {
                spliceJunctionTrack.setVisible(junctionItem.isSelected());
                IGV.getInstance().repaint(Arrays.asList(spliceJunctionTrack));
            });
            menu.add(junctionItem);
        }
        if (this.alignmentTrack != null) {
            JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
            alignmentItem.setSelected(this.alignmentTrack.isVisible());
            alignmentItem.setEnabled(!this.alignmentTrack.isRemoved());
            alignmentItem.addActionListener(e -> {
                this.alignmentTrack.setVisible(alignmentItem.isSelected());
                IGV.getInstance().repaint(Arrays.asList(this.alignmentTrack));
            });
            menu.add(alignmentItem);
        }
    }

    public void addLoadCoverageDataItem(JPopupMenu menu) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Load pre-computed coverage data...");
        item.addActionListener(e -> {
            IGVPreferences prefs = PreferencesManager.getPreferences();
            File initDirectory = prefs.getLastTrackDirectory();
            File file = FileDialogUtils.chooseFile("Select coverage file", initDirectory, 0);
            if (file != null) {
                prefs.setLastTrackDirectory(file.getParentFile());
                String path = file.getAbsolutePath();
                if (path.endsWith(".tdf") || path.endsWith(".tdf")) {
                    TDFReader reader = TDFReader.getReader(file.getAbsolutePath());
                    TDFDataSource ds = new TDFDataSource(reader, 0, this.getName() + " coverage", this.genome);
                    this.setDataSource(ds);
                    this.repaint();
                } else if (this.igv != null) {
                    MessageUtils.showMessage("Coverage data must be in .tdf format");
                }
            }
        });
        item.setEnabled(this.dataSource == null);
        menu.add(item);
    }

    public void setGlobalAutoScale(boolean globalAutoScale) {
        this.globalAutoScale = globalAutoScale;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("snpThreshold", String.valueOf(this.snpThreshold));
        if (this._color != null) {
            element.setAttribute("_color", ColorUtilities.colorToString(this._color));
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("snpThreshold")) {
            this.snpThreshold = Float.parseFloat(element.getAttribute("snpThreshold"));
        }
        if (element.hasAttribute("_color")) {
            this._color = ColorUtilities.stringToColor(element.getAttribute("_color"));
        }
    }

    class IntervalRenderer {
        IntervalRenderer() {
        }

        private void paint(RenderContext context, Rectangle rect, AlignmentCounts alignmentCounts) {
            DataRange range;
            Color color = CoverageTrack.this.getColor();
            Graphics2D graphics = context.getGraphic2DForColor(color);
            AlignmentTrack.ColorOption colorOption = CoverageTrack.this.alignmentTrack.getRenderOptions().getColorOption();
            boolean bisulfiteMode = colorOption == AlignmentTrack.ColorOption.BISULFITE;
            int intervalEnd = alignmentCounts.getEnd();
            int intervalStart = alignmentCounts.getStart();
            BisulfiteCounts bisulfiteCounts = null;
            byte[] refBases = null;
            if (intervalEnd - intervalStart < 10000000 && alignmentCounts.hasBaseCounts()) {
                refBases = CoverageTrack.this.genome.getSequence(context.getChr(), intervalStart, intervalEnd);
                bisulfiteCounts = alignmentCounts.getBisulfiteCounts();
            }
            double maxRange = (range = CoverageTrack.this.getDataRange()).isLog() ? Math.log10(range.getMaximum() + 1.0f) : (double)range.getMaximum();
            double origin = context.getOrigin();
            double scale = context.getScale();
            int start = alignmentCounts.getStart();
            int step = alignmentCounts.getBucketSize();
            int nPoints = alignmentCounts.getNumberOfPoints();
            boolean isSparse = alignmentCounts instanceof SparseAlignmentCounts;
            for (int idx = 0; idx < nPoints; ++idx) {
                int pX;
                int pos = isSparse ? ((SparseAlignmentCounts)alignmentCounts).getPosition(idx) : start + idx * step;
                double endX = (double)rect.x + ((double)(pos + step) - origin) / scale;
                int dX = (int)(endX - (double)(pX = (int)((double)rect.x + ((double)pos - origin) / scale)) < 1.0 ? 1.0 : (endX - (double)pX > 3.0 ? endX - (double)pX - 1.0 : endX - (double)pX));
                if (pX > rect.x + rect.width) break;
                if (endX < (double)rect.x) continue;
                int totalCount = alignmentCounts.getTotalCount(pos);
                double tmp = range.isLog() ? Math.log10(totalCount + 1) / maxRange : (double)totalCount / maxRange;
                int barHeight = (int)Math.min(tmp * (double)rect.height, (double)(rect.height - 1));
                if (barHeight <= 0) continue;
                int bottomY = rect.y + rect.height;
                int topY = bottomY - barHeight;
                graphics.fillRect(pX, topY, dX, barHeight);
            }
            Set<String> simplexModifications = CoverageTrack.this.dataManager.getSimplexBaseModifications();
            for (int idx = 0; idx < nPoints; ++idx) {
                byte ref;
                int refIdx;
                int pX;
                int pos = isSparse ? ((SparseAlignmentCounts)alignmentCounts).getPosition(idx) : start + idx * step;
                double endX = (double)rect.x + ((double)(pos + step) - origin) / scale;
                int dX = (int)(endX - (double)(pX = (int)((double)rect.x + ((double)pos - origin) / scale)) < 1.0 ? 1.0 : (endX - (double)pX > 3.0 ? endX - (double)pX - 1.0 : endX - (double)pX));
                if (pX > rect.x + rect.width) break;
                if (endX < (double)rect.x) continue;
                int totalCount = alignmentCounts.getTotalCount(pos);
                double tmp = range.isLog() ? Math.log10(totalCount + 1) / maxRange : (double)totalCount / maxRange;
                int barHeight = (int)Math.min(tmp * (double)rect.height, (double)(rect.height - 1));
                if (barHeight <= 0) continue;
                int bottomY = rect.y + rect.height;
                if (bisulfiteMode) {
                    BisulfiteCounts.Count bc;
                    BisulfiteCounts.Count count = bc = bisulfiteCounts != null ? bisulfiteCounts.getCount(pos) : null;
                    if (bc == null || bc.methylatedCount + bc.unmethylatedCount <= 0) continue;
                    CoverageTrack.this.drawBarBisulfite(context, pX, bottomY, dX, barHeight, totalCount, bc);
                    continue;
                }
                if (colorOption.isBaseMod()) {
                    BaseModficationFilter basemodFilter = CoverageTrack.this.alignmentTrack != null ? CoverageTrack.this.alignmentTrack.getRenderOptions().getBasemodFilter() : null;
                    float threshold = CoverageTrack.this.alignmentTrack.getRenderOptions().getBasemodThreshold();
                    BaseModificationCoverageRenderer.drawModifications(context, pX, bottomY, dX, barHeight, pos, alignmentCounts, colorOption, basemodFilter, threshold, simplexModifications);
                    continue;
                }
                if (refBases == null || (refIdx = pos - intervalStart) < 0 || refIdx >= refBases.length || !alignmentCounts.isConsensusMismatch(pos, ref = refBases[refIdx], context.getChr(), CoverageTrack.this.snpThreshold)) continue;
                CoverageTrack.this.drawAllelFreqBar(context, pX, bottomY, dX, barHeight, pos, totalCount, alignmentCounts);
            }
        }
    }
}

