/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.Log;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleJSON {
    public static final String BUNDLE_EXTENSION = ".json";
    private static final Log LOG = Log.getInstance(BundleJSON.class);
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schemaName";
    public static final String JSON_PROPERTY_SCHEMA_VERSION = "schemaVersion";
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    public static final String JSON_PROPERTY_PATH = "path";
    public static final String JSON_PROPERTY_FORMAT = "format";
    public static final String JSON_SCHEMA_NAME = "htsbundle";
    public static final String JSON_SCHEMA_VERSION = "0.1.0";
    private static final Set<String> TOP_LEVEL_PROPERTIES = Set.of("schema", "primary");

    public static String toJSON(Bundle bundle) {
        ValidationUtils.validateArg(!bundle.getPrimaryContentType().equals(JSON_PROPERTY_PRIMARY), "Primary content type cannot be named 'primary'");
        JSONObject schemaMap = new JSONObject().put(JSON_PROPERTY_SCHEMA_NAME, (Object)JSON_SCHEMA_NAME).put(JSON_PROPERTY_SCHEMA_VERSION, (Object)JSON_SCHEMA_VERSION);
        JSONObject outerJSON = new JSONObject().put(JSON_PROPERTY_SCHEMA, (Object)schemaMap).put(JSON_PROPERTY_PRIMARY, (Object)bundle.getPrimaryContentType());
        bundle.forEach(bundleResource -> {
            Optional<IOPath> resourcePath = bundleResource.getIOPath();
            if (!resourcePath.isPresent()) {
                throw new IllegalArgumentException("Bundle resource requires a valid path to be serialized");
            }
            JSONObject resourceJSON = new JSONObject().put(JSON_PROPERTY_PATH, (Object)resourcePath.get().getURIString());
            if (bundleResource.getFileFormat().isPresent()) {
                resourceJSON.put(JSON_PROPERTY_FORMAT, (Object)bundleResource.getFileFormat().get());
            }
            outerJSON.put(bundleResource.getContentType(), (Object)resourceJSON);
        });
        return outerJSON.toString(1);
    }

    public static String toJSON(List<Bundle> bundles) {
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("A bundle list must contain at least one bundle");
        }
        return bundles.stream().map(BundleJSON::toJSON).collect(Collectors.joining(",\n", "[", "]"));
    }

    public static Bundle toBundle(String jsonString) {
        return BundleJSON.toBundle(ValidationUtils.nonEmpty(jsonString, "resource list"), HtsPath::new);
    }

    public static <T extends IOPath> Bundle toBundle(String jsonString, Function<String, T> ioPathConstructor) {
        ValidationUtils.nonEmpty(jsonString, "JSON string");
        ValidationUtils.nonNull(ioPathConstructor, "IOPath-derived class constructor");
        try {
            return BundleJSON.toBundle(new JSONObject(jsonString), ioPathConstructor);
        }
        catch (UnsupportedOperationException | JSONException e) {
            try {
                List<Bundle> bundles = BundleJSON.toBundleList(jsonString, ioPathConstructor);
                if (bundles.size() > 1) {
                    throw new IllegalArgumentException(String.format("A JSON string with more than one bundle was provided but only a single bundle is allowed in this context (%s)", e.getMessage()));
                }
                return bundles.get(0);
            }
            catch (UnsupportedOperationException | JSONException e2) {
                throw new IllegalArgumentException(String.format("The JSON can be interpreted neither as an individual bundle (%s) nor as a bundle collection (%s)", e.getMessage(), e2.getMessage()), e);
            }
        }
    }

    public static <T extends IOPath> List<Bundle> toBundleList(String jsonString, Function<String, T> ioPathConstructor) {
        ValidationUtils.nonEmpty(jsonString, "json bundle string");
        ValidationUtils.nonNull(ioPathConstructor, "IOPath-derived class constructor");
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try {
            JSONArray jsonArray = new JSONArray(jsonString);
            jsonArray.forEach(element -> {
                if (!(element instanceof JSONObject)) {
                    throw new IllegalArgumentException(String.format("Bundle collections may contain only Bundle objects, found %s", element.toString()));
                }
                JSONObject jsonObject = (JSONObject)element;
                bundles.add(BundleJSON.toBundle(jsonObject, ioPathConstructor));
            });
        }
        catch (UnsupportedOperationException | JSONException e) {
            try {
                bundles.add(BundleJSON.toBundle(new JSONObject(jsonString), ioPathConstructor));
            }
            catch (UnsupportedOperationException | JSONException e2) {
                throw new IllegalArgumentException(String.format("JSON can be interpreted neither as an individual bundle (%s) nor as a bundle collection (%s)", e2.getMessage(), e.getMessage()), e);
            }
        }
        if (bundles.isEmpty()) {
            throw new IllegalArgumentException("JSON bundle collection must contain at least one bundle");
        }
        return bundles;
    }

    public static List<Bundle> toBundleList(String jsonString) {
        return BundleJSON.toBundleList(jsonString, HtsPath::new);
    }

    private static <T extends IOPath> Bundle toBundle(JSONObject jsonObject, Function<String, T> ioPathConstructor) {
        try {
            JSONObject schemaMap = jsonObject.getJSONObject(JSON_PROPERTY_SCHEMA);
            if (schemaMap == null) {
                throw new IllegalArgumentException("JSON bundle is missing the required schema property");
            }
            String schemaName = BundleJSON.getRequiredPropertyAsString(schemaMap, JSON_PROPERTY_SCHEMA_NAME);
            if (!schemaName.equals(JSON_SCHEMA_NAME)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema name %s but found %s", JSON_SCHEMA_NAME, schemaName));
            }
            String schemaVersion = BundleJSON.getRequiredPropertyAsString(schemaMap, JSON_PROPERTY_SCHEMA_VERSION);
            if (!schemaVersion.equals(JSON_SCHEMA_VERSION)) {
                throw new IllegalArgumentException(String.format("Expected bundle schema version %s but found %s", JSON_SCHEMA_VERSION, schemaVersion));
            }
            String primaryContentType = BundleJSON.getRequiredPropertyAsString(jsonObject, JSON_PROPERTY_PRIMARY);
            Collection<BundleResource> bundleResources = BundleJSON.toBundleResources(jsonObject, ioPathConstructor);
            return new Bundle(primaryContentType, bundleResources);
        }
        catch (UnsupportedOperationException | JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T extends IOPath> IOPathResource toBundleResource(String contentType, JSONObject jsonObject, Function<String, T> ioPathConstructor) {
        String format = jsonObject.optString(JSON_PROPERTY_FORMAT, null);
        return new IOPathResource((IOPath)ioPathConstructor.apply(BundleJSON.getRequiredPropertyAsString(jsonObject, JSON_PROPERTY_PATH)), contentType, format);
    }

    private static <T extends IOPath> Collection<BundleResource> toBundleResources(JSONObject jsonResources, Function<String, T> ioPathConstructor) {
        ArrayList<BundleResource> bundleResources = new ArrayList<BundleResource>();
        jsonResources.keySet().forEach(key -> {
            if (!TOP_LEVEL_PROPERTIES.contains(key)) {
                Object patt11693$temp = jsonResources.get(key);
                if (patt11693$temp instanceof JSONObject) {
                    JSONObject resourceObject = (JSONObject)patt11693$temp;
                    bundleResources.add(BundleJSON.toBundleResource(key, resourceObject, ioPathConstructor));
                } else {
                    throw new IllegalArgumentException(String.format("Bundle resources may contain only BundleResource objects, found %s", key));
                }
            }
        });
        return bundleResources;
    }

    private static String getRequiredPropertyAsString(JSONObject jsonDocument, String propertyName) {
        String propertyValue = jsonDocument.optString(propertyName, null);
        if (propertyValue == null) {
            throw new IllegalArgumentException(String.format("JSON bundle is missing the required property %s (%s)", propertyName, jsonDocument));
        }
        return propertyValue;
    }
}

