/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleBuilder;
import htsjdk.beta.io.bundle.BundleResourceType;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.beta.plugin.hapref.HaploidReferenceCodec;
import htsjdk.beta.plugin.hapref.HaploidReferenceDecoder;
import htsjdk.beta.plugin.hapref.HaploidReferenceDecoderOptions;
import htsjdk.beta.plugin.registry.HtsCodecResolver;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;

public class HaploidReferenceResolver
extends HtsCodecResolver<HaploidReferenceCodec> {
    public HaploidReferenceResolver() {
        super(BundleResourceType.HAPLOID_REFERENCE);
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(IOPath inputPath) {
        ValidationUtils.nonNull(inputPath, "inputPath");
        return this.getHaploidReferenceDecoder(inputPath, new HaploidReferenceDecoderOptions());
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(IOPath inputPath, HaploidReferenceDecoderOptions HaploidReferenceDecoderOptions2) {
        ValidationUtils.nonNull(inputPath, "Input path");
        ValidationUtils.nonNull(HaploidReferenceDecoderOptions2, "Decoder options");
        Bundle referenceBundle = new BundleBuilder().addPrimary(new IOPathResource(inputPath, BundleResourceType.HAPLOID_REFERENCE)).build();
        return this.getHaploidReferenceDecoder(referenceBundle, HaploidReferenceDecoderOptions2);
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(Bundle inputBundle) {
        ValidationUtils.nonNull(inputBundle, "inputPath");
        return this.getHaploidReferenceDecoder(inputBundle, new HaploidReferenceDecoderOptions());
    }

    public HaploidReferenceDecoder getHaploidReferenceDecoder(Bundle inputBundle, HaploidReferenceDecoderOptions HaploidReferenceDecoderOptions2) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        ValidationUtils.nonNull(HaploidReferenceDecoderOptions2, "Decoder options");
        return (HaploidReferenceDecoder)((HaploidReferenceCodec)this.resolveForDecoding(inputBundle)).getDecoder(inputBundle, HaploidReferenceDecoderOptions2);
    }
}

