/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.DirectoryManager;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.load.ChromAliasParser;
import org.broad.igv.feature.genome.load.GenomeDescriptor;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.JsonGenomeLoader;
import org.broad.igv.jbrowse.CircularViewUtilities;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.download.Downloader;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;

public class GenomeManager {
    private static Logger log = LogManager.getLogger(GenomeManager.class);
    private static GenomeManager theInstance;
    private static GenomeListManager genomeListManager;
    private Genome currentGenome;

    public static synchronized GenomeManager getInstance() {
        if (theInstance == null) {
            theInstance = new GenomeManager();
        }
        return theInstance;
    }

    private GenomeManager() {
        genomeListManager = GenomeListManager.getInstance();
        GenomeLoader.localSequenceMap = GenomeLoader.loadSequenceMap();
    }

    public static File getGenomeFile(String genomePath) throws MalformedURLException, UnsupportedEncodingException {
        File archiveFile;
        if (HttpUtils.isRemoteURL(genomePath.toLowerCase())) {
            URL genomeArchiveURL = HttpUtils.createURL(genomePath);
            String tmp = URLDecoder.decode(genomeArchiveURL.getFile(), "UTF-8");
            String cachedFilename = Utilities.getFileNameFromURL(tmp);
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                DirectoryManager.getGenomeCacheDirectory().mkdir();
            }
            archiveFile = new File(DirectoryManager.getGenomeCacheDirectory(), cachedFilename);
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            Downloader.download(genomeArchiveURL, archiveFile, parent);
        } else {
            archiveFile = new File(genomePath);
        }
        return archiveFile;
    }

    public void setCurrentGenome(Genome genome) {
        if (genome != null) {
            PreferencesManager.getPreferences().setLastGenome(genome.getId());
        }
        this.currentGenome = genome;
        if (genome != null && IGV.hasInstance()) {
            IGV.getInstance().getSession().clearHistory();
            FrameManager.getDefaultFrame().setChromosomeName(genome.getHomeChromosome(), true);
            IGVEventBus.getInstance().post(new GenomeChangeEvent(genome));
        }
    }

    public void loadGenomeById(String genomeId) throws IOException {
        Genome currentGenome = this.getCurrentGenome();
        if (currentGenome != null && genomeId.equals(currentGenome.getId())) {
            return;
        }
        String genomePath = null;
        if (ParsingUtils.fileExists(genomeId)) {
            genomePath = genomeId;
        } else {
            GenomeListItem item = genomeListManager.getGenomeListItem(genomeId);
            if (item == null) {
                MessageUtils.showMessage("Could not locate genome with ID: " + genomeId);
                return;
            }
            genomePath = item.getPath();
        }
        this.loadGenome(genomePath);
    }

    public Genome loadGenome(String genomePath) throws IOException {
        Genome genome;
        WaitCursorManager.CursorToken cursorToken = null;
        try {
            log.info("Loading genome: " + genomePath);
            if (IGV.hasInstance()) {
                IGV.getInstance().setStatusBarMessage("<html><font color=blue>Loading genome</font></html>");
                cursorToken = WaitCursorManager.showWaitCursor();
            }
            FeatureDB.clearFeatures();
            Genome newGenome = GenomeLoader.getLoader(genomePath).loadGenome();
            try {
                String aliasPath = new File(DirectoryManager.getGenomeCacheDirectory(), newGenome.getId() + "_alias.tab").getAbsolutePath();
                if (!new File(aliasPath).exists()) {
                    aliasPath = new File(DirectoryManager.getGenomeCacheDirectory(), newGenome.getId() + "_alias.tab.txt").getAbsolutePath();
                }
                if (new File(aliasPath).exists()) {
                    newGenome.addChrAliases(ChromAliasParser.loadChrAliases(aliasPath));
                }
            }
            catch (Exception e) {
                log.error("Failed to load user defined alias", e);
            }
            if (IGV.hasInstance()) {
                IGV.getInstance().resetSession(null);
            }
            GenomeListItem genomeListItem = new GenomeListItem(newGenome.getDisplayName(), genomePath, newGenome.getId());
            Set<String> serverGenomeIDs = genomeListManager.getServerGenomeIDs();
            boolean userDefined = !serverGenomeIDs.contains(newGenome.getId());
            genomeListManager.addGenomeItem(genomeListItem, userDefined);
            this.setCurrentGenome(newGenome);
            if (IGV.hasInstance()) {
                IGV.getInstance().goToLocus(newGenome.getHomeChromosome());
                this.loadGenomeAnnotations(newGenome);
                IGV.getInstance().resetFrames();
            }
            if (PreferencesManager.getPreferences().getAsBoolean("CIRC_VIEW_ENABLED") && CircularViewUtilities.ping()) {
                CircularViewUtilities.changeGenome(newGenome);
            }
            genome = this.currentGenome;
        }
        catch (SocketException e) {
            try {
                throw new RuntimeException("Server connection error", e);
            }
            catch (Throwable throwable) {
                if (IGV.hasInstance()) {
                    IGV.getInstance().setStatusBarMessage("");
                    WaitCursorManager.removeWaitCursor(cursorToken);
                }
                throw throwable;
            }
        }
        if (IGV.hasInstance()) {
            IGV.getInstance().setStatusBarMessage("");
            WaitCursorManager.removeWaitCursor(cursorToken);
        }
        return genome;
    }

    public void loadGenomeAnnotations(Genome genome) {
        this.restoreGenomeTracks(genome);
        IGV.getInstance().repaint();
    }

    public void restoreGenomeTracks(Genome genome) {
        IGV.getInstance().setSequenceTrack();
        FeatureTrack geneFeatureTrack = genome.getGeneTrack();
        if (geneFeatureTrack != null) {
            PanelName panelName = PreferencesManager.getPreferences().getAsBoolean("IGV.single.track.pane") ? PanelName.DATA_PANEL : PanelName.FEATURE_PANEL;
            geneFeatureTrack.setAttributeValue("NAME", geneFeatureTrack.getName());
            geneFeatureTrack.setAttributeValue("DATA FILE", "");
            geneFeatureTrack.setAttributeValue("DATA TYPE", geneFeatureTrack.getTrackType().toString());
            IGV.getInstance().addTracks(Arrays.asList(geneFeatureTrack), panelName);
        }
        List<ResourceLocator> resources = genome.getAnnotationResources();
        ArrayList<Track> annotationTracks = new ArrayList<Track>();
        if (resources != null) {
            for (ResourceLocator locator : resources) {
                try {
                    List<Track> tracks = IGV.getInstance().load(locator);
                    annotationTracks.addAll(tracks);
                }
                catch (DataLoadException e) {
                    log.error("Error loading genome annotations", e);
                }
            }
        }
        if (annotationTracks.size() > 0) {
            IGV.getInstance().addTracks(annotationTracks);
            for (Track track : annotationTracks) {
                ResourceLocator locator = track.getResourceLocator();
                String fn = "";
                if (locator != null) {
                    fn = locator.getPath();
                    int lastSlashIdx = fn.lastIndexOf("/");
                    if (lastSlashIdx < 0) {
                        lastSlashIdx = fn.lastIndexOf("\\");
                    }
                    if (lastSlashIdx > 0) {
                        fn = fn.substring(lastSlashIdx + 1);
                    }
                }
                track.setAttributeValue("NAME", track.getName());
                track.setAttributeValue("DATA FILE", fn);
                track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
            }
        }
        IGV.getInstance().revalidateTrackPanels();
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = DirectoryManager.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public boolean downloadGenome(GenomeListItem item, boolean downloadSequence) {
        boolean success;
        try {
            File genomeFile = GenomeManager.getGenomeFile(item.getPath());
            if (downloadSequence) {
                File localFile;
                String fastaPath = null;
                if (item.getPath().endsWith(".genome")) {
                    GenomeDescriptor genomeDescriptor = GenomeDescriptor.parseGenomeArchiveFile(genomeFile);
                    fastaPath = genomeDescriptor.getSequencePath();
                } else if (item.getPath().endsWith(".json")) {
                    JsonGenomeLoader.GenomeDescriptor desc = new JsonGenomeLoader(item.getPath()).loadDescriptor();
                    fastaPath = desc.getFastaURL();
                }
                if (fastaPath != null && FileUtils.isRemote(fastaPath) && (localFile = this.downloadFasta(fastaPath)) != null) {
                    GenomeManager.addLocalFasta(item.getId(), localFile);
                }
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
            MessageUtils.showErrorMessage("Error downloading genome", e);
            log.error("Error downloading genome " + item.getDisplayableName());
        }
        if (success) {
            genomeListManager.addGenomeItem(item, false);
            IGVEventBus.getInstance().post(new GenomeResetEvent());
        }
        return success;
    }

    File downloadFasta(String fastaPath) throws IOException {
        File defaultDir = DirectoryManager.getFastaCacheDirectory();
        File targetDir = defaultDir;
        if (targetDir == null) {
            targetDir = defaultDir;
        }
        String filename = Utilities.getFileNameFromURL(fastaPath);
        File localFile = new File(targetDir, filename);
        boolean downloaded = Downloader.download(HttpUtils.createURL(fastaPath), localFile, IGV.getInstance().getMainFrame());
        if (downloaded) {
            URL indexUrl = HttpUtils.createURL(fastaPath + ".fai");
            File localIndexFile = new File(targetDir, filename + ".fai");
            downloaded = Downloader.download(indexUrl, localIndexFile, IGV.getInstance().getMainFrame());
        }
        if (downloaded && fastaPath.endsWith(".gz")) {
            URL gziUrl = HttpUtils.createURL(fastaPath + ".gzi");
            File localGziPath = new File(targetDir, filename + ".gzi");
            downloaded = Downloader.download(gziUrl, localGziPath, IGV.getInstance().getMainFrame());
        }
        return downloaded ? localFile : null;
    }

    public static File getLocalFasta(String id) {
        return GenomeLoader.localSequenceMap.get(id);
    }

    public static void removeLocalFasta(String id) {
        GenomeLoader.localSequenceMap.remove(id);
        GenomeManager.updateSequenceMapFile();
    }

    private static void addLocalFasta(String id, File localFile) {
        GenomeLoader.localSequenceMap.put(id, localFile);
        GenomeManager.updateSequenceMapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSequenceMapFile() {
        try (PrintWriter pw = null;){
            File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), "sequenceMap.txt");
            pw = new PrintWriter(new BufferedWriter(new FileWriter(sequenceFile)));
            for (Map.Entry<String, File> entry : GenomeLoader.localSequenceMap.entrySet()) {
                pw.println(entry.getKey() + "\t" + entry.getValue());
            }
        }
    }

    public void refreshHostedGenome(String genomeId) {
        Map<String, GenomeListItem> itemMap = GenomeListManager.getInstance().getServerGenomeMap();
        if (itemMap.containsKey(genomeId)) {
            this.downloadGenome(itemMap.get(genomeId), false);
        }
    }
}

