/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.CytobandSource;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ucsc.bb.BBFeatureSource;
import org.broad.igv.ucsc.bb.BBFile;

public class CytobandSourceBB
implements CytobandSource {
    private BBFeatureSource featureSource;

    public CytobandSourceBB(String path, Genome genome) throws IOException {
        BBFile bbfile = new BBFile(path, genome);
        this.featureSource = new BBFeatureSource(bbfile, genome);
    }

    @Override
    public List<Cytoband> getCytobands(String chr) throws IOException {
        ArrayList<Cytoband> cytobands = new ArrayList<Cytoband>();
        Iterator<BasicFeature> features = this.featureSource.getFeatures(chr, 0, Integer.MAX_VALUE);
        while (features.hasNext()) {
            BasicFeature f = features.next();
            cytobands.add(new Cytoband(f.getChr(), f.getStart(), f.getEnd(), f.getName(), f.getAttribute("gieStain")));
        }
        return cytobands;
    }

    @Override
    public String[] getChromosomeNames() {
        return this.featureSource.getChromosomeNames();
    }
}

