/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.broad.igv.Globals;
import org.broad.igv.bedpe.InteractionTrack;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.basepair.BasePairTrack;
import org.broad.igv.feature.dsi.DSITrack;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.sprite.ClusterTrack;
import org.broad.igv.lists.GeneList;
import org.broad.igv.lists.GeneListManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.maf.MultipleAlignmentTrack;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.EWigTrack;
import org.broad.igv.sam.SpliceJunctionTrack;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionElement;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.BlatTrack;
import org.broad.igv.track.CNFreqTrack;
import org.broad.igv.track.CombinedDataTrack;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.track.MergedTracks;
import org.broad.igv.track.MotifTrack;
import org.broad.igv.track.MutationTrack;
import org.broad.igv.track.SelectableFeatureTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.FilterElement;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.collections.CollUtils;
import org.broad.igv.variant.VariantTrack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IGVSessionReader
implements SessionReader {
    private static Logger log = LogManager.getLogger(IGVSessionReader.class);
    private static String INPUT_FILE_KEY = "INPUT_FILE_KEY";
    private static Map<String, String> attributeSynonymMap = new HashMap<String, String>();
    private static WeakReference<IGVSessionReader> currentReader;
    private IGV igv;
    private int version;
    private String genomePath;
    private Collection<ResourceLocator> dataFiles;
    private Collection<ResourceLocator> missingDataFiles;
    private boolean panelElementPresent = false;
    private TrackFilter filter;
    private final List<Pair<CombinedDataTrack, Element>> combinedDataSourceTracks = new ArrayList<Pair<CombinedDataTrack, Element>>();
    private Set<Track> allocatedToPanel;
    private final Map<String, List<Track>> allTracks = Collections.synchronizedMap(new LinkedHashMap());
    private final Set<String> erroredResources = Collections.synchronizedSet(new HashSet());
    private boolean hasTrackElments;
    private int panelCounter = 1;
    private static Set<String> resourceIndpendentTracks;
    private static Map<String, String> geneTrackIds;

    public IGVSessionReader(IGV igv) {
        this.igv = igv;
        currentReader = new WeakReference<IGVSessionReader>(this);
    }

    @Override
    public void loadSession(InputStream inputStream, Session session, String sessionPath) {
        Document document;
        try {
            document = Utilities.createDOMDocumentFromXmlStream(inputStream);
        }
        catch (Exception e) {
            log.error("Load session error", e);
            throw new RuntimeException(e);
        }
        NodeList trackElements = document.getElementsByTagName("Track");
        this.hasTrackElments = trackElements.getLength() > 0;
        NodeList nodes = document.getElementsByTagName("Session");
        if (nodes == null || nodes.getLength() == 0) {
            nodes = document.getElementsByTagName("Global");
        }
        Node rootNode = nodes.item(0);
        this.processRootNode(session, rootNode, sessionPath);
        this.processCombinedDataSourceTracks();
        if (this.allocatedToPanel != null) {
            ArrayList<Track> unallocatedTracks = new ArrayList<Track>();
            for (List<Track> tracks : this.allTracks.values()) {
                for (Track t : tracks) {
                    if (this.allocatedToPanel.contains(t)) continue;
                    unallocatedTracks.add(t);
                }
            }
            this.addUnallocatedTracks(unallocatedTracks);
        }
        if (session.getGroupTracksBy() != null && session.getGroupTracksBy().length() > 0) {
            this.igv.setGroupByAttribute(session.getGroupTracksBy());
        }
        if (session.isRemoveEmptyPanels()) {
            this.igv.getMainPanel().removeEmptyDataPanels();
        }
        this.igv.resetOverlayTracks();
    }

    private void processRootNode(Session session, Node node, String sessionPath) {
        String removeEmptyTracks;
        if (node == null || session == null) {
            MessageUtils.showMessage("Invalid session file: root node not found");
            return;
        }
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase("Global") && !nodeName.equalsIgnoreCase("Session")) {
            MessageUtils.showMessage("Session files must begin with a \"Global\" or \"Session\" element.  Found: " + nodeName);
            return;
        }
        Element rootElement = (Element)node;
        String versionString = IGVSessionReader.getAttribute(rootElement, "version");
        try {
            this.version = Integer.parseInt(versionString);
        }
        catch (NumberFormatException e) {
            log.error("Non integer version number in session file: " + versionString);
        }
        String genomeId = IGVSessionReader.getAttribute(rootElement, "genome");
        if (genomeId != null && genomeId.length() > 0) {
            if (genomeId.equals(GenomeManager.getInstance().getGenomeId())) {
                this.igv.resetSession(sessionPath);
                GenomeManager.getInstance().restoreGenomeTracks(GenomeManager.getInstance().getCurrentGenome());
            } else {
                try {
                    GenomeListItem item = GenomeListManager.getInstance().getGenomeListItem(genomeId);
                    if (item != null) {
                        this.genomePath = item.getPath();
                        GenomeManager.getInstance().loadGenome(item.getPath());
                    } else {
                        this.genomePath = genomeId;
                        if (!FileUtils.isRemote(this.genomePath) && !ParsingUtils.fileExists(this.genomePath)) {
                            this.genomePath = this.getAbsolutePath(genomeId, sessionPath);
                        }
                        GenomeManager.getInstance().loadGenome(this.genomePath);
                    }
                }
                catch (IOException e) {
                    MessageUtils.showErrorMessage("Error loading genome: " + genomeId, e);
                    log.error("Error loading genome: " + genomeId, e);
                }
            }
        }
        session.setLocus(IGVSessionReader.getAttribute(rootElement, "locus"));
        session.setGroupTracksBy(IGVSessionReader.getAttribute(rootElement, "groupTracksBy"));
        String nextAutoscaleGroup = IGVSessionReader.getAttribute(rootElement, "nextAutoscaleGroup");
        if (nextAutoscaleGroup != null) {
            try {
                session.setNextAutoscaleGroup(Integer.parseInt(nextAutoscaleGroup));
            }
            catch (NumberFormatException e) {
                log.error("Error setting next autoscale group", e);
            }
        }
        if ((removeEmptyTracks = IGVSessionReader.getAttribute(rootElement, "removeEmptyTracks")) != null) {
            try {
                Boolean b = Boolean.parseBoolean(removeEmptyTracks);
                session.setRemoveEmptyPanels(b);
            }
            catch (Exception e) {
                log.error("Error parsing removeEmptyTracks string: " + removeEmptyTracks, e);
            }
        }
        session.setVersion(this.version);
        NodeList elements = rootElement.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void addUnallocatedTracks(List<Track> tracks) {
        HashMap<String, TrackPanel> trackPanelCache = new HashMap<String, TrackPanel>();
        log.debug("Adding \"leftover\" tracks");
        List<Map<TrackPanelScrollPane, Integer>> trackPanelAttrs = null;
        trackPanelAttrs = this.igv.getTrackPanelAttrs();
        for (Track track : tracks) {
            if (track.getResourceLocator() == null) continue;
            TrackPanel panel = (TrackPanel)trackPanelCache.get(track.getResourceLocator().getPath());
            if (panel == null) {
                panel = this.igv.getPanelFor(track);
                trackPanelCache.put(track.getResourceLocator().getPath(), panel);
            }
            panel.addTrack(track);
        }
        this.igv.resetPanelHeights(trackPanelAttrs.get(0), trackPanelAttrs.get(1));
    }

    private void process(Session session, Node element, String sessionPath) {
        if (element == null || session == null) {
            return;
        }
        String nodeName = element.getNodeName();
        if (nodeName.equalsIgnoreCase("Resources") || nodeName.equalsIgnoreCase("Files")) {
            this.processResources(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("Resource") || nodeName.equalsIgnoreCase("DataFile")) {
            this.processResource(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("Regions")) {
            this.processRegions(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("Region")) {
            this.processRegion(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("GeneList")) {
            this.processGeneList(session, (Element)element);
        } else if (nodeName.equalsIgnoreCase("Filter")) {
            this.processFilter(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("FilterElement")) {
            this.processFilterElement(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("ColorScales")) {
            this.processColorScales(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("ColorScale")) {
            this.processColorScale(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("Preferences")) {
            this.processPreferences(session, (Element)element);
        } else if (nodeName.equalsIgnoreCase("DataTracks") || nodeName.equalsIgnoreCase("FeatureTracks") || nodeName.equalsIgnoreCase("Panel")) {
            this.processPanel(session, (Element)element, sessionPath);
        } else if (nodeName.equalsIgnoreCase("PanelLayout")) {
            this.processPanelLayout(session, (Element)element);
        } else if (nodeName.equalsIgnoreCase("HiddenAttributes")) {
            this.processHiddenAttributes(session, (Element)element);
        } else if (nodeName.equalsIgnoreCase("VisibleAttributes")) {
            this.processVisibleAttributes(session, (Element)element);
        }
    }

    private void processResources(Session session, Element element, String sessionPath) {
        List<ResourceLocator> genomeResources;
        Set absoluteGenomeAnnotationPaths;
        this.dataFiles = new ArrayList<ResourceLocator>();
        this.missingDataFiles = new ArrayList<ResourceLocator>();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
        if (this.missingDataFiles.size() > 0) {
            StringBuffer message = new StringBuffer();
            message.append("<html>The following data file(s) could not be located.<ul>");
            for (ResourceLocator file : this.missingDataFiles) {
                if (file.getDBUrl() == null) {
                    message.append("<li>");
                    message.append(file.getPath());
                    message.append("</li>");
                    continue;
                }
                message.append("<li>Server: ");
                message.append(file.getDBUrl());
                message.append("  Path: ");
                message.append(file.getPath());
                message.append("</li>");
            }
            message.append("</ul>");
            message.append("Common reasons for this include: ");
            message.append("<ul><li>The session or data files have been moved.</li> ");
            message.append("<li>The data files are located on a drive that is not currently accessible.</li></ul>");
            message.append("</html>");
            MessageUtils.showMessage(message.toString());
        }
        Set set = absoluteGenomeAnnotationPaths = (genomeResources = GenomeManager.getInstance().getCurrentGenome().getAnnotationResources()) == null ? Collections.emptySet() : genomeResources.stream().map(rl -> rl.getPath()).collect(Collectors.toSet());
        if (this.dataFiles.size() > 0) {
            ArrayList errors = new ArrayList();
            ArrayList<Thread> threads = new ArrayList<Thread>(this.dataFiles.size());
            long t0 = System.currentTimeMillis();
            ArrayList<Runnable> synchronousLoads = new ArrayList<Runnable>();
            for (ResourceLocator locator : this.dataFiles) {
                if (absoluteGenomeAnnotationPaths.contains(FileUtils.getAbsolutePath(locator.getPath(), this.genomePath))) continue;
                Runnable runnable = () -> {
                    try {
                        List<Track> tracks = this.igv.load(locator);
                        for (Track track : tracks) {
                            if (track == null) {
                                log.info("Null track for resource " + locator.getPath());
                                continue;
                            }
                            String id = IGVSessionReader.checkTrackId(track.getId());
                            if (id == null) {
                                log.info("Null track id for resource " + locator.getPath());
                                continue;
                            }
                            if (!this.allTracks.containsKey(id)) {
                                this.allTracks.put(id, new ArrayList());
                            }
                            this.allTracks.get(id).add(track);
                        }
                    }
                    catch (Exception e) {
                        this.erroredResources.add(locator.getPath());
                        log.error("Error loading resource " + locator.getPath(), e);
                        String ms = "<b>" + locator.getPath() + "</b><br>&nbsp;&nbsp;" + e.toString() + "<br>";
                        errors.add(ms);
                    }
                };
                if (Globals.isBatch() || !this.hasTrackElments) {
                    synchronousLoads.add(runnable);
                    continue;
                }
                Thread t = new Thread(runnable);
                threads.add(t);
                t.start();
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException ignore) {
                    log.error(ignore);
                }
            }
            for (Runnable runnable : synchronousLoads) {
                runnable.run();
            }
            long dt = System.currentTimeMillis() - t0;
            log.debug("Total load time = " + dt);
            if (errors.size() > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("<html>Errors were encountered loading the session:<br>");
                for (String msg : errors) {
                    buf.append(msg);
                }
                MessageUtils.showMessage(buf.toString());
            }
        }
        this.dataFiles = null;
    }

    void processResource(Session session, Element element, String sessionPath) {
        String url;
        String nodeName = element.getNodeName();
        boolean oldSession = nodeName.equals("DataFile");
        String label = IGVSessionReader.getAttribute(element, "label");
        String name = IGVSessionReader.getAttribute(element, "name");
        String sampleId = IGVSessionReader.getAttribute(element, "sampleID");
        String description = IGVSessionReader.getAttribute(element, "description");
        String type = IGVSessionReader.getAttribute(element, "type");
        String coverage = IGVSessionReader.getAttribute(element, "coverage");
        String mapping = IGVSessionReader.getAttribute(element, "mapping");
        String trackLine = IGVSessionReader.getAttribute(element, "trackLine");
        String colorString = IGVSessionReader.getAttribute(element, "color");
        String index = IGVSessionReader.getAttribute(element, "index");
        String serverURL = IGVSessionReader.getAttribute(element, "serverURL");
        String path = IGVSessionReader.getAttribute(element, "path");
        if (oldSession && name != null) {
            path = name;
            int idx = name.lastIndexOf("/");
            if (idx > 0 && idx + 1 < name.length()) {
                name = name.substring(idx + 1);
            }
        }
        String absolutePath = sessionPath == null || ParsingUtils.isDataURL(path) ? path : this.getAbsolutePath(path, sessionPath);
        ResourceLocator resourceLocator = new ResourceLocator(serverURL, absolutePath);
        if (index != null) {
            resourceLocator.setIndexPath(index);
        }
        if (coverage != null) {
            String absoluteCoveragePath = coverage.equals(".") ? coverage : this.getAbsolutePath(coverage, sessionPath);
            resourceLocator.setCoverage(absoluteCoveragePath);
        }
        if (mapping != null) {
            String absoluteMappingPath = mapping.equals(".") ? mapping : this.getAbsolutePath(mapping, sessionPath);
            resourceLocator.setMappingPath(absoluteMappingPath);
        }
        if ((url = IGVSessionReader.getAttribute(element, "url")) == null) {
            url = IGVSessionReader.getAttribute(element, "featureURL");
        }
        resourceLocator.setFeatureInfoURL(url);
        String infolink = IGVSessionReader.getAttribute(element, "hyperlink");
        if (infolink == null) {
            infolink = IGVSessionReader.getAttribute(element, "infolink");
        }
        resourceLocator.setTrackInfoURL(infolink);
        if (name != null) {
            resourceLocator.setName(name);
        } else {
            resourceLocator.setName(label);
        }
        resourceLocator.setSampleId(sampleId);
        resourceLocator.setDescription(description);
        if (type != null && !type.equals("local")) {
            resourceLocator.setFormat(type);
        }
        resourceLocator.setCoverage(coverage);
        resourceLocator.setTrackLine(trackLine);
        if (colorString != null) {
            try {
                Color c = ColorUtilities.stringToColor(colorString);
                resourceLocator.setColor(c);
            }
            catch (Exception e) {
                log.error("Error setting color: ", e);
            }
        }
        this.dataFiles.add(resourceLocator);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void processRegions(Session session, Element element, String sessionPath) {
        session.clearRegionsOfInterest();
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void processRegion(Session session, Element element, String sessionPath) {
        String chromosome = IGVSessionReader.getAttribute(element, "chromosome");
        String start = IGVSessionReader.getAttribute(element, "start");
        String end = IGVSessionReader.getAttribute(element, "end");
        String description = IGVSessionReader.getAttribute(element, "description");
        RegionOfInterest region = new RegionOfInterest(chromosome, Integer.parseInt(start), Integer.parseInt(end), description);
        this.igv.addRegionOfInterest(region);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void processHiddenAttributes(Session session, Element element) {
        NodeList elements = element.getChildNodes();
        HashSet<String> attributes = new HashSet<String>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node childNode = elements.item(i);
            if (!childNode.getNodeName().equals("Attribute")) continue;
            attributes.add(((Element)childNode).getAttribute("name"));
        }
        session.setHiddenAttributes(attributes);
    }

    private void processVisibleAttributes(Session session, Element element) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashSet<String> visibleAttributes = new HashSet<String>();
            for (int i = 0; i < elements.getLength(); ++i) {
                Node childNode = elements.item(i);
                if (!childNode.getNodeName().equals("VisibleAttribute")) continue;
                visibleAttributes.add(((Element)childNode).getAttribute("name"));
            }
            List<String> attributeNames = AttributeManager.getInstance().getAttributeNames();
            HashSet<String> hiddenAttributes = new HashSet<String>(attributeNames);
            hiddenAttributes.removeAll(visibleAttributes);
            session.setHiddenAttributes(hiddenAttributes);
        }
    }

    private void processGeneList(Session session, Element element) {
        String name = IGVSessionReader.getAttribute(element, "name");
        String txt = element.getTextContent();
        String[] genes = txt.trim().split("\\s+");
        GeneList gl = new GeneList(name, Arrays.asList(genes));
        GeneListManager.getInstance().addGeneList(gl);
        session.setCurrentGeneList(gl);
        this.processFrames(element);
    }

    private void processFrames(Element element) {
        NodeList elements = element.getChildNodes();
        if (elements.getLength() > 0) {
            HashMap<String, ReferenceFrame> frames = new HashMap<String, ReferenceFrame>();
            for (ReferenceFrame f : FrameManager.getFrames()) {
                frames.put(f.getName(), f);
            }
            ArrayList<ReferenceFrame> reorderedFrames = new ArrayList<ReferenceFrame>();
            for (int i = 0; i < elements.getLength(); ++i) {
                String frameName;
                ReferenceFrame f;
                Node childNode = elements.item(i);
                if (!childNode.getNodeName().equalsIgnoreCase("Frame") || (f = (ReferenceFrame)frames.get(frameName = IGVSessionReader.getAttribute((Element)childNode, "name"))) == null) continue;
                reorderedFrames.add(f);
                try {
                    String chr = IGVSessionReader.getAttribute((Element)childNode, "chr");
                    String startString = IGVSessionReader.getAttribute((Element)childNode, "start").replace(",", "");
                    String endString = IGVSessionReader.getAttribute((Element)childNode, "end").replace(",", "");
                    int start = ParsingUtils.parseInt(startString);
                    int end = ParsingUtils.parseInt(endString);
                    Locus locus = new Locus(chr, start, end);
                    f.jumpTo(locus);
                    continue;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (reorderedFrames.size() > 0) {
                FrameManager.setFrames(reorderedFrames);
            }
        }
        this.igv.resetFrames();
    }

    private void processFilter(Session session, Element element, String sessionPath) {
        String match = IGVSessionReader.getAttribute(element, "match");
        String showAllTracks = IGVSessionReader.getAttribute(element, "showTracks");
        String filterName = IGVSessionReader.getAttribute(element, "name");
        this.filter = new TrackFilter(filterName, null);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
        session.setFilter(this.filter);
        if ("all".equalsIgnoreCase(match)) {
            this.igv.setFilterMatchAll(true);
        } else if ("any".equalsIgnoreCase(match)) {
            this.igv.setFilterMatchAll(false);
        }
        if ("true".equalsIgnoreCase(showAllTracks)) {
            this.igv.setFilterShowAllTracks(true);
        } else {
            this.igv.setFilterShowAllTracks(false);
        }
    }

    private void processFilterElement(Session session, Element element, String sessionPath) {
        if (this.filter == null) {
            throw new RuntimeException("Filter elements defined before filter");
        }
        String item = IGVSessionReader.getAttribute(element, "item");
        String operator = IGVSessionReader.getAttribute(element, "operator");
        String value = IGVSessionReader.getAttribute(element, "value");
        String booleanOperator = IGVSessionReader.getAttribute(element, "booleanOperator");
        FilterElement.Operator opEnum = CollUtils.findValueOf(FilterElement.Operator.class, operator);
        FilterElement.BooleanOperator boolEnum = FilterElement.BooleanOperator.valueOf(booleanOperator.toUpperCase());
        TrackFilterElement trackFilterElement = new TrackFilterElement(this.filter, item, opEnum, value, boolEnum);
        this.filter.add(trackFilterElement);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private static boolean nodeIsTrack(Node node) {
        return node.getNodeName() != null && (node.getNodeName().equalsIgnoreCase("DataTrack") || node.getNodeName().equalsIgnoreCase("Track"));
    }

    private void processPanel(Session session, Element element, String sessionPath) {
        Object panelName;
        if (!this.panelElementPresent) {
            this.panelElementPresent = true;
            List<Track> tmp = this.igv.getAllTracks();
            for (Track track : tmp) {
                String id = IGVSessionReader.checkTrackId(track.getId());
                if (!this.allTracks.containsKey(id)) {
                    this.allTracks.put(id, new ArrayList());
                }
                this.allTracks.get(id).add(track);
            }
            this.allocatedToPanel = new LinkedHashSet<Track>();
            this.removeAllTracksFromPanels();
        }
        if ((panelName = element.getAttribute("name")) == null) {
            panelName = "Panel" + this.panelCounter++;
        }
        ArrayList<Track> panelTracks = new ArrayList<Track>();
        NodeList elements = element.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node childNode = elements.item(i);
            if (IGVSessionReader.nodeIsTrack(childNode)) {
                List<Track> tracks = this.processTrack(session, (Element)childNode, sessionPath);
                if (tracks == null) continue;
                panelTracks.addAll(tracks);
                continue;
            }
            this.process(session, childNode, sessionPath);
        }
        for (Track track : panelTracks) {
            if (track instanceof FeatureTrack) {
                FeatureTrack featureTrack = (FeatureTrack)track;
                featureTrack.updateTrackReferences(panelTracks);
                continue;
            }
            if (!(track instanceof DataSourceTrack)) continue;
            DataSourceTrack dataTrack = (DataSourceTrack)track;
            dataTrack.updateTrackReferences(panelTracks);
        }
        TrackPanel panel = this.igv.getTrackPanel((String)panelName);
        panel.addTracks(panelTracks);
    }

    private void processPanelLayout(Session session, Element element) {
        String nodeName = element.getNodeName();
        NamedNodeMap tNodeMap = element.getAttributes();
        for (int i = 0; i < tNodeMap.getLength(); ++i) {
            Node node = tNodeMap.item(i);
            String name = node.getNodeName();
            if (!name.equals("dividerFractions")) continue;
            String value = node.getNodeValue();
            String[] tokens = value.split(",");
            double[] divs = new double[tokens.length];
            try {
                for (int j = 0; j < tokens.length; ++j) {
                    divs[j] = Double.parseDouble(tokens[j]);
                }
                session.setDividerFractions(divs);
                continue;
            }
            catch (NumberFormatException e) {
                log.error("Error parsing divider locations", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Track> processTrack(Session session, Element element, String sessionPath) {
        id = IGVSessionReader.checkTrackId(IGVSessionReader.getAttribute(element, "id"));
        matchedTracks = this.getTracksById(id);
        if (matchedTracks == null && id != null) {
            matchedTracks = this.allTracks.get(this.getAbsolutePath(id, sessionPath));
        }
        if (matchedTracks != null) {
            for (Track track : matchedTracks) {
                track.unmarshalXML(element, this.version);
                this.allocatedToPanel.add(track);
            }
        } else {
            className = IGVSessionReader.getAttribute(element, "clazz");
            if (IGVSessionReader.resourceIndpendentTracks.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processTrack$2(java.lang.String java.lang.String ), (Ljava/lang/String;)Z)((String)className))) {
                try {
                    track = this.createTrack(className, element);
                    if (track != null) {
                        track.unmarshalXML(element, this.version);
                        matchedTracks = Arrays.asList(new Track[]{track});
                        this.allTracks.put(IGVSessionReader.checkTrackId(track.getId()), matchedTracks);
                        if (className.contains("CombinedDataTrack")) {
                            this.combinedDataSourceTracks.add(new Pair<Track, Element>(track, element));
                        }
                        if (!className.contains("MergedTracks")) ** GOTO lbl42
                        memberTracks = this.processChildTracks(session, element, sessionPath);
                        ((MergedTracks)track).setMemberTracks(memberTracks);
                        nodeList = element.getElementsByTagName("DataRange");
                        if (nodeList == null || nodeList.getLength() <= 0) ** GOTO lbl42
                        dataRangeElement = (Element)nodeList.item(0);
                        try {
                            dataRange = new DataRange(dataRangeElement, (Integer)this.version);
                            track.setDataRange(dataRange);
                        }
                        catch (Exception e) {
                            IGVSessionReader.log.error("Unrecognized DataRange");
                        }
                    }
                    IGVSessionReader.log.warn("Warning.  No tracks were found with id: " + id + " in session file");
                }
                catch (Exception e) {
                    IGVSessionReader.log.error("Error restoring track: " + element.toString(), e);
                    MessageUtils.showMessage("Error loading track: " + element.toString());
                }
            }
        }
lbl42:
        // 9 sources

        elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
        return matchedTracks;
    }

    private List<DataTrack> processChildTracks(Session session, Element element, String sessionPath) {
        NodeList memberTrackNodes = element.getChildNodes();
        ArrayList<DataTrack> memberTracks = new ArrayList<DataTrack>(memberTrackNodes.getLength());
        for (int index = 0; index < memberTrackNodes.getLength(); ++index) {
            List<Track> addedTracks;
            Node memberNode = memberTrackNodes.item(index);
            if (!IGVSessionReader.nodeIsTrack(memberNode) || (addedTracks = this.processTrack(session, (Element)memberNode, sessionPath)) == null) continue;
            for (Track t : addedTracks) {
                if (t instanceof DataTrack) {
                    memberTracks.add((DataTrack)t);
                    continue;
                }
                log.error("Unexpected MergedTrack member class: " + t.getClass().getName());
            }
        }
        return memberTracks;
    }

    private void processCombinedDataSourceTracks() {
        HashMap<CombinedDataTrack, CombinedDataSource> sourceMap = new HashMap<CombinedDataTrack, CombinedDataSource>();
        for (Pair<CombinedDataTrack, Element> pair : this.combinedDataSourceTracks) {
            Element element = pair.getSecond();
            CombinedDataTrack combinedTrack = pair.getFirst();
            DataTrack track1 = null;
            DataTrack track2 = null;
            List<Track> tmp = this.getTracksById(element.getAttribute("track1"));
            if (tmp != null && tmp.size() > 0) {
                track1 = (DataTrack)tmp.get(0);
            }
            if ((tmp = this.getTracksById(element.getAttribute("track2"))) != null && tmp.size() > 0) {
                track2 = (DataTrack)tmp.get(0);
            }
            if (track1 == null || track2 == null) {
                log.error("Missing track for combined track: " + pair.getFirst().getName());
                return;
            }
            CombinedDataSource.Operation op = CombinedDataSource.Operation.valueOf(element.getAttribute("op"));
            CombinedDataSource source = new CombinedDataSource(track1, track2, op);
            sourceMap.put(combinedTrack, source);
        }
        for (Map.Entry entry : sourceMap.entrySet()) {
            ((CombinedDataTrack)entry.getKey()).setDatasource((DataSource)entry.getValue());
        }
    }

    private void processColorScales(Session session, Element element, String sessionPath) {
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void processColorScale(Session session, Element element, String sessionPath) {
        String trackType = IGVSessionReader.getAttribute(element, "type");
        String value = IGVSessionReader.getAttribute(element, "value");
        this.setColorScaleSet(session, trackType, value);
        NodeList elements = element.getChildNodes();
        this.process(session, elements, sessionPath);
    }

    private void processPreferences(Session session, Element element) {
        NodeList elements = element.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node child = elements.item(i);
            if (!child.getNodeName().equalsIgnoreCase("Property")) continue;
            Element childNode = (Element)child;
            String name = IGVSessionReader.getAttribute(childNode, "name");
            String value = IGVSessionReader.getAttribute(childNode, "value");
            session.setPreference(name, value);
        }
    }

    private void process(Session session, NodeList elements, String sessionPath) {
        for (int i = 0; i < elements.getLength(); ++i) {
            Node childNode = elements.item(i);
            this.process(session, childNode, sessionPath);
        }
    }

    public void setColorScaleSet(Session session, String type, String value) {
        if (type == null | value == null) {
            return;
        }
        TrackType trackType = CollUtils.valueOf(TrackType.class, type.toUpperCase(), TrackType.OTHER);
        ColorScale colorScale = ColorScaleFactory.getScaleFromString(value);
        if (colorScale instanceof ContinuousColorScale) {
            session.setColorScale(trackType, (ContinuousColorScale)colorScale);
        }
    }

    private static String getAttribute(Element element, String key) {
        String value = element.getAttribute(key);
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    public static Track getMatchingTrack(String trackId, List<Track> allTracks) {
        List<Track> matchingTracks;
        trackId = IGVSessionReader.checkTrackId(trackId);
        IGVSessionReader reader = (IGVSessionReader)currentReader.get();
        if (reader != null) {
            matchingTracks = reader.getTracksById(trackId);
        } else {
            if (allTracks == null) {
                throw new IllegalStateException("No session reader and no tracks to search to resolve Track references");
            }
            matchingTracks = new ArrayList<Track>();
            for (Track track : allTracks) {
                if (!trackId.equals(IGVSessionReader.checkTrackId(track.getId()))) continue;
                matchingTracks.add(track);
                break;
            }
        }
        if (matchingTracks == null || matchingTracks.size() == 0) {
            return null;
        }
        if (matchingTracks.size() >= 2) {
            log.debug("Found multiple tracks with id  " + trackId + ", using the first");
        }
        return matchingTracks.get(0);
    }

    private Track createTrack(String className, Element element) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (className.contains("BasePairTrack")) {
            return new BasePairTrack();
        }
        if (className.contains("BlatTrack")) {
            return new BlatTrack();
        }
        if (className.contains("ClusterTrack")) {
            return new ClusterTrack();
        }
        if (className.contains("CNFreqTrack")) {
            return new CNFreqTrack();
        }
        if (className.contains("CoverageTrack")) {
            return new CoverageTrack();
        }
        if (className.contains("DataSourceTrack")) {
            return new DataSourceTrack();
        }
        if (className.contains("DSITrack")) {
            return new DSITrack();
        }
        if (className.contains("EWigTrack")) {
            return new EWigTrack();
        }
        if (className.contains("FeatureTrack")) {
            return new FeatureTrack();
        }
        if (className.contains("MotifTrack")) {
            return new MotifTrack();
        }
        if (className.contains("GisticTrack")) {
            return new GisticTrack();
        }
        if (className.contains("InteractionTrack")) {
            return new InteractionTrack();
        }
        if (className.contains("MergedTracks")) {
            return new MergedTracks();
        }
        if (className.contains("CombinedDataTrack")) {
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            return new CombinedDataTrack(id, name);
        }
        if (className.contains("MultipleAlignmentTrack")) {
            return new MultipleAlignmentTrack();
        }
        if (className.contains("MutationTrack")) {
            return new MutationTrack();
        }
        if (className.contains("SelectableFeatureTrack")) {
            return new SelectableFeatureTrack();
        }
        if (className.contains("SpliceJunctionTrack")) {
            return new SpliceJunctionTrack();
        }
        if (className.contains("VariantTrack")) {
            return new VariantTrack();
        }
        if (className.contains("SequenceTrack")) {
            return new SequenceTrack("Reference sequence");
        }
        log.warn("Unrecognized class name: " + className);
        try {
            Class clazz = SessionElement.getClass(className);
            return (Track)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("Error attempting Track creation ", e);
            return null;
        }
    }

    private void removeAllTracksFromPanels() {
        List<TrackPanel> panels = this.igv.getTrackPanels();
        for (TrackPanel trackPanel : panels) {
            trackPanel.removeAllTracks();
        }
    }

    private String getAbsolutePath(String path, String sessionPath) {
        String tmp;
        String absolute = FileUtils.getAbsolutePath(path, sessionPath);
        if (!new File(absolute).exists() && path.startsWith("~") && new File(tmp = FileUtils.getAbsolutePath(path.replaceFirst("~", System.getProperty("user.home")), sessionPath)).exists()) {
            absolute = tmp;
        }
        return absolute;
    }

    public List<Track> getTracksById(String trackId) {
        List<Track> tracks = this.allTracks.get(trackId);
        if (tracks == null) {
            Genome genome;
            String legacyGeneTrackID;
            if (!FileUtils.isRemote(trackId)) {
                String fn = new File(trackId).getName();
                tracks = this.allTracks.get(fn);
            }
            if (tracks == null && trackId.equals(legacyGeneTrackID = (genome = GenomeManager.getInstance().getCurrentGenome()).getId() + "_genes") && genome.getGeneTrack() != null) {
                return Arrays.asList(genome.getGeneTrack());
            }
        }
        return tracks;
    }

    private static String checkTrackId(String id) {
        return id == null ? null : (geneTrackIds.containsKey(id) ? geneTrackIds.get(id) : id);
    }

    private static /* synthetic */ boolean lambda$processTrack$2(String className, String c) {
        return className.contains(c);
    }

    static {
        attributeSynonymMap.put("DATA FILE", "DATA SET");
        attributeSynonymMap.put("TRACK NAME", "NAME");
        resourceIndpendentTracks = new HashSet<String>(Arrays.asList("MergedTracks", "CombinedDataTrack", "SequenceTrack", "BlatTrack", "MotifTrack"));
        geneTrackIds = Map.of("https://hgdownload.soe.ucsc.edu/goldenPath/hg38/database/ncbiRefSeq.txt.gz", "hg38_gene_track", "https://hgdownload.soe.ucsc.edu/goldenPath/hg38/database/refGene.txt.gz", "hg38_gene_track", "https://s3.amazonaws.com/igv.org.genomes/hg38/ncbiRefSeq.txt.gz", "hg38_gene_track", "https://s3.amazonaws.com/igv.org.genomes/hg38/ncbiRefSeq.sorted.txt.gz", "hg38_gene_track", "https://s3.amazonaws.com/igv.org.genomes/hg38/ncbiRefGene.txt.gz", "hg38_gene_track", "https://s3.dualstack.us-east-1.amazonaws.com/igv.org.genomes/hg38/ncbiRefGene.txt.gz", "hg38_gene_track", "https://s3.amazonaws.com/igv.org.genomes/hg19/ncbiRefSeq.sorted.txt.gz", "hg19_gene_track", "https://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/ncbiRefSeq.txt.gz", "hg19_gene_track");
    }
}

