/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.util.ParsingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class TabixReader
implements AutoCloseable {
    private final String mFilePath;
    private final String mIndexPath;
    private final Function<SeekableByteChannel, SeekableByteChannel> mIndexWrapper;
    private final BlockCompressedInputStream mFp;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private String[] mSeq;
    private Map<String, Integer> mChr2tid;
    private static int MAX_BIN = 37450;
    private static int TAD_LIDX_SHIFT = 14;
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    protected TIndex[] mIndex;
    private static final Iterator EOF_ITERATOR = new Iterator(){

        @Override
        public String next() throws IOException {
            return null;
        }
    };

    private static boolean less64(long u, long v) {
        return u < v ^ u < 0L ^ v < 0L;
    }

    public TabixReader(String filePath) throws IOException {
        this(filePath, null, SeekableStreamFactory.getInstance().getBufferedStream(SeekableStreamFactory.getInstance().getStreamFor(filePath)));
    }

    public TabixReader(String filePath, String indexPath) throws IOException {
        this(filePath, indexPath, SeekableStreamFactory.getInstance().getBufferedStream(SeekableStreamFactory.getInstance().getStreamFor(filePath)));
    }

    public TabixReader(String filePath, String indexPath, Function<SeekableByteChannel, SeekableByteChannel> wrapper, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws IOException {
        this(filePath, indexPath, SeekableStreamFactory.getInstance().getBufferedStream(SeekableStreamFactory.getInstance().getStreamFor(filePath, wrapper)), indexWrapper);
    }

    public TabixReader(String filePath, SeekableStream stream) throws IOException {
        this(filePath, null, stream);
    }

    public TabixReader(String filePath, String indexPath, SeekableStream stream) throws IOException {
        this(filePath, indexPath, stream, null);
    }

    public TabixReader(String filePath, String indexPath, SeekableStream stream, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws IOException {
        this.mFilePath = filePath;
        this.mFp = new BlockCompressedInputStream(stream);
        this.mIndexWrapper = indexWrapper;
        this.mIndexPath = indexPath == null ? ParsingUtils.appendToPath(filePath, ".tbi") : indexPath;
        this.readIndex();
    }

    public String getSource() {
        return this.mFilePath;
    }

    private static int reg2bins(int beg, int _end, int[] list) {
        int i = 0;
        int end = _end;
        if (beg >= end) {
            return 0;
        }
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list[i++] = 0;
        int k = 1 + (beg >> 26);
        while (k <= 1 + (end >> 26)) {
            list[i++] = k++;
        }
        k = 9 + (beg >> 23);
        while (k <= 9 + (end >> 23)) {
            list[i++] = k++;
        }
        k = 73 + (beg >> 20);
        while (k <= 73 + (end >> 20)) {
            list[i++] = k++;
        }
        k = 585 + (beg >> 17);
        while (k <= 585 + (end >> 17)) {
            list[i++] = k++;
        }
        k = 4681 + (beg >> 14);
        while (k <= 4681 + (end >> 14)) {
            list[i++] = k++;
        }
        return i;
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static String readLine(InputStream is) throws IOException {
        return TabixReader.readLine(is, 1000);
    }

    private static String readLine(InputStream is, int bufferCapacity) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer(bufferCapacity);
        while ((c = is.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return buf.toString();
    }

    private void readIndex(SeekableStream fp) throws IOException {
        int i;
        if (fp == null) {
            return;
        }
        BlockCompressedInputStream is = new BlockCompressedInputStream(fp);
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        this.mSeq = new String[TabixReader.readInt(is)];
        this.mChr2tid = new HashMap<String, Integer>(this.mSeq.length);
        this.mPreset = TabixReader.readInt(is);
        this.mSc = TabixReader.readInt(is);
        this.mBc = TabixReader.readInt(is);
        this.mEc = TabixReader.readInt(is);
        this.mMeta = TabixReader.readInt(is);
        TabixReader.readInt(is);
        int l = TabixReader.readInt(is);
        buf = new byte[l];
        is.read(buf);
        int k = 0;
        int j = 0;
        for (i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            byte[] b = new byte[i - j];
            System.arraycopy(buf, j, b, 0, b.length);
            String contig = new String(b);
            this.mChr2tid.put(contig, k);
            this.mSeq[k++] = contig;
            j = i + 1;
        }
        this.mIndex = new TIndex[this.mSeq.length];
        for (i = 0; i < this.mSeq.length; ++i) {
            int n_bin = TabixReader.readInt(is);
            this.mIndex[i] = new TIndex();
            this.mIndex[i].b = new HashMap(n_bin);
            for (j = 0; j < n_bin; ++j) {
                int bin = TabixReader.readInt(is);
                TPair64[] chunks = new TPair64[TabixReader.readInt(is)];
                for (k = 0; k < chunks.length; ++k) {
                    long u = TabixReader.readLong(is);
                    long v = TabixReader.readLong(is);
                    chunks[k] = new TPair64(u, v);
                }
                this.mIndex[i].b.put(bin, chunks);
            }
            this.mIndex[i].l = new long[TabixReader.readInt(is)];
            for (k = 0; k < this.mIndex[i].l.length; ++k) {
                this.mIndex[i].l[k] = TabixReader.readLong(is);
            }
        }
        is.close();
    }

    private void readIndex() throws IOException {
        ISeekableStreamFactory ssf = SeekableStreamFactory.getInstance();
        this.readIndex(ssf.getBufferedStream(ssf.getStreamFor(this.mIndexPath, this.mIndexWrapper), 128000));
    }

    public String readLine() throws IOException {
        return TabixReader.readLine(this.mFp, 1000);
    }

    public int chr2tid(String chr) {
        Integer tid = this.mChr2tid.get(chr);
        return tid == null ? -1 : tid;
    }

    public Set<String> getChromosomes() {
        return Collections.unmodifiableSet(this.mChr2tid.keySet());
    }

    public int[] parseReg(String reg) {
        String chr;
        int[] ret = new int[3];
        int colon = reg.indexOf(58);
        int hyphen = reg.indexOf(45);
        String string = chr = colon >= 0 ? reg.substring(0, colon) : reg;
        ret[1] = colon >= 0 ? Integer.parseInt(reg.substring(colon + 1, hyphen >= 0 ? hyphen : reg.length())) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(reg.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TIntv getIntv(String s) {
        TIntv intv = new TIntv();
        int col = 0;
        int end = 0;
        int beg = 0;
        while ((end = s.indexOf(9, beg)) >= 0 || end == -1) {
            if (++col == this.mSc) {
                intv.tid = this.chr2tid(end != -1 ? s.substring(beg, end) : s.substring(beg));
            } else if (col == this.mBc) {
                intv.end = Integer.parseInt(end != -1 ? s.substring(beg, end) : s.substring(beg));
                intv.beg = intv.end++;
                if ((this.mPreset & 0x10000) == 0) {
                    --intv.beg;
                }
                if (intv.beg < 0) {
                    intv.beg = 0;
                }
                if (intv.end < 1) {
                    intv.end = 1;
                }
            } else if ((this.mPreset & 0xFFFF) == 0) {
                if (col == this.mEc) {
                    intv.end = Integer.parseInt(end != -1 ? s.substring(beg, end) : s.substring(beg));
                }
            } else if ((this.mPreset & 0xFFFF) == 1) {
                if (col == 6) {
                    int l = 0;
                    String cigar = s.substring(beg, end);
                    int j = 0;
                    for (int i = 0; i < cigar.length(); ++i) {
                        if (cigar.charAt(i) <= '9') continue;
                        char op = cigar.charAt(i);
                        if (op == 'M' || op == 'D' || op == 'N') {
                            l += Integer.parseInt(cigar.substring(j, i));
                        }
                        j = i + 1;
                    }
                    intv.end = intv.beg + l;
                }
            } else if ((this.mPreset & 0xFFFF) == 2) {
                String alt;
                String string = alt = end >= 0 ? s.substring(beg, end) : s.substring(beg);
                if (col == 4) {
                    if (!alt.isEmpty()) {
                        intv.end = intv.beg + alt.length();
                    }
                } else if (col == 8) {
                    int e_off = -1;
                    int i = alt.indexOf("END=");
                    if (i == 0) {
                        e_off = 4;
                    } else if (i > 0 && (i = alt.indexOf(";END=")) >= 0) {
                        e_off = i + 5;
                    }
                    if (e_off > 0) {
                        i = alt.indexOf(59, e_off);
                        intv.end = Integer.parseInt(i > e_off ? alt.substring(e_off, i) : alt.substring(e_off));
                    }
                }
            }
            if (end == -1) break;
            beg = end + 1;
        }
        return intv;
    }

    public Iterator query(int tid, int beg, int end) {
        TPair64[] chunks;
        int i;
        if (tid < 0 || beg < 0 || end <= 0 || tid >= this.mIndex.length) {
            return EOF_ITERATOR;
        }
        TIndex idx = this.mIndex[tid];
        int[] bins = new int[MAX_BIN];
        int n_bins = TabixReader.reg2bins(beg, end, bins);
        long min_off = idx.l.length > 0 ? (beg >> TAD_LIDX_SHIFT >= idx.l.length ? idx.l[idx.l.length - 1] : idx.l[beg >> TAD_LIDX_SHIFT]) : 0L;
        int n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            n_off += chunks.length;
        }
        if (n_off == 0) {
            return EOF_ITERATOR;
        }
        Object[] off = new TPair64[n_off];
        n_off = 0;
        for (i = 0; i < n_bins; ++i) {
            chunks = idx.b.get(bins[i]);
            if (chunks == null) continue;
            for (int j = 0; j < chunks.length; ++j) {
                if (!TabixReader.less64(min_off, chunks[j].v)) continue;
                off[n_off++] = new TPair64(chunks[j]);
            }
        }
        Arrays.sort(off, 0, n_off);
        int l = 0;
        for (i = 1; i < n_off; ++i) {
            if (!TabixReader.less64(((TPair64)off[l]).v, ((TPair64)off[i]).v)) continue;
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        for (i = 1; i < n_off; ++i) {
            if (TabixReader.less64(((TPair64)off[i - 1]).v, ((TPair64)off[i]).u)) continue;
            ((TPair64)off[i - 1]).v = ((TPair64)off[i]).u;
        }
        l = 0;
        for (i = 1; i < n_off; ++i) {
            if (((TPair64)off[l]).v >> 16 == ((TPair64)off[i]).u >> 16) {
                ((TPair64)off[l]).v = ((TPair64)off[i]).v;
                continue;
            }
            ((TPair64)off[++l]).u = ((TPair64)off[i]).u;
            ((TPair64)off[l]).v = ((TPair64)off[i]).v;
        }
        n_off = l + 1;
        TPair64[] ret = new TPair64[n_off];
        for (i = 0; i < n_off; ++i) {
            if (off[i] == null) continue;
            ret[i] = new TPair64(((TPair64)off[i]).u, ((TPair64)off[i]).v);
        }
        if (ret.length == 0 || ret.length == 1 && ret[0] == null) {
            return EOF_ITERATOR;
        }
        return new IteratorImpl(tid, beg, end, ret);
    }

    public Iterator query(String reg) {
        int[] x = this.parseReg(reg);
        return this.query(x[0], x[1], x[2]);
    }

    public Iterator query(String reg, int start, int end) {
        int tid = this.chr2tid(reg);
        return this.query(tid, start, end);
    }

    @Override
    public void close() {
        if (this.mFp != null) {
            try {
                this.mFp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "TabixReader: filename:" + this.getSource();
    }

    protected static class TIndex {
        HashMap<Integer, TPair64[]> b;
        long[] l;

        protected TIndex() {
        }
    }

    protected static class TPair64
    implements Comparable<TPair64> {
        long u;
        long v;

        public TPair64(long _u, long _v) {
            this.u = _u;
            this.v = _v;
        }

        public TPair64(TPair64 p) {
            this.u = p.u;
            this.v = p.v;
        }

        @Override
        public int compareTo(TPair64 p) {
            return this.u == p.u ? 0 : (this.u < p.u ^ this.u < 0L ^ p.u < 0L ? -1 : 1);
        }
    }

    private static class TIntv {
        int tid;
        int beg;
        int end;

        private TIntv() {
        }
    }

    public static interface Iterator {
        public String next() throws IOException;
    }

    private class IteratorImpl
    implements Iterator {
        private int i = -1;
        private int tid;
        private int beg;
        private int end;
        private TPair64[] off;
        private long curr_off = 0L;
        private boolean iseof = false;

        private IteratorImpl(int _tid, int _beg, int _end, TPair64[] _off) {
            this.off = _off;
            this.tid = _tid;
            this.beg = _beg;
            this.end = _end;
        }

        @Override
        public String next() throws IOException {
            block5: {
                String s;
                if (this.iseof) {
                    return null;
                }
                while (true) {
                    if (this.curr_off == 0L || !TabixReader.less64(this.curr_off, this.off[this.i].v)) {
                        if (this.i == this.off.length - 1) break block5;
                        if (this.i >= 0) assert (this.curr_off == this.off[this.i].v);
                        if (this.i < 0 || this.off[this.i].v != this.off[this.i + 1].u) {
                            TabixReader.this.mFp.seek(this.off[this.i + 1].u);
                            this.curr_off = TabixReader.this.mFp.getFilePointer();
                        }
                        ++this.i;
                    }
                    if ((s = TabixReader.readLine(TabixReader.this.mFp, 1000)) == null) break block5;
                    this.curr_off = TabixReader.this.mFp.getFilePointer();
                    if (s.isEmpty() || s.charAt(0) == TabixReader.this.mMeta) continue;
                    TIntv intv = TabixReader.this.getIntv(s);
                    if (intv.tid != this.tid || intv.beg >= this.end) break block5;
                    if (intv.end > this.beg && intv.beg < this.end) break;
                }
                return s;
            }
            this.iseof = true;
            return null;
        }
    }
}

