/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.io;

import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;

public class HtsPath
implements IOPath,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String HIERARCHICAL_SCHEME_SEPARATOR = "://";
    private final String rawInputString;
    private final URI uri;
    private transient String pathFailureReason;
    private transient Path cachedPath;

    public HtsPath(String rawInputString) {
        ValidationUtils.nonNull(rawInputString);
        this.rawInputString = rawInputString;
        this.uri = this.getURIForString(rawInputString);
    }

    public HtsPath(HtsPath htsPath) {
        ValidationUtils.nonNull(htsPath);
        this.rawInputString = htsPath.getRawInputString();
        this.uri = htsPath.getURI();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getURIString() {
        return this.getURI().toString();
    }

    @Override
    public String getRawInputString() {
        return this.rawInputString;
    }

    @Override
    public boolean hasFileSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!provider.getScheme().equalsIgnoreCase(this.uri.getScheme())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPath() {
        try {
            return this.getCachedPath() != null || this.toPath() != null;
        }
        catch (AssertionError | IllegalArgumentException | FileSystemNotFoundException | ProviderNotFoundException e) {
            this.pathFailureReason = ((Throwable)e).getMessage();
            return false;
        }
    }

    @Override
    public Path toPath() {
        if (this.getCachedPath() != null) {
            return this.getCachedPath();
        }
        Path tmpPath = Paths.get(this.getURI());
        this.setCachedPath(tmpPath);
        return tmpPath;
    }

    @Override
    public String getToPathFailureReason() {
        if (this.pathFailureReason == null) {
            try {
                this.toPath();
                return String.format("'%s' appears to be a valid Path", this.rawInputString);
            }
            catch (ProviderNotFoundException e) {
                return String.format("ProviderNotFoundException: %s", e.getMessage());
            }
            catch (FileSystemNotFoundException e) {
                return String.format("FileSystemNotFoundException: %s", e.getMessage());
            }
            catch (IllegalArgumentException e) {
                return String.format("IllegalArgumentException: %s", e.getMessage());
            }
            catch (RuntimeException e) {
                return String.format("UserException: %s", e.getMessage());
            }
        }
        return this.pathFailureReason;
    }

    @Override
    public InputStream getInputStream() {
        if (!this.isPath()) {
            throw new RuntimeException(this.getToPathFailureReason());
        }
        Path resourcePath = this.toPath();
        try {
            return Files.newInputStream(resourcePath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not create open input stream for %s (as URI %s)", this.getRawInputString(), this.getURIString()), e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (!this.isPath()) {
            throw new RuntimeException(this.getToPathFailureReason());
        }
        Path resourcePath = this.toPath();
        try {
            return Files.newOutputStream(resourcePath, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not open output stream for %s (as URI %s)", this.getRawInputString(), this.getURIString()), e);
        }
    }

    protected Path getCachedPath() {
        return this.cachedPath;
    }

    protected void setCachedPath(Path path) {
        this.cachedPath = path;
    }

    public String toString() {
        return this.rawInputString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HtsPath)) {
            return false;
        }
        HtsPath that = (HtsPath)o;
        if (!this.getRawInputString().equals(that.getRawInputString())) {
            return false;
        }
        return this.getURI().equals(that.getURI());
    }

    public int hashCode() {
        int result = this.getRawInputString().hashCode();
        result = 31 * result + this.getURI().hashCode();
        return result;
    }

    private URI getURIForString(String pathString) {
        URI tempURI;
        try {
            tempURI = new URI(pathString);
            if (!tempURI.isAbsolute()) {
                this.setCachedPath(Paths.get(pathString, new String[0]));
                tempURI = this.getCachedPath().toUri();
            }
        }
        catch (URISyntaxException uriException) {
            HtsPath.assertNoProblematicScheme(pathString, uriException);
            try {
                this.setCachedPath(Paths.get(pathString, new String[0]));
                tempURI = this.getCachedPath().toUri();
            }
            catch (SecurityException | UnsupportedOperationException | InvalidPathException pathException) {
                String errorMessage = String.format("%s can't be interpreted as a local file (%s) or as a URI (%s).", pathString, pathException.getMessage(), uriException.getMessage());
                throw new IllegalArgumentException(errorMessage, pathException);
            }
        }
        if (!tempURI.isAbsolute()) {
            throw new RuntimeException("URI has no scheme");
        }
        return tempURI;
    }

    static void assertNoProblematicScheme(String pathString, URISyntaxException cause) {
        if (pathString.equals(HIERARCHICAL_SCHEME_SEPARATOR)) {
            throw new IllegalArgumentException(":// is not a valid path.", cause);
        }
        String[] split = pathString.split(HIERARCHICAL_SCHEME_SEPARATOR, -1);
        String scheme = split[0];
        if (split.length == 2 && pathString.endsWith(HIERARCHICAL_SCHEME_SEPARATOR)) {
            throw new IllegalArgumentException("A path consisting of only a scheme is not allowed: " + pathString, cause);
        }
        if (split.length > 1) {
            if (scheme == null || scheme.isEmpty()) {
                throw new IllegalArgumentException("Malformed path " + pathString + " includes an empty scheme.", cause);
            }
            if (!scheme.equals("file")) {
                throw new IllegalArgumentException("Malformed path " + pathString + " includes a scheme: " + scheme + ":// but was an invalid URI.\nCheck that it is fully encoded.", cause);
            }
        }
    }
}

