/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.twobit;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class UnsignedByteBuffer {
    ByteBuffer wrappedBuffer;

    public static UnsignedByteBuffer loadBinaryBuffer(String path, ByteOrder byteOrder, long start, int size) throws IOException {
        try (SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(path);){
            ByteBuffer bb = ByteBuffer.allocate(size);
            bb.order(byteOrder);
            byte[] bytes = bb.array();
            is.seek(start);
            is.readFully(bytes);
            UnsignedByteBuffer unsignedByteBuffer = new UnsignedByteBuffer(bb);
            return unsignedByteBuffer;
        }
    }

    public static UnsignedByteBuffer wrap(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.order(byteOrder);
        return new UnsignedByteBuffer(bb);
    }

    public static UnsignedByteBuffer wrap(byte[] bytes) {
        return UnsignedByteBuffer.wrap(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    private UnsignedByteBuffer(ByteBuffer wrappedBuffer) {
        this.wrappedBuffer = wrappedBuffer;
    }

    public byte get() {
        return this.wrappedBuffer.get();
    }

    public short getShort() {
        return this.wrappedBuffer.getShort();
    }

    public int getUShort() {
        return Short.toUnsignedInt(this.wrappedBuffer.getShort());
    }

    public int getInt() {
        return this.wrappedBuffer.getInt();
    }

    public long getUInt() {
        return Integer.toUnsignedLong(this.wrappedBuffer.getInt());
    }

    public long getLong() {
        return this.wrappedBuffer.getLong();
    }

    public float getFloat() {
        return this.wrappedBuffer.getFloat();
    }

    public double getDouble() {
        return this.wrappedBuffer.getDouble();
    }

    public String getString() {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(1000);
        while ((b = this.wrappedBuffer.get()) != 0) {
            bis.write(b);
        }
        return new String(bis.toByteArray());
    }

    public String getFixedLengthString(int length) {
        byte[] bytes = new byte[length];
        int nonPaddedLength = 0;
        this.wrappedBuffer.get(bytes);
        for (int i = 0; i < length && bytes[i] != 0; ++i) {
            ++nonPaddedLength;
        }
        return new String(bytes, 0, nonPaddedLength);
    }

    public long position() {
        return this.wrappedBuffer.position();
    }

    public void position(int i) {
        this.wrappedBuffer.position(i);
    }

    public byte[] array() {
        return this.wrappedBuffer.array();
    }

    public long remaining() {
        return this.wrappedBuffer.remaining();
    }
}

