/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.oauth;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.broad.igv.DirectoryManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthProvider;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.HttpUtils;

public class OAuthUtils {
    private static Logger log = LogManager.getLogger(OAuthUtils.class);
    private static final String PROPERTIES_URL = "https://s3.amazonaws.com/igv.org.app/desktop_google";
    private static OAuthUtils theInstance;
    static OAuthProvider awsProvider;
    static OAuthProvider googleProvider;
    static Map<String, OAuthProvider> providerCache;

    public static synchronized OAuthUtils getInstance() {
        if (theInstance == null) {
            theInstance = new OAuthUtils();
        }
        return theInstance;
    }

    private OAuthUtils() {
        try {
            providerCache = new LinkedHashMap<String, OAuthProvider>();
            this.fetchOauthConfigs();
        }
        catch (Exception e) {
            log.error("Error fetching oAuth properties", e);
        }
    }

    private void fetchOauthConfigs() throws IOException {
        String oauthConfig;
        String provisioningURL = PreferencesManager.getPreferences().getProvisioningURL();
        log.debug("The provisioning URL from prefs.properties is: " + provisioningURL);
        if (provisioningURL != null && provisioningURL.length() > 0) {
            String json = this.loadAsString(provisioningURL);
            this.parseProviderJson(json);
        }
        if (!new File(oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config.json").exists()) {
            oauthConfig = DirectoryManager.getIgvDirectory() + "/oauth-config-custom.json";
        }
        if (new File(oauthConfig).exists()) {
            try {
                log.debug("Loading Oauth properties from: " + oauthConfig);
                String json = this.loadAsString(oauthConfig);
                this.parseProviderJson(json);
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    public OAuthProvider getAWSProvider() {
        if (awsProvider == null) {
            throw new RuntimeException("AWS Oauth is not configured");
        }
        return awsProvider;
    }

    public OAuthProvider getGoogleProvider() {
        if (googleProvider == null) {
            try {
                log.info("Loading Google oAuth properties");
                googleProvider = this.loadDefaultOauthProperties();
                if (IGVMenuBar.getInstance() != null) {
                    IGVMenuBar.getInstance().enableGoogleMenu(true);
                }
            }
            catch (IOException e) {
                log.error("Error loading Google oAuth properties", e);
                MessageUtils.showErrorMessage("Error loading Google oAuth properties", e);
            }
        }
        return googleProvider;
    }

    private OAuthProvider loadDefaultOauthProperties() throws IOException {
        String json = this.loadAsString(PROPERTIES_URL);
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(json).getAsJsonObject();
        return this.parseProviderObject(obj);
    }

    public void updateOauthProvider(String provisioningURL) throws IOException {
        if (provisioningURL != null && provisioningURL.trim().length() > 0) {
            String json = this.loadAsString(provisioningURL);
            this.parseProviderJson(json);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAsString(String urlOrPath) throws IOException {
        if (HttpUtils.isRemoteURL(urlOrPath)) {
            urlOrPath = HttpUtils.mapURL(urlOrPath);
        }
        try (InputStream is = null;){
            is = OAuthUtils.openInputStream(urlOrPath);
            byte[] bytes = is.readAllBytes();
            if (bytes[0] == 31 && bytes[1] == -117) {
                bytes = new GZIPInputStream(new ByteArrayInputStream(bytes)).readAllBytes();
            }
            String string = new String(bytes, "UTF-8");
            return string;
        }
    }

    private void parseProviderJson(String json) throws IOException {
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(json);
        if (element.isJsonArray()) {
            Iterator iter = element.getAsJsonArray().iterator();
            while (iter.hasNext()) {
                this.parseProviderObject(((JsonElement)iter.next()).getAsJsonObject());
            }
        } else {
            this.parseProviderObject(element.getAsJsonObject());
        }
    }

    private OAuthProvider parseProviderObject(JsonObject obj) throws IOException {
        OAuthProvider p = new OAuthProvider(obj);
        providerCache.put(p.getState(), p);
        if (obj.has("auth_provider") && obj.get("auth_provider").getAsString().equals("Amazon") || obj.has("aws_region")) {
            awsProvider = p;
            AmazonUtils.setCognitoConfig(obj);
        } else if (p.isGoogle()) {
            googleProvider = p;
            googleProvider.setAuthProvider("Google");
        }
        return p;
    }

    public OAuthProvider getProviderForState(String state) throws IOException {
        if (providerCache.containsKey(state)) {
            return providerCache.get(state);
        }
        log.warn("No oAuth provider found for callback");
        return null;
    }

    public OAuthProvider getProviderForURL(URL url) throws IOException {
        for (OAuthProvider provider : providerCache.values()) {
            if (!provider.appliesToUrl(url)) continue;
            if (provider.isGoogle()) {
                IGVMenuBar.getInstance().enableGoogleMenu(true);
            }
            return provider;
        }
        return null;
    }

    public Collection<OAuthProvider> getAllProviders() {
        return providerCache.values();
    }

    public static InputStream openInputStream(String urlOrPath) throws IOException {
        InputStream inputStream = null;
        if (urlOrPath.startsWith("http://") || urlOrPath.startsWith("https://")) {
            URL url = new URL(urlOrPath);
            HttpURLConnection conn = HttpUtils.getInstance().openProxiedConnection(url);
            inputStream = conn.getInputStream();
        } else {
            if (urlOrPath.startsWith("file://")) {
                urlOrPath = urlOrPath.substring(7);
            }
            File file = new File(urlOrPath);
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }
}

