/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.Feature;
import htsjdk.tribble.NamedFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.Globals;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.ChromAliasBB;
import org.broad.igv.feature.genome.ChromAliasDefaults;
import org.broad.igv.feature.genome.ChromAliasFile;
import org.broad.igv.feature.genome.ChromAliasSource;
import org.broad.igv.feature.genome.ChromosomeCoordinate;
import org.broad.igv.feature.genome.CytobandMap;
import org.broad.igv.feature.genome.CytobandSource;
import org.broad.igv.feature.genome.CytobandSourceBB;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.SequenceWrapper;
import org.broad.igv.feature.genome.fasta.FastaBlockCompressedSequence;
import org.broad.igv.feature.genome.fasta.FastaIndex;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.feature.genome.load.ChromSizesParser;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.ucsc.Hub;
import org.broad.igv.ucsc.twobit.TwoBitSequence;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.liftover.Liftover;

public class Genome {
    private static final int MAX_WHOLE_GENOME_LONG = 100;
    private static Logger log = LogManager.getLogger(Genome.class);
    private String id;
    private String displayName;
    private List<String> chromosomeNames;
    private List<String> longChromosomeNames;
    private Map<String, Chromosome> chromosomeMap;
    private long totalLength = -1L;
    private long nominalLength = -1L;
    private Map<String, Long> cumulativeOffsets = new HashMap<String, Long>();
    private Map<String, String> chrAliasCache = new HashMap<String, String>();
    private ChromAliasSource chromAliasSource;
    private Sequence sequence;
    private FeatureTrack geneTrack;
    private String species;
    private String ucscID;
    private String blatDB;
    private List<ResourceLocator> annotationResources;
    private boolean showWholeGenomeView = true;
    private Map<String, Liftover> liftoverMap;
    private CytobandSource cytobandSource;
    private String homeChromosome;
    private String defaultPos;
    private String nameSet;
    private Hub hub;
    private static Map<String, String> ucscSpeciesMap;
    private static Map<String, String> ucsdIDMap;

    public Genome(GenomeConfig config) throws IOException {
        Sequence uncachedSequence;
        this.id = config.id;
        this.displayName = config.name;
        this.nameSet = config.nameSet;
        this.blatDB = config.blatDB;
        this.ucscID = config.ucsdID == null ? (ucsdIDMap.containsKey(this.id) ? ucsdIDMap.get(this.id) : this.id) : config.ucsdID;
        this.blatDB = config.blatDB != null ? config.blatDB : this.ucscID;
        this.defaultPos = config.defaultPos;
        if (config.sequence != null) {
            uncachedSequence = config.sequence;
        } else if (config.twoBitURL != null) {
            uncachedSequence = config.twoBitBptURL != null ? new TwoBitSequence(config.twoBitURL, config.twoBitBptURL) : new TwoBitSequence(config.twoBitURL);
        } else if (config.fastaURL != null) {
            String fastaPath = config.fastaURL;
            String indexPath = config.indexURL;
            String gziIndexPath = config.gziIndexURL;
            uncachedSequence = fastaPath.endsWith(".gz") ? new FastaBlockCompressedSequence(fastaPath, gziIndexPath, indexPath) : new FastaIndexedSequence(fastaPath, indexPath);
        } else {
            throw new RuntimeException("Genomes require either a .2bit or fasta reference ");
        }
        this.sequence = new SequenceWrapper(uncachedSequence);
        List<Chromosome> chromosomeList = null;
        if (config.chromSizesURL != null) {
            chromosomeList = ChromSizesParser.parse(config.chromSizesURL);
        } else if (this.sequence != null && this.sequence.hasChromosomes()) {
            chromosomeList = this.sequence.getChromosomes();
        } else if (config.indexURL != null) {
            FastaIndex index = new FastaIndex(config.indexURL);
            chromosomeList = index.getChromosomes();
        }
        this.chromosomeNames = new ArrayList<String>();
        HashSet<String> ordered = new HashSet<String>();
        if (config.chromosomeOrder != null) {
            this.longChromosomeNames = Arrays.asList(config.chromosomeOrder);
            this.chromosomeNames.addAll(this.longChromosomeNames);
            ordered.addAll(this.longChromosomeNames);
        }
        this.chromosomeMap = new HashMap<String, Chromosome>();
        if (chromosomeList != null) {
            for (Chromosome c : chromosomeList) {
                this.chromosomeMap.put(c.getName(), c);
                if (ordered.contains(c.getName())) continue;
                this.chromosomeNames.add(c.getName());
            }
            if (this.longChromosomeNames == null && config.wholeGenomeView) {
                this.longChromosomeNames = this.computeLongChromosomeNames();
            }
        }
        boolean bl = this.showWholeGenomeView = config.wholeGenomeView && chromosomeList.size() > 1 && this.longChromosomeNames.size() <= 100;
        if (config.cytobands != null) {
            this.cytobandSource = new CytobandMap(config.cytobands);
        } else if (config.cytobandBbURL != null) {
            this.cytobandSource = new CytobandSourceBB(config.cytobandBbURL, this);
        } else if (config.cytobandURL != null) {
            this.cytobandSource = new CytobandMap(config.cytobandURL);
        }
        if (config.aliasURL != null) {
            this.chromAliasSource = new ChromAliasFile(config.aliasURL, this.chromosomeNames);
        } else if (config.chromAliasBbURL != null) {
            this.chromAliasSource = new ChromAliasBB(config.chromAliasBbURL, this);
            if (this.chromosomeNames == null || this.chromosomeNames.size() == 0) {
                this.chromosomeNames = Arrays.asList(((ChromAliasBB)this.chromAliasSource).getChromosomeNames());
            }
        } else {
            this.chromAliasSource = new ChromAliasDefaults(this.id, this.chromosomeNames);
        }
        if (config.chromAliases != null) {
            this.addChrAliases(config.chromAliases);
        }
        if (this.showWholeGenomeView) {
            this.homeChromosome = "All";
        } else if (config.defaultPos != null) {
            int idx = config.defaultPos.indexOf(":");
            this.homeChromosome = idx > 0 ? config.defaultPos.substring(0, idx) : config.defaultPos;
        } else if (this.chromosomeNames != null && this.chromosomeNames.size() > 0) {
            this.homeChromosome = this.chromosomeNames.get(0);
        }
        this.addTracks(config);
    }

    public Genome(String id, List<Chromosome> chromosomes) {
        this.id = id;
        this.displayName = id;
        this.chrAliasCache = new HashMap<String, String>();
        this.sequence = null;
        this.chromosomeNames = new ArrayList<String>(chromosomes.size());
        this.chromosomeMap = new LinkedHashMap<String, Chromosome>(chromosomes.size());
        for (Chromosome chromosome : chromosomes) {
            this.chromosomeNames.add(chromosome.getName());
            this.chromosomeMap.put(chromosome.getName(), chromosome);
        }
        this.longChromosomeNames = this.computeLongChromosomeNames();
        this.chromAliasSource = new ChromAliasDefaults(id, this.chromosomeNames);
    }

    private void addTracks(GenomeConfig config) {
        ArrayList<ResourceLocator> tracks = new ArrayList<ResourceLocator>();
        ArrayList<ResourceLocator> hiddenTracks = new ArrayList<ResourceLocator>();
        List<TrackConfig> trackConfigs = config.tracks;
        if (trackConfigs == null) {
            trackConfigs = config.annotations;
        }
        if (trackConfigs != null) {
            trackConfigs.forEach(trackConfig -> {
                ResourceLocator res = ResourceLocator.fromTrackConfig(trackConfig);
                Boolean hidden = trackConfig.hidden;
                if (hidden != null && hidden.booleanValue()) {
                    hiddenTracks.add(res);
                } else {
                    tracks.add(res);
                }
            });
        }
        this.setAnnotationResources(tracks);
        if (hiddenTracks.size() > 0) {
            Genome.addToFeatureDB(hiddenTracks, this);
        }
    }

    public String getCanonicalChrName(String str) {
        if (str == null) {
            return str;
        }
        if (this.chrAliasCache.containsKey(str)) {
            return this.chrAliasCache.get(str);
        }
        if (this.chromAliasSource != null) {
            try {
                ChromAlias aliasRecord = this.chromAliasSource.search(str);
                if (aliasRecord != null) {
                    String chr = aliasRecord.getChr();
                    for (String a : aliasRecord.values()) {
                        this.chrAliasCache.put(a, chr);
                    }
                    return chr;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return str;
    }

    public String getChromosomeDisplayName(String chr) {
        if (this.nameSet != null && this.chromAliasSource != null) {
            String nm = this.chromAliasSource.getChromosomeAlias(chr, this.nameSet);
            return nm != null ? nm : chr;
        }
        return chr;
    }

    @Deprecated
    public boolean isKnownChr(String str) {
        return this.chrAliasCache.containsKey(str);
    }

    /*
     * WARNING - void declaration
     */
    public void addChrAliases(List<List<String>> synonymsList) {
        if (synonymsList == null) {
            return;
        }
        HashSet<String> chrNameSet = new HashSet<String>(this.chromosomeNames);
        for (List<String> synonyms : synonymsList) {
            ChromAlias chromAlias = null;
            if (this.chromAliasSource != null) {
                for (String string : synonyms) {
                    try {
                        chromAlias = this.chromAliasSource.search(string);
                    }
                    catch (IOException e) {
                        log.error("Error searching chromosome alias", e);
                    }
                    if (chromAlias == null) continue;
                    break;
                }
            }
            String chr = null;
            if (chromAlias == null) {
                for (String syn2 : synonyms) {
                    if (!chrNameSet.contains(syn2)) continue;
                    chr = syn2;
                    break;
                }
                if (chr == null) {
                    chr = synonyms.get(0);
                }
                chromAlias = new ChromAlias(chr);
            } else {
                chr = chromAlias.getChr();
            }
            int n = chromAlias.values().size() + 1;
            for (String syn : synonyms) {
                void var7_7;
                this.chrAliasCache.put(syn, chr);
                chromAlias.put(String.valueOf((int)(++var7_7)), syn);
            }
            if (this.chromAliasSource == null) continue;
            this.chromAliasSource.add(chromAlias);
        }
    }

    public static String getNCBIName(String name) {
        String[] tokens = name.split("\\|");
        return tokens[tokens.length - 1];
    }

    public String getHomeChromosome() {
        return this.homeChromosome;
    }

    public String getDefaultPos() {
        return this.defaultPos == null ? this.homeChromosome : this.defaultPos;
    }

    public Chromosome getChromosome(String name) {
        int length;
        String chrName = this.getCanonicalChrName(name);
        if (this.chromosomeMap.containsKey(chrName)) {
            return this.chromosomeMap.get(chrName);
        }
        if (this.sequence != null && (length = this.sequence.getChromosomeLength(chrName)) > 0) {
            int idx = this.chromosomeMap.size();
            Chromosome chromosome = new Chromosome(idx, chrName, length);
            this.chromosomeMap.put(chrName, chromosome);
            return chromosome;
        }
        return null;
    }

    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getCumulativeOffset(String chr) {
        Long cumOffset = this.cumulativeOffsets.get(chr);
        if (cumOffset == null) {
            long offset = 0L;
            for (String c : this.getLongChromosomeNames()) {
                if (chr.equals(c)) break;
                offset += (long)this.getChromosome(c).getLength();
            }
            cumOffset = offset;
            this.cumulativeOffsets.put(chr, cumOffset);
        }
        return cumOffset;
    }

    public int getGenomeCoordinate(String chr, int locationBP) {
        return (int)((this.getCumulativeOffset(chr) + (long)locationBP) / 1000L);
    }

    public ChromosomeCoordinate getChromosomeCoordinate(int genomeKBP) {
        long cumOffset = 0L;
        List<String> wgChrNames = this.getLongChromosomeNames();
        for (String c : wgChrNames) {
            int chrLen = this.getChromosome(c).getLength();
            if ((cumOffset + (long)chrLen) / 1000L > (long)genomeKBP) {
                int bp = (int)((long)(genomeKBP * 1000) - cumOffset);
                return new ChromosomeCoordinate(c, bp);
            }
            cumOffset += (long)chrLen;
        }
        String c = wgChrNames.get(wgChrNames.size() - 1);
        int bp = (int)((long)genomeKBP - cumOffset) * 1000;
        return new ChromosomeCoordinate(c, bp);
    }

    public String getId() {
        return this.id;
    }

    public String getBlatDB() {
        return this.blatDB == null ? this.getUCSCId() : this.blatDB;
    }

    public void setUcscID(String ucscID) {
        this.ucscID = ucscID;
    }

    public String getUCSCId() {
        return this.ucscID == null ? this.id : this.ucscID;
    }

    public String getSpecies() {
        if (this.species == null) {
            this.species = Genome.getSpeciesForID(this.getUCSCId());
        }
        return this.species;
    }

    public String getNextChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = 0; i < chrList.size() - 1; ++i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i + 1);
        }
        return null;
    }

    public String getPrevChrName(String chr) {
        List<String> chrList = this.getChromosomeNames();
        for (int i = chrList.size() - 1; i > 0; --i) {
            if (!chrList.get(i).equals(chr)) continue;
            return chrList.get(i - 1);
        }
        return null;
    }

    public byte[] getSequence(String chr, int start, int end) {
        return this.getSequence(this.getCanonicalChrName(chr), start, end, true);
    }

    public byte[] getSequence(String chr, int start, int end, boolean useCache) {
        if (this.sequence == null) {
            return null;
        }
        Chromosome c = this.getChromosome(chr);
        if (c == null) {
            return null;
        }
        if ((end = Math.min(end, c.getLength())) <= start) {
            return null;
        }
        return this.sequence.getSequence(chr, start, end);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public byte getReference(String chr, int pos) {
        return this.sequence == null ? null : Byte.valueOf(this.sequence.getBase(chr, pos));
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> chrCytoMap) {
        this.cytobandSource = new CytobandMap(chrCytoMap);
    }

    public void setGeneTrack(FeatureTrack geneFeatureTrack) {
        this.geneTrack = geneFeatureTrack;
    }

    public FeatureTrack getGeneTrack() {
        return this.geneTrack;
    }

    public List<String> getLongChromosomeNames() {
        return this.longChromosomeNames;
    }

    public long getWGLength() {
        if (this.nominalLength < 0L) {
            this.nominalLength = 0L;
            for (String chrName : this.getLongChromosomeNames()) {
                Chromosome chr = this.getChromosome(chrName);
                this.nominalLength += (long)chr.getLength();
            }
        }
        return this.nominalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getSpeciesForID(String id) {
        if (ucscSpeciesMap == null) {
            ucscSpeciesMap = new HashMap<String, String>();
            InputStream is = null;
            try {
                String nextLine;
                is = Genome.class.getResourceAsStream("speciesMapping.txt");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((nextLine = br.readLine()) != null) {
                    if (nextLine.startsWith("#")) continue;
                    String[] tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length == 2) {
                        ucscSpeciesMap.put(tokens[0].trim(), tokens[1].trim());
                        continue;
                    }
                    log.error("Unexpected number of tokens in species mapping file for line: " + nextLine);
                }
            }
            catch (IOException e) {
                log.error("Error reading species mapping table", e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("", e);
                    }
                }
            }
        }
        for (Map.Entry<String, String> entry : ucscSpeciesMap.entrySet()) {
            if (!id.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void setAnnotationResources(List<ResourceLocator> annotationResources) {
        this.annotationResources = annotationResources;
    }

    public List<ResourceLocator> getAnnotationResources() {
        return this.annotationResources;
    }

    private Genome(String id) {
        this.id = id;
    }

    public boolean getShowWholeGenomeView() {
        return this.showWholeGenomeView;
    }

    public Map<String, Liftover> getLiftoverMap() {
        return this.liftoverMap;
    }

    public void setLiftoverMap(Map<String, Liftover> liftoverMap) {
        this.liftoverMap = liftoverMap;
    }

    public void setChromAliasSource(ChromAliasSource chromAliasSource) {
        this.chromAliasSource = chromAliasSource;
    }

    public ChromAlias getAliasRecord(String chr) throws IOException {
        return this.chromAliasSource == null ? null : this.chromAliasSource.search(chr);
    }

    public List<Cytoband> getCytobands(String chrName) {
        if (this.cytobandSource != null) {
            try {
                return this.cytobandSource.getCytobands(chrName);
            }
            catch (IOException e) {
                log.error("Error fetching cytobands for chr: " + chrName, e);
                return null;
            }
        }
        Chromosome chromosome = this.getChromosome(chrName);
        return Collections.singletonList(new Cytoband(chromosome.getName(), 0, chromosome.getLength(), "", "gneg"));
    }

    private static String stripQuotes(String str) {
        if (str.startsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private static void addToFeatureDB(List<ResourceLocator> locators, Genome genome) {
        for (ResourceLocator locator : locators) {
            try {
                AbstractFeatureReader featureReader = TribbleFeatureSource.getBasicReader(locator, genome);
                for (Feature f : featureReader) {
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.addFeature((NamedFeature)f, genome);
                }
            }
            catch (IOException e) {
                log.error("Error loading " + locator.getPath());
            }
        }
    }

    public List<String> computeLongChromosomeNames() {
        ArrayList<String> longChromosomeNames = new ArrayList<String>();
        if (this.chromosomeMap.size() < 100) {
            double[] lengths = new double[this.chromosomeMap.size()];
            int idx = 0;
            for (Chromosome c : this.chromosomeMap.values()) {
                lengths[idx++] = c.getLength();
            }
            double mean = StatUtils.mean((double[])lengths);
            double min = 0.1 * mean;
            for (String chr : this.getChromosomeNames()) {
                if (!((double)this.chromosomeMap.get(chr).getLength() > min)) continue;
                longChromosomeNames.add(chr);
            }
        } else {
            ArrayList<Chromosome> allChromosomes = new ArrayList<Chromosome>(this.chromosomeMap.values());
            allChromosomes.sort((c1, c2) -> c2.getLength() - c1.getLength());
            Chromosome lastChromosome = null;
            HashSet<String> tmp = new HashSet<String>();
            for (Chromosome c : allChromosomes) {
                double delta;
                if (lastChromosome != null && (delta = (double)(lastChromosome.getLength() - c.getLength())) / (double)lastChromosome.getLength() > 0.7) break;
                tmp.add(c.getName());
                lastChromosome = c;
            }
            for (String chr : this.getChromosomeNames()) {
                if (!tmp.contains(chr)) continue;
                longChromosomeNames.add(chr);
            }
        }
        return longChromosomeNames;
    }

    public Hub getHub() {
        return this.hub;
    }

    public void setHub(Hub hub) {
        this.hub = hub;
    }

    static {
        ucsdIDMap = new HashMap<String, String>();
        ucsdIDMap.put("1kg_ref", "hg18");
        ucsdIDMap.put("1kg_v37", "hg19");
        ucsdIDMap.put("b37", "hg19");
    }
}

