/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.blat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.BlatTrack;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.URLUtils;
import org.broad.igv.util.blat.BlatException;
import org.broad.igv.util.blat.BlatQueryWindow;
import org.broad.igv.util.blat.LegacyBlatClient;

public class BlatClient {
    private static Logger log = LogManager.getLogger(BlatClient.class);
    public static final int MINIMUM_BLAT_LENGTH = 20;
    static Set knownUCSCGenomes = new HashSet<String>(Arrays.asList("hg18", "hg19", "hg38", "ce10", "ce11", "galGal4", "galGal5", "galGal6", "panTro3", "panTro4", "panTro5", "panTro6", "felCat6", "bosTau7", "bosTau8", "bosTau9", "dm3", "dm6", "canFam3", "canFam5", "mm8", "mm9", "mm10", "mm39", "rn5", "rn6", "rn7", "rheMac3", "rheMac8", "rheMac10", "sacCer3", "susScr3", "xenTro9", "danRer10", "danRer11", "gorGor4", "gorGor6", "panPan2", "susScr11", "strPur2"));

    public static List<PSLRecord> blat(String db, String userSeq) throws IOException {
        String serverType = PreferencesManager.getPreferences().get("BLAT_SERVER_TYPE", "");
        String urlpref = PreferencesManager.getPreferences().get("BLAT_URL");
        if (urlpref == null || urlpref.trim().length() == 0) {
            MessageUtils.showMessage("BLAT url is not configured");
            return Collections.EMPTY_LIST;
        }
        urlpref = urlpref.trim();
        if (serverType.equalsIgnoreCase("web_blat")) {
            return LegacyBlatClient.blat(userSeq);
        }
        String dbEncoded = URLEncoder.encode(db, "UTF-8");
        if (urlpref.startsWith("file://")) {
            urlpref = urlpref.substring("file://".length() + 1);
        }
        String jsonString = null;
        try {
            if (URLUtils.isURL(urlpref)) {
                if (urlpref.contains("$SEQUENCE")) {
                    urlpref = urlpref.replace("$SEQUENCE", userSeq).replace("$DB", dbEncoded);
                    jsonString = HttpUtils.getInstance().getContentsAsJSON(new URL(urlpref));
                } else {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("userSeq", userSeq);
                    params.put("db", dbEncoded);
                    params.put("type", "DNA");
                    params.put("output", "json");
                    jsonString = HttpUtils.getInstance().doPost(new URL(urlpref), params);
                }
            } else {
                jsonString = RuntimeUtils.exec(urlpref);
            }
            JsonObject obj = new JsonParser().parse(jsonString).getAsJsonObject();
            JsonArray arr = obj.get("blat").getAsJsonArray();
            Iterator iter = arr.iterator();
            ArrayList<String[]> results = new ArrayList<String[]>();
            while (iter.hasNext()) {
                JsonArray row = ((JsonElement)iter.next()).getAsJsonArray();
                String[] tokens = new String[row.size()];
                for (int i = 0; i < row.size(); ++i) {
                    String tmp = row.get(i).getAsString();
                    tokens[i] = StringUtils.stripQuotes(tmp);
                }
                results.add(tokens);
            }
            Genome genome = IGV.hasInstance() ? GenomeManager.getInstance().getCurrentGenome() : null;
            ArrayList<PSLRecord> features = new ArrayList<PSLRecord>(results.size());
            for (String[] tokens : results) {
                features.add(PSLCodec.getPslRecord(tokens, genome));
            }
            return features;
        }
        catch (JsonSyntaxException e) {
            String error = BlatClient.htmlToString(jsonString);
            throw new BlatException(error);
        }
        catch (InterruptedException e) {
            throw new BlatException("Error executing blat command: " + e.getMessage(), e);
        }
    }

    public static void doBlatQuery(String userSeq, String trackLabel) {
        try {
            List<PSLRecord> features;
            Genome genome = GenomeManager.getInstance().getCurrentGenome();
            String db = genome.getBlatDB();
            if (db == null) {
                db = genome.getId();
            }
            if ((features = BlatClient.blat(db, userSeq)).isEmpty()) {
                MessageUtils.showMessage("No features found");
            } else {
                BlatTrack newTrack = new BlatTrack(db, userSeq, features, trackLabel);
                IGV.getInstance().getTrackPanel("FeaturePanel").addTrack(newTrack);
                IGV.getInstance().repaint();
                BlatQueryWindow win = new BlatQueryWindow(IGV.getInstance().getMainFrame(), userSeq, newTrack.getFeatures());
                win.setVisible(true);
            }
        }
        catch (Exception e1) {
            log.error("BLAT error.", e1);
            MessageUtils.showMessage(e1.getLocalizedMessage());
        }
    }

    public static void doBlatQueryFromRegion(String chr, int start, int end, Strand strand) {
        if (end - start > 8000) {
            MessageUtils.showMessage("BLAT searches are limited to 8kb.  Please try a shorter sequence.");
            return;
        }
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start, end);
        String userSeq = new String(seqBytes);
        if (strand == Strand.NEGATIVE) {
            userSeq = SequenceTrack.getReverseComplement(userSeq);
        }
        BlatClient.doBlatQuery(userSeq, "BLAT");
    }

    private static String htmlToString(String str) {
        int idx1;
        for (int count = 0; (idx1 = ((String)str).indexOf("<script")) >= 0 && count < 10; ++count) {
            int idx2 = ((String)str).indexOf("</script>", idx1);
            if (idx1 <= 0 || idx2 <= idx1) continue;
            str = ((String)str).substring(0, idx1) + ((String)str).substring(idx2 + 9);
        }
        str = ((String)str).replaceAll("\\<.*?>", "").replace('\n', ' ');
        return str;
    }
}

