/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.broad.igv.ui.table.SearchableTableRecord;

public class SearchableTableModel
extends AbstractTableModel {
    private String[] columnHeadings;
    private List<SearchableTableRecord> records;
    private final TableRowSorter<SearchableTableModel> sorter;

    public SearchableTableModel(String[] headings, List<SearchableTableRecord> records) {
        this.records = records;
        ArrayList<String> tmp = new ArrayList<String>();
        for (String h : headings) {
            String heading = h.trim();
            if (heading.length() <= 0 || "path".equals(heading)) continue;
            tmp.add(heading);
        }
        this.columnHeadings = tmp.toArray(new String[tmp.size()]);
        this.sorter = new TableRowSorter<SearchableTableModel>(this);
        this.sorter.setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return value == null ? "" : value.toString();
            }
        });
    }

    public TableRowSorter<SearchableTableModel> getSorter() {
        return this.sorter;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeadings[column];
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.records.size() || columnIndex >= this.columnHeadings.length) {
            return null;
        }
        SearchableTableRecord record = this.records.get(rowIndex);
        String att = this.columnHeadings[columnIndex];
        return record.getAttributeValue(att);
    }

    public List<SearchableTableRecord> getRecords() {
        return this.records;
    }
}

