/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.cram.IGVReferenceSource;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.URLUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class SamReaderPool {
    public static final int BUFFER_SIZE = 512000;
    private static Logger log = LogManager.getLogger(SamReaderPool.class);
    private ResourceLocator locator;
    private boolean requireIndex;
    private List<SamReader> availableReaders;
    byte[] indexBytes;

    public SamReaderPool(ResourceLocator locator, boolean requireIndex) {
        this.locator = locator;
        this.requireIndex = requireIndex;
        this.availableReaders = Collections.synchronizedList(new ArrayList());
    }

    public synchronized SamReader getReader() throws IOException {
        if (this.availableReaders.size() > 0) {
            return this.availableReaders.remove(0);
        }
        return this.createReader();
    }

    public synchronized SamReader getReaderIterator() throws IOException {
        return this.createReader(1000000);
    }

    public void freeReader(SamReader reader) {
        this.availableReaders.add(reader);
    }

    public void close() throws IOException {
        for (SamReader reader : this.availableReaders) {
            reader.close();
        }
        this.availableReaders.clear();
    }

    private SamReader createReader() throws IOException {
        return this.createReader(512000);
    }

    private SamReader createReader(int bufferSize) throws IOException {
        SamInputResource resource;
        boolean isLocal = this.locator.isLocal();
        SamReaderFactory factory = SamReaderFactory.makeDefault().referenceSource((CRAMReferenceSource)new IGVReferenceSource()).validationStringency(ValidationStringency.SILENT);
        if (isLocal) {
            resource = SamInputResource.of((File)new File(this.locator.getPath()));
        } else if (this.locator.isHtsget()) {
            this.requireIndex = false;
            URI uri = null;
            try {
                String htsgetUriString = this.locator.getPath().replace("https://", "htsget://").replace("http://", "htsget://");
                uri = new URI(htsgetUriString);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            resource = SamInputResource.of((URI)uri);
        } else {
            URL url = HttpUtils.createURL(this.locator.getPath());
            if (this.requireIndex) {
                SeekableStream ss = IGVSeekableStreamFactory.getInstance().getStreamFor(url);
                resource = SamInputResource.of((SeekableStream)(bufferSize == 0 ? ss : IGVSeekableStreamFactory.getInstance().getBufferedStream(ss, bufferSize)));
            } else {
                resource = SamInputResource.of((InputStream)new BufferedInputStream(HttpUtils.getInstance().openConnectionStream(url), 512000));
            }
        }
        if (this.requireIndex) {
            String indexPath = this.getExplicitIndexPath(this.locator);
            if (indexPath == null || indexPath.length() == 0) {
                indexPath = this.getIndexPath(this.locator.getPath());
            }
            if (isLocal) {
                File indexFile = new File(indexPath);
                resource = resource.index(indexFile);
            } else {
                if (this.indexBytes == null) {
                    this.indexBytes = HttpUtils.getInstance().getContentsAsBytes(HttpUtils.createURL(indexPath), null);
                }
                ByteArraySeekableStream stream = new ByteArraySeekableStream(this.indexBytes);
                resource = resource.index((SeekableStream)stream);
            }
        }
        return factory.open(resource);
    }

    private String getExplicitIndexPath(ResourceLocator locator) {
        String p = locator.getPath().toLowerCase();
        String idx = locator.getIndexPath();
        if (idx == null && (p.startsWith("http://") || p.startsWith("https://"))) {
            try {
                Map<String, String> parameters;
                URL url = HttpUtils.createURL(locator.getPath());
                String queryString = url.getQuery();
                if (queryString != null && (parameters = URLUtils.parseQueryString(queryString)).containsKey("index")) {
                    idx = parameters.get("index");
                }
            }
            catch (MalformedURLException e) {
                log.error("Error parsing url: " + locator.getPath());
            }
        }
        return idx;
    }

    private String getIndexPath(String pathOrURL) throws IOException {
        String defaultValue;
        Object indexPath;
        ArrayList<Object> pathsTried = new ArrayList<Object>();
        if (URLUtils.isURL(pathOrURL)) {
            String path = URLUtils.getPath(pathOrURL);
            if (path.endsWith(".bam")) {
                indexPath = URLUtils.addExtension(pathOrURL, ".bai");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.replaceExtension(pathOrURL, ".bam", ".bai");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.addExtension(pathOrURL, ".csi");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
                indexPath = URLUtils.replaceExtension(pathOrURL, ".bam", ".csi");
                pathsTried.add(indexPath);
                if (HttpUtils.getInstance().resourceAvailable((String)indexPath)) {
                    return indexPath;
                }
            }
            if (path.endsWith(".cram")) {
                indexPath = URLUtils.addExtension(pathOrURL, ".crai");
                if (FileUtils.resourceExists((String)indexPath)) {
                    pathsTried.add(indexPath);
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
        } else {
            indexPath = pathOrURL + ".bai";
            if (FileUtils.resourceExists((String)indexPath)) {
                return indexPath;
            }
            if (((String)indexPath).contains(".bam.bai")) {
                indexPath = ((String)indexPath).replaceFirst(".bam.bai", ".bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            } else {
                indexPath = ((String)indexPath).replaceFirst(".bai", ".bam.bai");
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
            indexPath = pathOrURL + ".csi";
            pathsTried.add(indexPath);
            if (FileUtils.resourceExists((String)indexPath)) {
                return indexPath;
            }
            if (pathOrURL.endsWith(".bam")) {
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 4) + ".csi";
                pathsTried.add(indexPath);
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
            if (pathOrURL.endsWith(".cram")) {
                indexPath = pathOrURL + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
                indexPath = pathOrURL.substring(0, pathOrURL.length() - 5) + ".crai";
                if (FileUtils.resourceExists((String)indexPath)) {
                    return indexPath;
                }
            }
        }
        if ((indexPath = MessageUtils.showInputDialog("Index is required, but no index found.  Please enter path to index file:", defaultValue = pathOrURL + (pathOrURL.endsWith(".cram") ? ".crai" : ".bai"))) != null && FileUtils.resourceExists((String)indexPath)) {
            this.locator.setIndexPath((String)indexPath);
            return indexPath;
        }
        Object msg = "Index file not found.  Tried ";
        for (String string : pathsTried) {
            msg = (String)msg + "<br>" + string;
        }
        throw new DataLoadException((String)msg, (String)indexPath);
    }
}

