/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.ucsc.TrackConfigGroup;
import org.broad.igv.util.ParsingUtils;

public class Hub {
    private final String url;
    String baseURL;
    Stanza hub;
    Stanza genomeStanza;
    List<Stanza> trackStanzas;
    List<Stanza> groupStanzas;
    Map<String, Integer> groupPriorityMap;
    static Set supportedTypes = new HashSet<String>(Arrays.asList("bigBed", "bigWig", "bigGenePred", "vcfTabix"));
    static Set filterTracks = new HashSet<String>(Arrays.asList("cytoBandIdeo", "assembly", "gap", "gapOverlap", "allGaps", "cpgIslandExtUnmasked", "windowMasker"));

    public static Hub loadHub(String url) throws IOException {
        int idx = url.lastIndexOf("/");
        String baseURL = url.substring(0, idx + 1);
        List<Stanza> stanzas = Hub.loadStanzas(url);
        if (stanzas.size() < 2) {
            throw new RuntimeException("Expected at least 2 stanzas, hub and genome");
        }
        if (!"hub".equals(stanzas.get((int)0).type)) {
            throw new RuntimeException("Unexpected hub.txt file -- does the first line start with 'hub'?");
        }
        if (!"on".equals(stanzas.get(0).getProperty("useOneFile"))) {
            throw new RuntimeException("Only 'useOneFile' hubs are currently supported");
        }
        if (!"genome".equals(stanzas.get((int)1).type)) {
            throw new RuntimeException("Unexpected hub file -- expected 'genome' stanza but found " + stanzas.get((int)1).type);
        }
        List<Stanza> groups = null;
        Stanza genomeStanza = stanzas.get(1);
        if (genomeStanza.hasProperty("groups")) {
            String groupsTxtURL = baseURL + genomeStanza.getProperty("groups");
            groups = Hub.loadStanzas(groupsTxtURL);
        }
        List<Stanza> includes = stanzas.stream().filter(s -> "include".equals(s.type)).toList();
        for (Stanza s2 : includes) {
            List<Stanza> includeStanzas = Hub.loadStanzas(baseURL + s2.getProperty("include"));
            for (Stanza inc : includeStanzas) {
                s2.setProperty("visibility", "hide");
                stanzas.add(s2);
            }
        }
        return new Hub(url, stanzas, groups);
    }

    private Hub(String url, List<Stanza> stanzas, List<Stanza> groupStanzas) {
        String baseURL;
        this.url = url;
        int idx = url.lastIndexOf("/");
        this.baseURL = baseURL = url.substring(0, idx + 1);
        if (stanzas.size() < 2) {
            throw new RuntimeException("Expected at least 2 stanzas, hub and genome");
        }
        if (!"hub".equals(stanzas.get((int)0).type)) {
            throw new RuntimeException("Unexpected hub.txt file -- does the first line start with 'hub'?");
        }
        this.hub = stanzas.get(0);
        if (!"on".equals(this.hub.getProperty("useOneFile"))) {
            throw new RuntimeException("Only 'useOneFile' hubs are currently supported");
        }
        if (!"genome".equals(stanzas.get((int)1).type)) {
            throw new RuntimeException("Unexpected hub file -- expected 'genome' stanza but found " + stanzas.get((int)1).type);
        }
        this.genomeStanza = stanzas.get(1);
        this.trackStanzas = new ArrayList<Stanza>();
        for (int i = 2; i < stanzas.size(); ++i) {
            if (!"track".equals(stanzas.get((int)i).type)) continue;
            this.trackStanzas.add(stanzas.get(i));
        }
        if (groupStanzas != null) {
            this.groupStanzas = groupStanzas;
            this.groupPriorityMap = new HashMap<String, Integer>();
            for (Stanza g : groupStanzas) {
                if (!g.hasProperty("priority")) continue;
                this.groupPriorityMap.put(g.getProperty("name"), Integer.parseInt(g.getProperty("priority")) * 10);
            }
        }
    }

    private static List<Stanza> loadStanzas(String url) throws IOException {
        ArrayList<Stanza> nodes = new ArrayList<Stanza>();
        Stanza currentNode = null;
        boolean startNewNode = true;
        int order = 0;
        try (BufferedReader br = ParsingUtils.openBufferedReader(url);){
            String line;
            while ((line = br.readLine()) != null) {
                int indent = Hub.indentLevel(line);
                int i = line.indexOf(" ", indent);
                if (i < 0) {
                    startNewNode = true;
                    continue;
                }
                String key = line.substring(indent, i);
                if (key.startsWith("#")) continue;
                String value = line.substring(i + 1);
                if (startNewNode) {
                    Stanza newNode = new Stanza(++order, key, value);
                    nodes.add(newNode);
                    currentNode = newNode;
                    startNewNode = false;
                }
                currentNode.setProperty(key, value);
            }
        }
        return Hub.resolveParents(nodes);
    }

    private static int indentLevel(String str) {
        char c;
        int level;
        for (level = 0; level < str.length() && ((c = str.charAt(level)) == ' ' || c == '\t'); ++level) {
        }
        return level;
    }

    private static List<Stanza> resolveParents(List<Stanza> nodes) {
        HashMap<String, Stanza> nodeMap = new HashMap<String, Stanza>();
        for (Stanza n : nodes) {
            nodeMap.put(n.name, n);
        }
        for (Stanza n : nodes) {
            if (!n.properties.containsKey("parent")) continue;
            String parentName = Hub.firstWord(n.properties.get("parent"));
            n.parent = (Stanza)nodeMap.get(parentName);
        }
        return nodes;
    }

    public GenomeConfig getGenomeConfig(boolean includeTracks) {
        GenomeConfig config = new GenomeConfig();
        config.id = this.genomeStanza.getProperty("genome");
        if (this.genomeStanza.hasProperty("scientificName")) {
            config.name = this.genomeStanza.getProperty("scientificName");
        } else if (this.genomeStanza.hasProperty("organism")) {
            config.name = this.genomeStanza.getProperty("organism");
        } else if (this.genomeStanza.hasProperty("description")) {
            config.name = this.genomeStanza.getProperty("description");
        }
        config.name = config.name == null ? config.id : config.name + " (" + config.id + ")";
        config.twoBitURL = this.baseURL + this.genomeStanza.getProperty("twoBitPath");
        config.nameSet = "ucsc";
        config.wholeGenomeView = false;
        if (this.genomeStanza.hasProperty("defaultPos")) {
            config.defaultPos = this.genomeStanza.getProperty("defaultPos");
        }
        config.description = config.id;
        if (this.genomeStanza.hasProperty("blat")) {
            config.blat = this.baseURL + this.genomeStanza.getProperty("blat");
        }
        if (this.genomeStanza.hasProperty("chromAliasBb")) {
            config.chromAliasBbURL = this.baseURL + this.genomeStanza.getProperty("chromAliasBb");
        }
        if (this.genomeStanza.hasProperty("twoBitBptURL")) {
            config.twoBitBptURL = this.baseURL + this.genomeStanza.getProperty("twoBitBptURL");
        }
        if (this.genomeStanza.hasProperty("twoBitBptUrl")) {
            config.twoBitBptURL = this.baseURL + this.genomeStanza.getProperty("twoBitBptUrl");
        }
        if (this.genomeStanza.hasProperty("description")) {
            config.description = config.description + "\n" + this.genomeStanza.getProperty("description");
        }
        if (this.genomeStanza.hasProperty("organism")) {
            config.description = config.description + "\n" + this.genomeStanza.getProperty("organism");
        }
        if (this.genomeStanza.hasProperty("scientificName")) {
            config.description = config.description + "\n" + this.genomeStanza.getProperty("scientificName");
        }
        if (this.genomeStanza.hasProperty("htmlPath")) {
            config.infoURL = this.baseURL + this.genomeStanza.getProperty("htmlPath");
        }
        for (Stanza t2 : this.trackStanzas) {
            if (!"cytoBandIdeo".equals(t2.name) || !t2.hasProperty("bigDataUrl")) continue;
            config.cytobandBbURL = this.baseURL + t2.getProperty("bigDataUrl");
            break;
        }
        if (includeTracks) {
            Function<Stanza, Boolean> filter = t -> !filterTracks.contains(t.name) && !"hide".equals(t.getProperty("visibility"));
            config.tracks = this.getTracksConfigs(filter);
        }
        return config;
    }

    public List<TrackConfigGroup> getGroupedTrackConfigurations() {
        LinkedHashMap trackConfigMap = new LinkedHashMap();
        Function<Stanza, Boolean> filter = stanza -> !stanza.name.equals("cytoBandIdeo");
        for (TrackConfig trackConfig : this.getTracksConfigs(filter)) {
            String groupName;
            String string = groupName = trackConfig.group != null ? trackConfig.group : "other";
            if (!trackConfigMap.containsKey(groupName)) {
                trackConfigMap.put(groupName, new ArrayList());
            }
            ((List)trackConfigMap.get(groupName)).add(trackConfig);
        }
        HashMap<String, String> groupNamesMap = new HashMap<String, String>();
        if (this.groupStanzas != null) {
            for (Stanza groupStanza : this.groupStanzas) {
                groupNamesMap.put(groupStanza.getProperty("name"), groupStanza.getProperty("label"));
            }
        }
        ArrayList<TrackConfigGroup> arrayList = new ArrayList<TrackConfigGroup>();
        for (Map.Entry entry : trackConfigMap.entrySet()) {
            String group = (String)entry.getKey();
            String label = groupNamesMap.containsKey(group) ? (String)groupNamesMap.get(group) : group;
            arrayList.add(new TrackConfigGroup(label, (List)entry.getValue()));
        }
        return arrayList;
    }

    List<TrackConfig> getTracksConfigs(Function<Stanza, Boolean> filter) {
        return this.trackStanzas.stream().filter(t -> supportedTypes.contains(t.format()) && t.hasProperty("bigDataUrl") && (filter == null || (Boolean)filter.apply((Stanza)t) != false)).map(t -> this.getTrackConfig((Stanza)t)).toList();
    }

    TrackConfig getTrackConfig(Stanza t) {
        String c;
        String[] tokens;
        String format = t.format();
        String url = this.baseURL + t.getProperty("bigDataUrl");
        TrackConfig config = new TrackConfig(url);
        config.panelName = "DataPanel";
        config.id = t.getProperty("track");
        config.name = t.getProperty("shortLabel");
        config.url = this.baseURL + t.getProperty("bigDataUrl");
        if ("vcfTabix".equals(format)) {
            config.indexURL = config.url + ".tbi";
        }
        if (t.hasProperty("longLabel") && t.hasProperty("html")) {
            config.description = "<a target=\"_blank\" href=\"" + this.baseURL + t.getProperty("html") + "\">" + t.getProperty("longLabel") + "</a>";
        } else if (t.hasProperty("longLabel")) {
            config.description = t.getProperty("longLabel");
        }
        if (t.hasProperty("html")) {
            config.html = this.baseURL + t.getProperty("html");
        }
        config.visible = !"hide".equals(t.getProperty("visibility"));
        if (t.hasProperty("autoScale")) {
            config.autoscale = t.getProperty("autoScale").toLowerCase().equals("on");
        }
        if (t.hasProperty("maxHeightPixels")) {
            tokens = t.getProperty("maxHeightPixels").split(":");
            config.maxHeight = Integer.parseInt(tokens[0]);
            config.height = Integer.parseInt(tokens[1]);
            config.minHeight = Integer.parseInt(tokens[2]);
        }
        if (t.hasProperty("color")) {
            c = t.getProperty("color");
            Object object = config.color = c.indexOf(",") > 0 ? "rgb(" + c + ")" : c;
        }
        if (t.hasProperty("altColor")) {
            c = t.getProperty("altColor");
            Object object = config.altColor = c.indexOf(",") > 0 ? "rgb(" + c + ")" : c;
        }
        if (t.hasProperty("viewLimits")) {
            tokens = t.getProperty("viewLimits").split(":");
            config.min = Float.valueOf(Float.parseFloat(tokens[0]));
            if (tokens.length > 1) {
                config.max = Float.valueOf(Float.parseFloat(tokens[1]));
            }
        }
        if (t.hasProperty("itemRgb")) {
            // empty if block
        }
        if ("hide".equals(t.getProperty("visibility"))) {
            config.visible = false;
        }
        if (t.hasProperty("url")) {
            config.infoURL = t.getProperty("url");
        }
        if (t.hasProperty("searchIndex")) {
            config.searchIndex = t.getProperty("searchIndex");
        }
        if (t.hasProperty("searchTrix")) {
            config.searchTrix = this.baseURL + t.getProperty("searchTrix");
        }
        if (t.hasProperty("group")) {
            config.group = t.getProperty("group");
            if (this.groupPriorityMap != null && this.groupPriorityMap.containsKey(config.group)) {
                int nextPriority = this.groupPriorityMap.get(config.group) + 1;
                config.order = nextPriority;
                this.groupPriorityMap.put(config.group, nextPriority);
            }
        }
        return config;
    }

    public String getUrl() {
        return this.url;
    }

    static String firstWord(String str) {
        return Globals.whitespacePattern.split(str)[0];
    }

    static class Stanza {
        private final String type;
        private final String name;
        private final int order;
        private Map<String, String> properties;
        Stanza parent;

        Stanza(int order, String type, String name) {
            this.order = order;
            this.type = type;
            this.name = name;
            this.properties = new HashMap<String, String>();
        }

        void setProperty(String key, String value) {
            this.properties.put(key, value);
        }

        String getProperty(String key) {
            if (this.properties.containsKey(key)) {
                return this.properties.get(key);
            }
            if (this.parent != null) {
                return this.parent.getProperty(key);
            }
            return null;
        }

        boolean hasProperty(String key) {
            if (this.properties.containsKey(key)) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.hasProperty(key);
            }
            return false;
        }

        String format() {
            String type = this.getProperty("type");
            if (type != null) {
                return Hub.firstWord(type);
            }
            return null;
        }

        String displayMode() {
            String viz = this.getProperty("visibility");
            if (viz == null) {
                return "COLLAPSED";
            }
            switch (viz = viz.toLowerCase()) {
                case "dense": {
                    return "COLLAPSED";
                }
                case "pack": {
                    return "EXPANDED";
                }
                case "squish": {
                    return "SQUISHED";
                }
            }
            return "COLLAPSED";
        }
    }
}

