/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.bedpe.BedPERenderer;
import org.broad.igv.bedpe.BedPEShape;
import org.broad.igv.bedpe.InteractionTrack;
import org.broad.igv.track.RenderContext;

public class NestedArcRenderer
implements BedPERenderer {
    private Map<Color, Color> alphaColors = new HashMap<Color, Color>();
    InteractionTrack track;
    double theta = Math.toRadians(45.0);
    double sinTheta = Math.sin(this.theta);
    double cosTheta = Math.cos(this.theta);
    boolean autoscale = true;

    public NestedArcRenderer(InteractionTrack track) {
        this.track = track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(List<BedPE> features, RenderContext context, Rectangle trackRectangle) {
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            double origin = context.getOrigin();
            double locScale = context.getScale();
            Color trackColor = this.track.getColor();
            int gap = this.track.gap;
            if (this.track.thickness > 1) {
                g.setStroke(new BasicStroke(this.track.thickness));
            }
            if (this.autoscale) {
                double max = 0.0;
                for (BedPE feature : features) {
                    double pixelStart = ((double)feature.getStart() - origin) / locScale;
                    double pixelEnd = ((double)feature.getEnd() - origin) / locScale;
                    if (!(pixelEnd >= trackRectangle.getX()) || !(pixelStart <= trackRectangle.getMaxX())) continue;
                    max = Math.max(max, pixelEnd - pixelStart);
                }
                double a = Math.min((double)trackRectangle.width, max) / 2.0;
                if (max > 0.0) {
                    double coa = (double)(trackRectangle.height - gap) / a;
                    this.theta = SagittusEstimate.estimateTheta(coa);
                    this.sinTheta = Math.sin(this.theta);
                    this.cosTheta = Math.cos(this.theta);
                }
            }
            for (BedPE bedPE : features) {
                double p1 = ((double)bedPE.getStart() - origin) / locScale;
                double p2 = ((double)bedPE.getEnd() - origin) / locScale;
                if (!(p2 >= trackRectangle.getX()) || !(p1 <= trackRectangle.getMaxX())) continue;
                InteractionTrack.Direction direction = this.track.direction;
                if (bedPE.isSameChr()) {
                    BedPEFeature feature = bedPE.get();
                    Color fcolor = feature.color == null ? trackColor : feature.color;
                    double pixelStart = (feature.getMidStart() - origin) / locScale;
                    double pixelEnd = (feature.getMidEnd() - origin) / locScale;
                    int w = (int)(pixelEnd - pixelStart);
                    if (w < 3) {
                        w = 3;
                        pixelStart -= 1.0;
                    }
                    if (fcolor != null && w > trackRectangle.width) {
                        fcolor = this.getAlphaColor(fcolor, 0.1f);
                    }
                    if (fcolor != null) {
                        g.setColor(fcolor);
                    }
                    int trackBaseLine = trackRectangle.y + trackRectangle.height;
                    double a = w / 2;
                    double r = a / this.sinTheta;
                    double b = this.cosTheta * r;
                    double xc = pixelStart + a;
                    double yc = direction == InteractionTrack.Direction.UP ? (double)trackBaseLine + b : (double)(gap + trackRectangle.y) - b;
                    double angleSt = direction == InteractionTrack.Direction.UP ? 90.0 - Math.toDegrees(this.theta) : 270.0 - Math.toDegrees(this.theta);
                    double ext = Math.toDegrees(2.0 * this.theta);
                    Arc2D.Double arcPath = new Arc2D.Double();
                    arcPath.setArcByCenter(xc, yc, r, angleSt, ext, 0);
                    g.draw(arcPath);
                    feature.setShape(new NAShape(xc, yc, r));
                    continue;
                }
                Color fcolor = bedPE.get().color == null ? Color.black : bedPE.get().color;
                g.setColor(fcolor);
                int h = trackRectangle.height / 2;
                double ps = ((double)((bedPE.getStart() + bedPE.getEnd()) / 2) - origin) / locScale;
                int yBase = direction == InteractionTrack.Direction.UP ? trackRectangle.y + trackRectangle.height - h : trackRectangle.y + gap;
                g.drawLine((int)ps, yBase, (int)ps, yBase + h);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    private Color getAlphaColor(Color fcolor, float alpha) {
        Color ac = this.alphaColors.get(fcolor);
        if (ac == null) {
            float[] rgb = new float[3];
            rgb = fcolor.getRGBColorComponents(rgb);
            ac = new Color(rgb[0], rgb[1], rgb[2], alpha);
            this.alphaColors.put(fcolor, ac);
        }
        return ac;
    }

    static class SagittusEstimate {
        static final double[] coa = new double[]{0.01570925532366355, 0.15838444032453644, 0.3249196962329063, 0.5095254494944288, 0.7265425280053609, 0.9999999999999999};
        static final double[] theta = new double[]{0.031415926535897934, 0.3141592653589793, 0.6283185307179586, 0.9424777960769379, 1.2566370614359172, 1.5707963267948966};

        SagittusEstimate() {
        }

        static double estimateTheta(double x) {
            int idx;
            for (idx = 0; idx < coa.length && !(coa[idx] > x); ++idx) {
            }
            double left = idx == 0 ? 0.0 : coa[idx - 1];
            double right = idx < coa.length ? coa[idx] : 1.0;
            double r = (x - left) / (right - left);
            double thetaLeft = idx == 0 ? 0.0 : theta[idx - 1];
            double thetaRight = idx < theta.length ? theta[idx] : 1.5707963267948966;
            return thetaLeft + r * (thetaRight - thetaLeft);
        }

        static void generateTable(String[] args) {
            for (double theta = 0.3141592653589793; theta <= 1.5707963267948966; theta += 0.3141592653589793) {
                double num = 1.0 - Math.cos(theta);
                double denom = Math.sin(theta);
                double d = num / denom;
            }
        }
    }

    public static class NAShape
    implements BedPEShape {
        double xc;
        double yc;
        double r;

        public NAShape(double xc, double yc, double r) {
            this.xc = xc;
            this.yc = yc;
            this.r = r;
        }

        @Override
        public boolean contains(double x, double y) {
            double dx = x - this.xc;
            double dy = y - this.yc;
            double dist = Math.sqrt(dx * dx + dy * dy);
            return Math.abs(this.r - dist) <= 3.0;
        }
    }
}

