/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.BAIEntry;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.build.CRAMReferenceRegion;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.cram.structure.CRAMCompressionRecord;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CompressorCache;
import htsjdk.samtools.cram.structure.ContainerHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Container {
    private final ContainerHeader containerHeader;
    private final CompressionHeader compressionHeader;
    private final List<Slice> slices;
    private final long containerByteOffset;

    public Container(CompressionHeader compressionHeader, List<Slice> containerSlices, long containerByteOffset, long globalRecordCounter) {
        this.compressionHeader = compressionHeader;
        this.slices = containerSlices;
        this.containerByteOffset = containerByteOffset;
        ReferenceContext commonRefContext = Container.getDerivedReferenceContextFromSlices(this.slices);
        AlignmentContext alignmentContext = this.getDerivedAlignmentContext(commonRefContext);
        int baseCount = 0;
        int blockCount = 0;
        int recordCount = 0;
        for (Slice slice : this.slices) {
            recordCount += slice.getNumberOfRecords();
            blockCount += slice.getNumberOfBlocks();
            baseCount = (int)((long)baseCount + slice.getBaseCount());
        }
        this.containerHeader = new ContainerHeader(alignmentContext, blockCount, recordCount, globalRecordCounter, baseCount);
        this.checkSliceReferenceContexts(commonRefContext.getReferenceContextID());
    }

    public Container(ContainerHeader containerHeader, long containerByteOffset) {
        this.containerHeader = containerHeader;
        this.containerByteOffset = containerByteOffset;
        this.compressionHeader = null;
        this.slices = Collections.emptyList();
    }

    public Container(CRAMVersion cramVersion, InputStream inputStream, long containerByteOffset) {
        this.containerHeader = new ContainerHeader(cramVersion, inputStream);
        if (this.containerHeader.isEOF()) {
            this.compressionHeader = null;
            this.slices = Collections.EMPTY_LIST;
            this.containerByteOffset = containerByteOffset;
            try {
                byte[] eofBytes = new byte[this.containerHeader.getContainerBlocksByteSize()];
                inputStream.read(eofBytes, 0, this.containerHeader.getContainerBlocksByteSize());
            }
            catch (IOException e) {
                throw new RuntimeIOException("Malformed CRAM EOF block", e);
            }
            return;
        }
        this.containerByteOffset = containerByteOffset;
        this.compressionHeader = new CompressionHeader(cramVersion, inputStream);
        this.slices = new ArrayList<Slice>();
        for (int sliceCounter = 0; sliceCounter < this.containerHeader.getLandmarks().size(); ++sliceCounter) {
            Slice slice = new Slice(cramVersion, this.compressionHeader, inputStream, containerByteOffset);
            this.slices.add(slice);
        }
        this.distributeIndexingParametersToSlices();
        this.checkSliceReferenceContexts(this.getAlignmentContext().getReferenceContext().getReferenceContextID());
    }

    public int write(CRAMVersion cramVersion, OutputStream outputStream) {
        int n;
        ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
        try {
            this.getCompressionHeader().write(cramVersion, tempOutputStream);
            ArrayList<Integer> landmarks = new ArrayList<Integer>();
            for (Slice slice : this.getSlices()) {
                landmarks.add(tempOutputStream.size());
                slice.write(cramVersion, tempOutputStream);
            }
            this.getContainerHeader().setLandmarks(landmarks);
            this.getContainerHeader().setContainerBlocksByteSize(tempOutputStream.size());
            this.distributeIndexingParametersToSlices();
            int containerHeaderLength = this.getContainerHeader().write(cramVersion, outputStream);
            tempOutputStream.writeTo(outputStream);
            n = containerHeaderLength + this.getContainerHeader().getContainerBlocksByteSize();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tempOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        tempOutputStream.close();
        return n;
    }

    /*
     * Exception decompiling
     */
    public static SAMFileHeader readSAMFileHeaderContainer(CRAMVersion cramVersion, InputStream inputStream, String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long writeSAMFileHeaderContainer(CRAMVersion cramVersion, SAMFileHeader samFileHeader, OutputStream os) {
        long l;
        byte[] samFileHeaderBytes = CramIO.samHeaderToByteArray(samFileHeader);
        Block block = Block.createGZIPFileHeaderBlock(samFileHeaderBytes);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            block.write(cramVersion, byteArrayOutputStream);
            int containerBlocksByteSize = byteArrayOutputStream.size();
            ContainerHeader containerHeader = ContainerHeader.makeSAMFileHeaderContainer(containerBlocksByteSize);
            int containerHeaderByteSize = containerHeader.write(cramVersion, os);
            byteArrayOutputStream.writeTo(os);
            l = containerHeaderByteSize + containerHeader.getContainerBlocksByteSize();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        byteArrayOutputStream.close();
        return l;
    }

    public List<SAMRecord> getSAMRecords(ValidationStringency validationStringency, CRAMReferenceRegion cramReferenceRegion, CompressorCache compressorCache, SAMFileHeader samFileHeader) {
        ArrayList<SAMRecord> samRecords = new ArrayList<SAMRecord>(this.getContainerHeader().getNumberOfRecords());
        for (Slice slice : this.getSlices()) {
            ArrayList<CRAMCompressionRecord> cramCompressionRecords = slice.deserializeCRAMRecords(compressorCache, validationStringency);
            slice.normalizeCRAMRecords(cramCompressionRecords, cramReferenceRegion);
            for (CRAMCompressionRecord cramCompressionRecord : cramCompressionRecords) {
                SAMRecord samRecord = cramCompressionRecord.toSAMRecord(samFileHeader);
                samRecord.setValidationStringency(validationStringency);
                samRecords.add(samRecord);
            }
        }
        return samRecords;
    }

    public ContainerHeader getContainerHeader() {
        return this.containerHeader;
    }

    public CompressionHeader getCompressionHeader() {
        return this.compressionHeader;
    }

    public AlignmentContext getAlignmentContext() {
        return this.containerHeader.getAlignmentContext();
    }

    public long getContainerByteOffset() {
        return this.containerByteOffset;
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public boolean isEOF() {
        return this.containerHeader.isEOF() && (this.getSlices() == null || this.getSlices().size() == 0);
    }

    public List<CRAIEntry> getCRAIEntries(CompressorCache compressorCache) {
        if (this.isEOF()) {
            return Collections.emptyList();
        }
        return this.getSlices().stream().map(s -> s.getCRAIEntries(compressorCache)).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public List<BAIEntry> getBAIEntries(CompressorCache compressorCache) {
        if (this.isEOF()) {
            return Collections.emptyList();
        }
        return this.getSlices().stream().map(s -> s.getBAIEntries(compressorCache)).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    private void distributeIndexingParametersToSlices() {
        int lastSliceIndex = this.slices.size() - 1;
        for (int i = 0; i < lastSliceIndex; ++i) {
            Slice slice = this.slices.get(i);
            slice.setLandmarkIndex(i);
            slice.setByteOffsetOfSliceHeaderBlock(this.containerHeader.getLandmarks().get(i));
            slice.setByteSizeOfSliceBlocks(this.containerHeader.getLandmarks().get(i + 1) - slice.getByteOffsetOfSliceHeaderBlock());
        }
        Slice lastSlice = this.slices.get(lastSliceIndex);
        lastSlice.setLandmarkIndex(lastSliceIndex);
        lastSlice.setByteOffsetOfSliceHeaderBlock(this.containerHeader.getLandmarks().get(lastSliceIndex));
        lastSlice.setByteSizeOfSliceBlocks(this.containerHeader.getContainerBlocksByteSize() - lastSlice.getByteOffsetOfSliceHeaderBlock());
    }

    private void checkSliceReferenceContexts(int actualReferenceContextID) {
        if (actualReferenceContextID == -2) {
            for (Slice slice : this.getSlices()) {
                if (slice.getAlignmentContext().getReferenceContext().getReferenceContextID() == -2) continue;
                throw new CRAMException(String.format("Found slice with reference context (%d). Multi-reference container can only contain multi-ref slices.", slice.getAlignmentContext().getReferenceContext().getReferenceContextID()));
            }
        }
    }

    private final AlignmentContext getDerivedAlignmentContext(ReferenceContext commonRefContext) {
        int alignmentStart = 0;
        int alignmentSpan = 0;
        if (commonRefContext.isMappedSingleRef()) {
            int start = Integer.MAX_VALUE;
            int endPlusOne = Integer.MIN_VALUE;
            for (Slice slice : this.slices) {
                AlignmentContext alignmentContext = slice.getAlignmentContext();
                start = Math.min(start, alignmentContext.getAlignmentStart());
                endPlusOne = Math.max(endPlusOne, alignmentContext.getAlignmentStart() + alignmentContext.getAlignmentSpan());
            }
            alignmentStart = start;
            alignmentSpan = endPlusOne - start;
        } else {
            if (commonRefContext.isUnmappedUnplaced()) {
                return AlignmentContext.UNMAPPED_UNPLACED_CONTEXT;
            }
            if (commonRefContext.isMultiRef()) {
                return AlignmentContext.MULTIPLE_REFERENCE_CONTEXT;
            }
        }
        AlignmentContext.validateAlignmentContext(true, commonRefContext, alignmentStart, alignmentSpan);
        return new AlignmentContext(commonRefContext, alignmentStart, alignmentSpan);
    }

    private static ReferenceContext getDerivedReferenceContextFromSlices(List<Slice> containerSlices) {
        Set sliceRefContexts = containerSlices.stream().map(s -> s.getAlignmentContext().getReferenceContext()).collect(Collectors.toSet());
        if (sliceRefContexts.isEmpty()) {
            throw new CRAMException("Cannot construct a container without any slices");
        }
        if (sliceRefContexts.size() > 1) {
            return ReferenceContext.MULTIPLE_REFERENCE_CONTEXT;
        }
        return (ReferenceContext)sliceRefContexts.iterator().next();
    }

    public String toString() {
        return String.format("%s offset %d nSlices %d", this.containerHeader.toString(), this.getContainerByteOffset(), this.getSlices() == null ? -1 : this.getSlices().size());
    }
}

