/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.SAMTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.LinkedAlignment;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.PackedAlignments;
import org.broad.igv.sam.PairedAlignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.Row;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.ReferenceFrame;

public class AlignmentPacker {
    private static final Logger log = LogManager.getLogger(AlignmentPacker.class);
    public static final int MIN_ALIGNMENT_SPACING = 2;
    private static final Comparator<Alignment> lengthComparator = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment row1, Alignment row2) {
            return row2.getEnd() - row2.getStart() - (row1.getEnd() - row2.getStart());
        }
    };
    private static final String NULL_GROUP_VALUE = "";
    public static final int tenMB = 10000000;

    public PackedAlignments packAlignments(AlignmentInterval interval, AlignmentTrack.RenderOptions renderOptions, ReferenceFrame referenceFrame, Track.DisplayMode displayMode) {
        LinkedHashMap<String, List<Row>> packedAlignments = new LinkedHashMap<String, List<Row>>();
        List<Alignment> alList = interval.getAlignments();
        if (renderOptions.isLinkedReads()) {
            alList = this.linkByTag(alList, renderOptions.getLinkByTag());
        }
        if (renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.NONE) {
            ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
            if (displayMode == Track.DisplayMode.FULL) {
                this.packFull(alList, renderOptions, alignmentRows, referenceFrame);
            } else {
                this.packDense(alList, renderOptions, alignmentRows);
            }
            packedAlignments.put(NULL_GROUP_VALUE, alignmentRows);
        } else {
            HashMap<Object, List> groupedAlignments = new HashMap<Object, List>();
            for (Alignment alignment : alList) {
                Object groupKey = this.getGroupValue(alignment, renderOptions);
                if (groupKey == null) {
                    groupKey = NULL_GROUP_VALUE;
                }
                List groupList = groupedAlignments.computeIfAbsent(groupKey, k -> new ArrayList(1000));
                groupList.add(alignment);
            }
            ArrayList keys = new ArrayList(groupedAlignments.keySet());
            Comparator<Object> groupComparator = this.getGroupComparator(renderOptions.getGroupByOption());
            if (renderOptions.getGroupByOption().reverse) {
                groupComparator = groupComparator.reversed();
            }
            if (renderOptions.isInvertGroupSorting()) {
                groupComparator = groupComparator.reversed();
            }
            keys.sort(groupComparator);
            for (Object key : keys) {
                ArrayList<Row> alignmentRows = new ArrayList<Row>(10000);
                List group = (List)groupedAlignments.get(key);
                if (displayMode == Track.DisplayMode.FULL) {
                    this.packFull(group, renderOptions, alignmentRows, referenceFrame);
                } else {
                    this.packDense(group, renderOptions, alignmentRows);
                }
                packedAlignments.put(key.toString(), alignmentRows);
            }
        }
        ArrayList<AlignmentInterval> tmp = new ArrayList<AlignmentInterval>();
        tmp.add(interval);
        return new PackedAlignments(tmp, packedAlignments);
    }

    private void packDense(List<Alignment> alList, AlignmentTrack.RenderOptions renderOptions, List<Row> alignmentRows) {
        HashMap<String, PairedAlignment> pairs = null;
        boolean isPairedAlignments = renderOptions.isViewPairs();
        if (isPairedAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        int totalCount = 0;
        if (alList == null || alList.size() == 0) {
            return;
        }
        Range curRange = this.getAlignmentListRange(alList);
        int bpLength = curRange.getLength();
        BucketCollection bucketCollection = bpLength < 10000000 ? new DenseBucketCollection(bpLength, curRange) : new SparseBucketCollection(curRange);
        int curRangeStart = curRange.getStart();
        for (Alignment al : alList) {
            int bucketNumber;
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (isPairedAlignments && this.isPairable(al)) {
                String readName = al.getReadName();
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if ((bucketNumber = Math.max(0, al.getStart() - curRangeStart)) < bucketCollection.getBucketCount()) {
                PriorityQueue<Alignment> bucket = bucketCollection.get(bucketNumber);
                if (bucket == null) {
                    bucket = new PriorityQueue<Alignment>(5, lengthComparator);
                    bucketCollection.set(bucketNumber, bucket);
                }
                bucket.add(alignment);
                ++totalCount;
                continue;
            }
            log.debug("Alignment out of bounds. name: " + alignment.getReadName() + " startPos:" + alignment.getStart());
        }
        bucketCollection.finishedAdding();
        long t0 = System.currentTimeMillis();
        int allocatedCount = 0;
        Row currentRow = new Row();
        while (allocatedCount < totalCount) {
            PriorityQueue<Alignment> bucket;
            curRange = bucketCollection.getRange();
            int nextStart = curRangeStart = curRange.getStart();
            ArrayList<Integer> emptyBuckets = new ArrayList<Integer>(100);
            do {
                int bucketNumber;
                if ((bucket = bucketCollection.getNextBucket(bucketNumber = nextStart - curRangeStart, emptyBuckets)) == null) continue;
                Alignment alignment = (Alignment)bucket.remove();
                currentRow.addAlignment(alignment);
                ++allocatedCount;
                nextStart = alignment.getEnd() + 2;
            } while (bucket != null && nextStart <= curRange.getEnd());
            bucketCollection.removeBuckets(emptyBuckets);
            emptyBuckets.clear();
            if (currentRow.alignments.size() > 0) {
                alignmentRows.add(currentRow);
            }
            currentRow = new Row();
        }
        if (log.isDebugEnabled()) {
            long dt = System.currentTimeMillis() - t0;
            log.debug("Packed alignments in " + dt);
        }
        if (currentRow != null && currentRow.alignments.size() > 0) {
            alignmentRows.add(currentRow);
        }
    }

    private void packFull(List<Alignment> alList, AlignmentTrack.RenderOptions renderOptions, List<Row> alignmentRows, ReferenceFrame referenceFrame) {
        HashMap<String, PairedAlignment> pairs = null;
        boolean isPairedAlignments = renderOptions.isViewPairs();
        if (isPairedAlignments) {
            pairs = new HashMap<String, PairedAlignment>(1000);
        }
        Range genomicRange = referenceFrame.getCurrentRange();
        for (Alignment al : alList) {
            if (!al.isMapped()) continue;
            Alignment alignment = al;
            if (isPairedAlignments && this.isPairable(al)) {
                String readName = al.getReadName();
                PairedAlignment pair = (PairedAlignment)pairs.get(readName);
                if (pair == null) {
                    pair = new PairedAlignment(al);
                    pairs.put(readName, pair);
                    alignment = pair;
                } else {
                    pair.setSecondAlignment(al);
                    pairs.remove(readName);
                    continue;
                }
            }
            if (alignment.getEnd() <= genomicRange.start || alignment.getStart() >= genomicRange.end) continue;
            Row row = new Row();
            row.addAlignment(alignment);
            alignmentRows.add(row);
        }
    }

    private boolean isPairable(Alignment al) {
        return al.isPrimary() && al.isPaired() && al.getMate().isMapped() && al.getMate().getChr().equals(al.getChr());
    }

    private List<Alignment> linkByTag(List<Alignment> alList, String tag) {
        ArrayList<Alignment> bcList = new ArrayList<Alignment>(alList.size() / 10);
        HashMap<Object, LinkedAlignment> map = new HashMap<Object, LinkedAlignment>(bcList.size() * 2);
        for (Alignment a : alList) {
            if (a.isPrimary()) {
                Object bc = "READNAME".equals(tag) ? a.getReadName() : a.getAttribute(tag);
                if (bc == null) {
                    bcList.add(a);
                    continue;
                }
                LinkedAlignment linkedAlignment = (LinkedAlignment)map.get(bc);
                if (linkedAlignment == null) {
                    linkedAlignment = new LinkedAlignment(tag, bc.toString());
                    map.put(bc, linkedAlignment);
                    bcList.add(linkedAlignment);
                }
                linkedAlignment.addAlignment(a);
                continue;
            }
            bcList.add(a);
        }
        ArrayList<Alignment> delinkedList = new ArrayList<Alignment>(alList.size());
        for (Alignment a : bcList) {
            if (a instanceof LinkedAlignment) {
                List<Alignment> alignments = ((LinkedAlignment)a).alignments;
                if (alignments.size() == 1) {
                    delinkedList.add(alignments.get(0));
                    continue;
                }
                a.finish();
                delinkedList.add(a);
                continue;
            }
            delinkedList.add(a);
        }
        return delinkedList;
    }

    private Range getAlignmentListRange(List<Alignment> alignmentsList) {
        if (alignmentsList == null || alignmentsList.size() == 0) {
            return null;
        }
        Alignment firstAlignment = alignmentsList.get(0);
        int minStart = firstAlignment.getStart();
        int maxEnd = firstAlignment.getEnd();
        for (Alignment alignment : alignmentsList) {
            maxEnd = Math.max(maxEnd, alignment.getEnd());
        }
        return new Range(firstAlignment.getChr(), minStart, maxEnd);
    }

    private Comparator<Object> getGroupComparator(AlignmentTrack.GroupOption groupByOption) {
        switch (groupByOption) {
            case PAIR_ORIENTATION: {
                return new PairOrientationComparator();
            }
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o1 instanceof String && AlignmentPacker.NULL_GROUP_VALUE.equals(o1)) {
                    return 1;
                }
                if (o2 instanceof String && AlignmentPacker.NULL_GROUP_VALUE.equals(o2)) {
                    return -1;
                }
                if (o1 instanceof Integer && o2 instanceof Integer) {
                    Integer i1 = (Integer)o1;
                    Integer i2 = (Integer)o2;
                    return i1.compareTo(i2);
                }
                if (o1 instanceof Float && o2 instanceof Float) {
                    Float f1 = (Float)o1;
                    Float f2 = (Float)o2;
                    return f1.compareTo(f2);
                }
                if (o1 instanceof Double && o2 instanceof Double) {
                    Double d1 = (Double)o1;
                    Double d2 = (Double)o2;
                    return d1.compareTo(d2);
                }
                String s1 = o1.toString();
                String s2 = o2.toString();
                return s1.compareToIgnoreCase(s2);
            }
        };
    }

    private Object getGroupValue(Alignment al, AlignmentTrack.RenderOptions renderOptions) {
        AlignmentTrack.GroupOption groupBy = renderOptions.getGroupByOption();
        String tag = renderOptions.getGroupByTag();
        Range pos = renderOptions.getGroupByPos();
        return switch (groupBy) {
            default -> throw new IncompatibleClassChangeError();
            case AlignmentTrack.GroupOption.CLUSTER -> al.getClusterName();
            case AlignmentTrack.GroupOption.STRAND -> {
                if (al.isNegativeStrand()) {
                    yield "-";
                }
                yield "+";
            }
            case AlignmentTrack.GroupOption.SAMPLE -> al.getSample();
            case AlignmentTrack.GroupOption.LIBRARY -> al.getLibrary();
            case AlignmentTrack.GroupOption.READ_GROUP -> al.getReadGroup();
            case AlignmentTrack.GroupOption.LINKED -> {
                if (al instanceof LinkedAlignment) {
                    yield "Linked";
                }
                yield NULL_GROUP_VALUE;
            }
            case AlignmentTrack.GroupOption.PHASE -> al.getAttribute("HP");
            case AlignmentTrack.GroupOption.TAG -> {
                Object tagValue;
                Object v1 = tagValue = tag == null ? null : al.getAttribute(tag);
                if (tagValue == null) {
                    yield null;
                }
                if (tagValue instanceof Integer || tagValue instanceof Float || tagValue instanceof Double) {
                    yield tagValue;
                }
                yield tagValue.toString();
            }
            case AlignmentTrack.GroupOption.FIRST_OF_PAIR_STRAND -> {
                Strand strand = al.getFirstOfPairStrand();
                if (strand == Strand.NONE) {
                    yield null;
                }
                yield strand.toString();
            }
            case AlignmentTrack.GroupOption.READ_ORDER -> {
                if (al.isPaired() && al.isFirstOfPair()) {
                    yield "FIRST";
                }
                if (al.isPaired() && al.isSecondOfPair()) {
                    yield "SECOND";
                }
                yield NULL_GROUP_VALUE;
            }
            case AlignmentTrack.GroupOption.PAIR_ORIENTATION -> {
                PEStats peStats = AlignmentRenderer.getPEStats(al, renderOptions);
                AlignmentTrack.OrientationType type = AlignmentRenderer.getOrientationType(al, peStats);
                if (type == null) {
                    yield AlignmentTrack.OrientationType.UNKNOWN.name();
                }
                yield type.name();
            }
            case AlignmentTrack.GroupOption.MATE_CHROMOSOME -> {
                ReadMate mate = al.getMate();
                if (mate == null) {
                    yield null;
                }
                if (!mate.isMapped()) {
                    yield "UNMAPPED";
                }
                yield mate.getChr();
            }
            case AlignmentTrack.GroupOption.NONE -> null;
            case AlignmentTrack.GroupOption.CHIMERIC -> {
                if (al.getAttribute(SAMTag.SA.name()) != null) {
                    yield "CHIMERIC";
                }
                yield NULL_GROUP_VALUE;
            }
            case AlignmentTrack.GroupOption.SUPPLEMENTARY -> {
                if (al.isSupplementary()) {
                    yield "SUPPLEMENTARY";
                }
                yield NULL_GROUP_VALUE;
            }
            case AlignmentTrack.GroupOption.REFERENCE_CONCORDANCE -> {
                if (!al.isProperPair() || al.getCigarString().toUpperCase().contains("S") || al.isSupplementary()) {
                    yield "DISCORDANT";
                }
                yield NULL_GROUP_VALUE;
            }
            case AlignmentTrack.GroupOption.BASE_AT_POS -> {
                if (pos != null && al.getChr().equals(pos.getChr()) && al.getAlignmentStart() <= pos.getStart() && al.getAlignmentEnd() > pos.getStart()) {
                    byte[] baseAtPos = new byte[]{al.getBase(pos.getStart())};
                    if (baseAtPos[0] == 0) {
                        yield "2:";
                    }
                    yield "1:" + new String(baseAtPos);
                }
                yield "3:";
            }
            case AlignmentTrack.GroupOption.INSERTION_AT_POS -> {
                if (pos != null && al.getChr().equals(pos.getChr()) && al.getAlignmentStart() <= pos.getStart() && al.getAlignmentEnd() > pos.getStart()) {
                    AlignmentBlock rightInsertion;
                    int insertionBaseCount = 0;
                    AlignmentBlock leftInsertion = al.getInsertionAt(pos.getStart() + 1);
                    if (leftInsertion != null) {
                        insertionBaseCount += leftInsertion.getLength();
                    }
                    if ((rightInsertion = al.getInsertionAt(pos.getStart())) != null) {
                        insertionBaseCount += rightInsertion.getLength();
                    }
                    yield insertionBaseCount;
                }
                yield 0;
            }
            case AlignmentTrack.GroupOption.MOVIE -> {
                String[] readNameParts = al.getReadName().split("/");
                if (readNameParts.length < 3) {
                    yield NULL_GROUP_VALUE;
                }
                String movieName = readNameParts[0];
                yield movieName;
            }
            case AlignmentTrack.GroupOption.ZMW -> {
                String[] readNameParts = al.getReadName().split("/");
                if (readNameParts.length < 3) {
                    yield NULL_GROUP_VALUE;
                }
                String movieName = readNameParts[0];
                String zmw = readNameParts[1];
                yield movieName + "/" + zmw;
            }
            case AlignmentTrack.GroupOption.MAPPING_QUALITY -> al.getMappingQuality();
            case AlignmentTrack.GroupOption.DUPLICATE -> al.isDuplicate() ? "duplicate" : "non-duplicate";
        };
    }

    static class DenseBucketCollection
    implements BucketCollection {
        Range range;
        int lastBucketNumber = -1;
        final PriorityQueue[] bucketArray;

        DenseBucketCollection(int bucketCount, Range range) {
            this.bucketArray = new PriorityQueue[bucketCount];
            this.range = range;
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            this.bucketArray[idx] = bucket;
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.bucketArray[idx];
        }

        @Override
        public int getBucketCount() {
            return this.bucketArray.length;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            if (bucketNumber == this.lastBucketNumber) {
                // empty if block
            }
            PriorityQueue bucket = null;
            while (bucketNumber < this.bucketArray.length) {
                if (bucketNumber < 0) {
                    log.warn("Negative bucket number: " + bucketNumber);
                }
                if ((bucket = this.bucketArray[bucketNumber]) != null) {
                    if (bucket.isEmpty()) {
                        this.bucketArray[bucketNumber] = null;
                    } else {
                        return bucket;
                    }
                }
                ++bucketNumber;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
        }

        @Override
        public void finishedAdding() {
        }
    }

    static class SparseBucketCollection
    implements BucketCollection {
        Range range;
        boolean finished = false;
        List<Integer> keys;
        final HashMap<Integer, PriorityQueue<Alignment>> buckets;

        SparseBucketCollection(Range range) {
            this.range = range;
            this.buckets = new HashMap(1000);
        }

        @Override
        public void set(int idx, PriorityQueue<Alignment> bucket) {
            if (this.finished) {
                log.error("Error: bucket added after finishAdding() called");
            }
            this.buckets.put(idx, bucket);
        }

        @Override
        public PriorityQueue<Alignment> get(int idx) {
            return this.buckets.get(idx);
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public PriorityQueue<Alignment> getNextBucket(int bucketNumber, Collection<Integer> emptyBuckets) {
            Integer key;
            PriorityQueue<Alignment> bucket = null;
            int min = 0;
            int max = this.keys.size() - 1;
            while (max - min > 5) {
                int mid = (max + min) / 2;
                key = this.keys.get(mid);
                if (key > bucketNumber) {
                    max = mid;
                    continue;
                }
                min = mid;
            }
            for (int i = min; i < this.keys.size(); ++i) {
                key = this.keys.get(i);
                if (key < bucketNumber) continue;
                bucket = this.buckets.get(key);
                if (bucket.isEmpty()) {
                    emptyBuckets.add(key);
                    bucket = null;
                    continue;
                }
                return bucket;
            }
            return null;
        }

        @Override
        public void removeBuckets(Collection<Integer> emptyBuckets) {
            if (emptyBuckets.isEmpty()) {
                return;
            }
            for (Integer i : emptyBuckets) {
                this.buckets.remove(i);
            }
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public void finishedAdding() {
            this.finished = true;
            this.keys = new ArrayList<Integer>(this.buckets.keySet());
            Collections.sort(this.keys);
        }

        @Override
        public int getBucketCount() {
            return Integer.MAX_VALUE;
        }
    }

    static interface BucketCollection {
        public Range getRange();

        public void set(int var1, PriorityQueue<Alignment> var2);

        public PriorityQueue<Alignment> get(int var1);

        public PriorityQueue<Alignment> getNextBucket(int var1, Collection<Integer> var2);

        public void removeBuckets(Collection<Integer> var1);

        public void finishedAdding();

        public int getBucketCount();
    }

    private static class PairOrientationComparator
    implements Comparator<Object> {
        private final List<AlignmentTrack.OrientationType> orientationTypes = Arrays.asList(AlignmentTrack.OrientationType.values());

        @Override
        public int compare(Object o0, Object o1) {
            String s0 = o0.toString();
            String s1 = o1.toString();
            if (s0 != null && s1 != null) {
                AlignmentTrack.OrientationType t0 = AlignmentTrack.OrientationType.valueOf(s0);
                AlignmentTrack.OrientationType t1 = AlignmentTrack.OrientationType.valueOf(s1);
                return this.orientationTypes.indexOf((Object)t0) - this.orientationTypes.indexOf((Object)t1);
            }
            if (s0 == null ^ s1 == null) {
                return s0 == null ? 1 : -1;
            }
            return 0;
        }
    }
}

